/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.getblock;

import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.dimension.DimensionType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Level.class}, priority=1100)
abstract class LevelMixin
implements LevelAccessor,
AutoCloseable {
    @Unique
    private int height;
    @Unique
    private int minBuildHeight;
    @Unique
    private int maxBuildHeight;
    @Unique
    private int minSection;
    @Unique
    private int maxSection;
    @Unique
    private int sectionsCount;

    LevelMixin() {
    }

    @Inject(method={"<init>"}, at={@At(value="CTOR_HEAD")})
    private void init(CallbackInfo ci, @Local(ordinal=0, argsOnly=true) Holder<DimensionType> dimensionTypeHolder) {
        DimensionType dimType = (DimensionType)dimensionTypeHolder.value();
        this.height = dimType.height();
        this.minBuildHeight = dimType.minY();
        this.maxBuildHeight = this.minBuildHeight + this.height;
        this.minSection = this.minBuildHeight >> 4;
        this.maxSection = (this.maxBuildHeight - 1 >> 4) + 1;
        this.sectionsCount = this.maxSection - this.minSection;
    }

    public int getHeight() {
        return this.height;
    }

    public int getMinBuildHeight() {
        return this.minBuildHeight;
    }

    public int getMaxBuildHeight() {
        return this.maxBuildHeight;
    }

    public int getMinSection() {
        return this.minSection;
    }

    public int getMaxSection() {
        return this.maxSection;
    }

    public boolean isOutsideBuildHeight(int y) {
        return y < this.minBuildHeight || y >= this.maxBuildHeight;
    }

    public boolean isOutsideBuildHeight(BlockPos blockPos) {
        return this.isOutsideBuildHeight(blockPos.getY());
    }

    public int getSectionIndex(int blockY) {
        return (blockY >> 4) - this.minSection;
    }

    public int getSectionIndexFromSectionY(int sectionY) {
        return sectionY - this.minSection;
    }

    public int getSectionYFromSectionIndex(int sectionIdx) {
        return sectionIdx + this.minSection;
    }

    public int getSectionsCount() {
        return this.sectionsCount;
    }
}

