/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.fluid;

import ca.spottedleaf.moonrise.patches.collisions.block.CollisionBlockState;
import ca.spottedleaf.moonrise.patches.collisions.util.CollisionDirection;
import ca.spottedleaf.moonrise.patches.collisions.util.FluidOcclusionCacheKey;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={FlowingFluid.class})
abstract class FlowingFluidMixin
extends Fluid {
    @Shadow
    @Final
    public static BooleanProperty FALLING;
    @Shadow
    @Final
    public static IntegerProperty LEVEL;
    @Unique
    private FluidState sourceFalling;
    @Unique
    private FluidState sourceNotFalling;
    @Unique
    private static final int TOTAL_FLOWING_STATES;
    @Unique
    private static final int MIN_LEVEL;
    @Unique
    private FluidState[] flowingLookUp;
    @Unique
    private volatile boolean init;
    @Unique
    private static final int COLLISION_OCCLUSION_CACHE_SIZE = 2048;
    @Unique
    private static final FluidOcclusionCacheKey[] COLLISION_OCCLUSION_CACHE;

    FlowingFluidMixin() {
    }

    @Shadow
    public abstract Fluid getSource();

    @Shadow
    public abstract Fluid getFlowing();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Unique
    private void init() {
        FlowingFluidMixin flowingFluidMixin = this;
        synchronized (flowingFluidMixin) {
            if (this.init) {
                return;
            }
            this.flowingLookUp = new FluidState[TOTAL_FLOWING_STATES];
            FluidState defaultFlowState = this.getFlowing().defaultFluidState();
            for (int i = 0; i < TOTAL_FLOWING_STATES; ++i) {
                int falling = i & 1;
                int level = (i >>> 1) + MIN_LEVEL;
                this.flowingLookUp[i] = (FluidState)((FluidState)defaultFlowState.setValue((Property)FALLING, (Comparable)(falling == 1 ? Boolean.TRUE : Boolean.FALSE))).setValue((Property)LEVEL, (Comparable)Integer.valueOf(level));
            }
            FluidState defaultFallState = this.getSource().defaultFluidState();
            this.sourceFalling = (FluidState)defaultFallState.setValue((Property)FALLING, (Comparable)Boolean.TRUE);
            this.sourceNotFalling = (FluidState)defaultFallState.setValue((Property)FALLING, (Comparable)Boolean.FALSE);
            this.init = true;
        }
    }

    @Overwrite
    public FluidState getSource(boolean falling) {
        if (!this.init) {
            this.init();
        }
        return falling ? this.sourceFalling : this.sourceNotFalling;
    }

    @Overwrite
    public FluidState getFlowing(int amount, boolean falling) {
        if (!this.init) {
            this.init();
        }
        int index = (falling ? 1 : 0) | amount - MIN_LEVEL << 1;
        return this.flowingLookUp[index];
    }

    @Overwrite
    private boolean canPassThroughWall(Direction direction, BlockGetter level, BlockPos fromPos, BlockState fromState, BlockPos toPos, BlockState toState) {
        VoxelShape shape2;
        boolean result;
        FluidOcclusionCacheKey cached;
        if (((CollisionBlockState)fromState).moonrise$emptyCollisionShape() & ((CollisionBlockState)toState).moonrise$emptyCollisionShape()) {
            return true;
        }
        if (((CollisionBlockState)fromState).moonrise$occludesFullBlock() | ((CollisionBlockState)toState).moonrise$occludesFullBlock()) {
            return false;
        }
        FluidOcclusionCacheKey[] cache = ((CollisionBlockState)fromState).moonrise$hasCache() & ((CollisionBlockState)toState).moonrise$hasCache() ? COLLISION_OCCLUSION_CACHE : null;
        int keyIndex = (((CollisionBlockState)fromState).moonrise$uniqueId1() ^ ((CollisionBlockState)toState).moonrise$uniqueId2() ^ ((CollisionDirection)direction).moonrise$uniqueId()) & 0x7FF;
        if (cache != null && (cached = cache[keyIndex]) != null && cached.first() == fromState && cached.second() == toState && cached.direction() == direction) {
            return cached.result();
        }
        VoxelShape shape1 = fromState.getCollisionShape(level, fromPos);
        boolean bl = result = !Shapes.mergedFaceOccludes((VoxelShape)shape1, (VoxelShape)(shape2 = toState.getCollisionShape(level, toPos)), (Direction)direction);
        if (cache != null) {
            cache[keyIndex] = new FluidOcclusionCacheKey(fromState, toState, direction, result);
        }
        return result;
    }

    static {
        TOTAL_FLOWING_STATES = FALLING.getPossibleValues().size() * LEVEL.getPossibleValues().size();
        MIN_LEVEL = (Integer)LEVEL.getPossibleValues().stream().sorted().findFirst().get();
        COLLISION_OCCLUSION_CACHE = new FluidOcclusionCacheKey[2048];
    }
}

