/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.entity_tracker;

import ca.spottedleaf.moonrise.common.list.ReferenceList;
import ca.spottedleaf.moonrise.common.misc.NearbyPlayers;
import ca.spottedleaf.moonrise.common.util.TickThread;
import ca.spottedleaf.moonrise.patches.entity_tracker.EntityTrackerTrackedEntity;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.world.entity.Entity;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={ChunkMap.TrackedEntity.class})
abstract class TrackedEntityMixin
implements EntityTrackerTrackedEntity {
    @Shadow
    @Final
    private Set<ServerPlayerConnection> seenBy;
    @Shadow
    @Final
    private int range;
    @Shadow
    @Final
    Entity entity;
    @Unique
    private long lastChunkUpdate = -1L;
    @Unique
    private NearbyPlayers.TrackedChunk lastTrackedChunk;

    TrackedEntityMixin() {
    }

    @Shadow
    public abstract void updatePlayer(ServerPlayer var1);

    @Shadow
    public abstract void removePlayer(ServerPlayer var1);

    @Shadow
    protected abstract int scaledRange(int var1);

    @Override
    public final void moonrise$tick(NearbyPlayers.TrackedChunk chunk) {
        ServerPlayer player;
        if (chunk == null) {
            this.moonrise$clearPlayers();
            return;
        }
        ReferenceList<ServerPlayer> players = chunk.getPlayers(NearbyPlayers.NearbyMapType.VIEW_DISTANCE);
        if (players == null) {
            this.moonrise$clearPlayers();
            return;
        }
        long lastChunkUpdate = this.lastChunkUpdate;
        long currChunkUpdate = chunk.getUpdateCount();
        NearbyPlayers.TrackedChunk lastTrackedChunk = this.lastTrackedChunk;
        this.lastChunkUpdate = currChunkUpdate;
        this.lastTrackedChunk = chunk;
        ServerPlayer[] playersRaw = players.getRawDataUnchecked();
        int len = players.size();
        for (int i = 0; i < len; ++i) {
            player = playersRaw[i];
            this.updatePlayer(player);
        }
        if (lastChunkUpdate != currChunkUpdate || lastTrackedChunk != chunk) {
            for (ServerPlayerConnection conn : new ArrayList<ServerPlayerConnection>(this.seenBy)) {
                player = conn.getPlayer();
                if (players.contains(player)) continue;
                this.removePlayer(player);
            }
        }
    }

    @Override
    public final void moonrise$removeNonTickThreadPlayers() {
        boolean foundToRemove = false;
        for (ServerPlayerConnection conn : this.seenBy) {
            if (TickThread.isTickThreadFor((Entity)conn.getPlayer())) continue;
            foundToRemove = true;
            break;
        }
        if (!foundToRemove) {
            return;
        }
        for (ServerPlayerConnection conn : new ArrayList<ServerPlayerConnection>(this.seenBy)) {
            ServerPlayer player = conn.getPlayer();
            if (TickThread.isTickThreadFor((Entity)player)) continue;
            this.removePlayer(player);
        }
    }

    @Override
    public final void moonrise$clearPlayers() {
        this.lastChunkUpdate = -1L;
        this.lastTrackedChunk = null;
        if (this.seenBy.isEmpty()) {
            return;
        }
        for (ServerPlayerConnection conn : new ArrayList<ServerPlayerConnection>(this.seenBy)) {
            ServerPlayer player = conn.getPlayer();
            this.removePlayer(player);
        }
    }

    @Override
    public final boolean moonrise$hasPlayers() {
        return !this.seenBy.isEmpty();
    }

    @Redirect(method={"<init>"}, at=@At(value="INVOKE", target="Lcom/google/common/collect/Sets;newIdentityHashSet()Ljava/util/Set;"))
    private <E> Set<E> useBetterIdentitySet() {
        return new ReferenceOpenHashSet();
    }

    @Overwrite
    public int getEffectiveRange() {
        int range = this.range;
        Entity entity = this.entity;
        if (entity.getPassengers() == ImmutableList.of()) {
            return this.scaledRange(range);
        }
        List passengers = (List)entity.getIndirectPassengers();
        int len = passengers.size();
        for (int i = 0; i < len; ++i) {
            range = Math.max(range, ((Entity)passengers.get(i)).getType().clientTrackingRange() << 4);
        }
        return this.scaledRange(range);
    }
}

