/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.collisions;

import ca.spottedleaf.moonrise.patches.collisions.CollisionUtil;
import ca.spottedleaf.moonrise.patches.collisions.shape.CollisionVoxelShape;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import java.util.Arrays;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.ArrayVoxelShape;
import net.minecraft.world.phys.shapes.BitSetDiscreteVoxelShape;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CubeVoxelShape;
import net.minecraft.world.phys.shapes.DiscreteCubeMerger;
import net.minecraft.world.phys.shapes.DiscreteVoxelShape;
import net.minecraft.world.phys.shapes.IndexMerger;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Shapes.class})
abstract class ShapesMixin {
    @Shadow
    @Final
    private static VoxelShape BLOCK;
    @Shadow
    @Final
    private static VoxelShape EMPTY;
    @Unique
    private static final boolean DEBUG_SHAPE_MERGING = false;
    @Unique
    private static final DoubleArrayList[] PARTS_BY_BITS;

    ShapesMixin() {
    }

    @Shadow
    protected static int findBits(double d, double e) {
        return 0;
    }

    @Shadow
    protected static IndexMerger createIndexMerger(int i, DoubleList doubleList, DoubleList doubleList2, boolean bl, boolean bl2) {
        return null;
    }

    @Redirect(method={"<clinit>"}, at=@At(value="INVOKE", target="Lnet/minecraft/Util;make(Ljava/util/function/Supplier;)Ljava/lang/Object;"))
    private static Object forceArrayVoxelShape(Supplier<VoxelShape> supplier) {
        BitSetDiscreteVoxelShape shape = new BitSetDiscreteVoxelShape(1, 1, 1);
        shape.fill(0, 0, 0);
        return new ArrayVoxelShape((DiscreteVoxelShape)shape, (DoubleList)CollisionUtil.ZERO_ONE, (DoubleList)CollisionUtil.ZERO_ONE, (DoubleList)CollisionUtil.ZERO_ONE);
    }

    @Unique
    private static double[] generateCubeParts(int parts) {
        double inc = 1.0 / (double)parts;
        double[] ret = new double[parts + 1];
        double val = 0.0;
        for (int i = 0; i <= parts; ++i) {
            ret[i] = val;
            val += inc;
        }
        return ret;
    }

    @Overwrite
    public static VoxelShape create(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        if (!(maxX - minX < 1.0E-7 || maxY - minY < 1.0E-7 || maxZ - minZ < 1.0E-7)) {
            int bitsX = ShapesMixin.findBits(minX, maxX);
            int bitsY = ShapesMixin.findBits(minY, maxY);
            int bitsZ = ShapesMixin.findBits(minZ, maxZ);
            if (bitsX >= 0 && bitsY >= 0 && bitsZ >= 0) {
                if (bitsX == 0 && bitsY == 0 && bitsZ == 0) {
                    return BLOCK;
                }
                int sizeX = 1 << bitsX;
                int sizeY = 1 << bitsY;
                int sizeZ = 1 << bitsZ;
                BitSetDiscreteVoxelShape shape = BitSetDiscreteVoxelShape.withFilledBounds((int)sizeX, (int)sizeY, (int)sizeZ, (int)((int)Math.round(minX * (double)sizeX)), (int)((int)Math.round(minY * (double)sizeY)), (int)((int)Math.round(minZ * (double)sizeZ)), (int)((int)Math.round(maxX * (double)sizeX)), (int)((int)Math.round(maxY * (double)sizeY)), (int)((int)Math.round(maxZ * (double)sizeZ)));
                return new ArrayVoxelShape((DiscreteVoxelShape)shape, (DoubleList)PARTS_BY_BITS[bitsX], (DoubleList)PARTS_BY_BITS[bitsY], (DoubleList)PARTS_BY_BITS[bitsZ]);
            }
            return new ArrayVoxelShape(ShapesMixin.BLOCK.shape, (DoubleList)(minX == 0.0 && maxX == 1.0 ? CollisionUtil.ZERO_ONE : DoubleArrayList.wrap((double[])new double[]{minX, maxX})), (DoubleList)(minY == 0.0 && maxY == 1.0 ? CollisionUtil.ZERO_ONE : DoubleArrayList.wrap((double[])new double[]{minY, maxY})), (DoubleList)(minZ == 0.0 && maxZ == 1.0 ? CollisionUtil.ZERO_ONE : DoubleArrayList.wrap((double[])new double[]{minZ, maxZ})));
        }
        return EMPTY;
    }

    @Overwrite
    public static VoxelShape or(VoxelShape shape, VoxelShape ... others) {
        int size = others.length;
        if (size == 0) {
            return shape;
        }
        VoxelShape[] tmp = Arrays.copyOf(others, ++size);
        tmp[size - 1] = shape;
        while (size > 1) {
            int newSize = 0;
            for (int i = 0; i < size; i += 2) {
                int next = i + 1;
                if (next >= size) {
                    tmp[newSize++] = tmp[i];
                    break;
                }
                VoxelShape first = tmp[i];
                VoxelShape second = tmp[next];
                tmp[newSize++] = Shapes.joinUnoptimized((VoxelShape)first, (VoxelShape)second, (BooleanOp)BooleanOp.OR);
            }
            size = newSize;
        }
        return tmp[0].optimize();
    }

    @Unique
    private static VoxelShape joinUnoptimizedVanilla(VoxelShape voxelShape, VoxelShape voxelShape2, BooleanOp booleanOp) {
        if (booleanOp.apply(false, false)) {
            throw (IllegalArgumentException)Util.pauseInIde((Throwable)new IllegalArgumentException());
        }
        if (voxelShape == voxelShape2) {
            return booleanOp.apply(true, true) ? voxelShape : EMPTY;
        }
        boolean bl = booleanOp.apply(true, false);
        boolean bl2 = booleanOp.apply(false, true);
        if (voxelShape.isEmpty()) {
            return bl2 ? voxelShape2 : EMPTY;
        }
        if (voxelShape2.isEmpty()) {
            return bl ? voxelShape : EMPTY;
        }
        IndexMerger indexMerger = ShapesMixin.createIndexMerger(1, voxelShape.getCoords(Direction.Axis.X), voxelShape2.getCoords(Direction.Axis.X), bl, bl2);
        IndexMerger indexMerger2 = ShapesMixin.createIndexMerger(indexMerger.size() - 1, voxelShape.getCoords(Direction.Axis.Y), voxelShape2.getCoords(Direction.Axis.Y), bl, bl2);
        IndexMerger indexMerger3 = ShapesMixin.createIndexMerger((indexMerger.size() - 1) * (indexMerger2.size() - 1), voxelShape.getCoords(Direction.Axis.Z), voxelShape2.getCoords(Direction.Axis.Z), bl, bl2);
        BitSetDiscreteVoxelShape bitSetDiscreteVoxelShape = BitSetDiscreteVoxelShape.join((DiscreteVoxelShape)voxelShape.shape, (DiscreteVoxelShape)voxelShape2.shape, (IndexMerger)indexMerger, (IndexMerger)indexMerger2, (IndexMerger)indexMerger3, (BooleanOp)booleanOp);
        return indexMerger instanceof DiscreteCubeMerger && indexMerger2 instanceof DiscreteCubeMerger && indexMerger3 instanceof DiscreteCubeMerger ? new CubeVoxelShape((DiscreteVoxelShape)bitSetDiscreteVoxelShape) : new ArrayVoxelShape((DiscreteVoxelShape)bitSetDiscreteVoxelShape, indexMerger.getList(), indexMerger2.getList(), indexMerger3.getList());
    }

    @Overwrite
    public static VoxelShape join(VoxelShape first, VoxelShape second, BooleanOp mergeFunction) {
        VoxelShape ret = CollisionUtil.joinOptimized(first, second, mergeFunction);
        return ret;
    }

    @Inject(method={"joinUnoptimized"}, at={@At(value="HEAD")}, cancellable=true)
    private static void injectJoinUnoptimized(VoxelShape first, VoxelShape second, BooleanOp mergeFunction, CallbackInfoReturnable<VoxelShape> cir) {
        cir.setReturnValue((Object)ShapesMixin.joinUnoptimized(first, second, mergeFunction));
    }

    @Unique
    private static VoxelShape joinUnoptimized(VoxelShape first, VoxelShape second, BooleanOp mergeFunction) {
        VoxelShape ret = CollisionUtil.joinUnoptimized(first, second, mergeFunction);
        return ret;
    }

    @Inject(method={"joinIsNotEmpty(Lnet/minecraft/world/phys/shapes/VoxelShape;Lnet/minecraft/world/phys/shapes/VoxelShape;Lnet/minecraft/world/phys/shapes/BooleanOp;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private static void injectJoinIsNotEmpty(VoxelShape first, VoxelShape second, BooleanOp mergeFunction, CallbackInfoReturnable<Boolean> cir) {
        cir.setReturnValue((Object)ShapesMixin.joinIsNotEmpty(first, second, mergeFunction));
    }

    @Unique
    private static boolean joinIsNotEmpty(VoxelShape first, VoxelShape second, BooleanOp mergeFunction) {
        boolean ret = CollisionUtil.isJoinNonEmpty(first, second, mergeFunction);
        return ret;
    }

    @Overwrite
    public static VoxelShape getFaceShape(VoxelShape shape, Direction direction) {
        return ((CollisionVoxelShape)shape).moonrise$getFaceShapeClamped(direction);
    }

    @Unique
    private static boolean mergedMayOccludeBlock(VoxelShape shape1, VoxelShape shape2) {
        AABB bounds1 = shape1.bounds();
        AABB bounds2 = shape2.bounds();
        double minX = Math.min(bounds1.minX, bounds2.minX);
        double minY = Math.min(bounds1.minY, bounds2.minY);
        double minZ = Math.min(bounds1.minZ, bounds2.minZ);
        double maxX = Math.max(bounds1.maxX, bounds2.maxX);
        double maxY = Math.max(bounds1.maxY, bounds2.maxY);
        double maxZ = Math.max(bounds1.maxZ, bounds2.maxZ);
        return minX <= 1.0E-7 && maxX >= 0.9999999 && minY <= 1.0E-7 && maxY >= 0.9999999 && minZ <= 1.0E-7 && maxZ >= 0.9999999;
    }

    @Overwrite
    public static boolean mergedFaceOccludes(VoxelShape first, VoxelShape second, Direction direction) {
        boolean secondEmpty;
        if (((CollisionVoxelShape)first).moonrise$occludesFullBlockIfCached() || ((CollisionVoxelShape)second).moonrise$occludesFullBlockIfCached()) {
            return true;
        }
        if (first.isEmpty() & second.isEmpty()) {
            return false;
        }
        VoxelShape newFirst = ((CollisionVoxelShape)first).moonrise$getFaceShapeClamped(direction);
        VoxelShape newSecond = ((CollisionVoxelShape)second).moonrise$getFaceShapeClamped(direction.getOpposite());
        if (((CollisionVoxelShape)newFirst).moonrise$occludesFullBlockIfCached() || ((CollisionVoxelShape)newSecond).moonrise$occludesFullBlockIfCached()) {
            return true;
        }
        boolean firstEmpty = newFirst.isEmpty();
        if (firstEmpty & (secondEmpty = newSecond.isEmpty())) {
            return false;
        }
        if (firstEmpty | secondEmpty) {
            return secondEmpty ? ((CollisionVoxelShape)newFirst).moonrise$occludesFullBlock() : ((CollisionVoxelShape)newSecond).moonrise$occludesFullBlock();
        }
        if (newFirst == newSecond) {
            return ((CollisionVoxelShape)newFirst).moonrise$occludesFullBlock();
        }
        return ShapesMixin.mergedMayOccludeBlock(newFirst, newSecond) && ((CollisionVoxelShape)((CollisionVoxelShape)newFirst).moonrise$orUnoptimized(newSecond)).moonrise$occludesFullBlock();
    }

    @Overwrite
    public static boolean blockOccudes(VoxelShape first, VoxelShape second, Direction direction) {
        boolean secondBlock;
        boolean firstBlock = first == BLOCK;
        boolean bl = secondBlock = second == BLOCK;
        if (firstBlock & secondBlock) {
            return true;
        }
        if (first.isEmpty() | second.isEmpty()) {
            return false;
        }
        VoxelShape newFirst = ((CollisionVoxelShape)first).moonrise$getFaceShapeClamped(direction);
        if (newFirst.isEmpty()) {
            return false;
        }
        VoxelShape newSecond = ((CollisionVoxelShape)second).moonrise$getFaceShapeClamped(direction.getOpposite());
        if (newSecond.isEmpty()) {
            return false;
        }
        return !ShapesMixin.joinIsNotEmpty(newFirst, newSecond, BooleanOp.ONLY_FIRST);
    }

    @Overwrite
    public static boolean faceShapeOccludes(VoxelShape shape1, VoxelShape shape2) {
        boolean s2Empty;
        if (((CollisionVoxelShape)shape1).moonrise$occludesFullBlockIfCached() || ((CollisionVoxelShape)shape2).moonrise$occludesFullBlockIfCached()) {
            return true;
        }
        boolean s1Empty = shape1.isEmpty();
        if (s1Empty & (s2Empty = shape2.isEmpty())) {
            return false;
        }
        if (s1Empty | s2Empty) {
            return s2Empty ? ((CollisionVoxelShape)shape1).moonrise$occludesFullBlock() : ((CollisionVoxelShape)shape2).moonrise$occludesFullBlock();
        }
        if (shape1 == shape2) {
            return ((CollisionVoxelShape)shape1).moonrise$occludesFullBlock();
        }
        return ShapesMixin.mergedMayOccludeBlock(shape1, shape2) && ((CollisionVoxelShape)((CollisionVoxelShape)shape1).moonrise$orUnoptimized(shape2)).moonrise$occludesFullBlock();
    }

    static {
        PARTS_BY_BITS = new DoubleArrayList[]{DoubleArrayList.wrap((double[])ShapesMixin.generateCubeParts(1)), DoubleArrayList.wrap((double[])ShapesMixin.generateCubeParts(2)), DoubleArrayList.wrap((double[])ShapesMixin.generateCubeParts(4)), DoubleArrayList.wrap((double[])ShapesMixin.generateCubeParts(8))};
    }
}

