/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.collisions;

import java.util.List;
import net.minecraft.world.entity.Attackable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={LivingEntity.class})
abstract class LivingEntityMixin
extends Entity
implements Attackable {
    @Shadow
    protected abstract void doPush(Entity var1);

    public LivingEntityMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Overwrite
    public void pushEntities() {
        if (this.level().isClientSide()) {
            List players = this.level().getEntitiesOfClass(Player.class, this.getBoundingBox(), EntitySelector.pushableBy((Entity)this));
            int len = players.size();
            for (int i = 0; i < len; ++i) {
                this.doPush((Entity)players.get(i));
            }
        } else {
            int maxCramming;
            List nearby = this.level().getEntities((Entity)this, this.getBoundingBox(), EntitySelector.pushableBy((Entity)this));
            int nonPassengers = 0;
            int len = nearby.size();
            for (int i = 0; i < len; ++i) {
                Entity entity = (Entity)nearby.get(i);
                nonPassengers += entity.isPassenger() ? 0 : 1;
                this.doPush(entity);
            }
            if (nonPassengers != 0 && (maxCramming = this.level().getGameRules().getInt(GameRules.RULE_MAX_ENTITY_CRAMMING)) > 0 && nonPassengers > maxCramming - 1 && this.random.nextInt(4) == 0) {
                this.hurt(this.damageSources().cramming(), 6.0f);
            }
        }
    }
}

