/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.collisions;

import ca.spottedleaf.moonrise.common.util.WorldUtil;
import ca.spottedleaf.moonrise.patches.chunk_system.level.ChunkSystemLevel;
import ca.spottedleaf.moonrise.patches.collisions.CollisionUtil;
import ca.spottedleaf.moonrise.patches.collisions.block.CollisionBlockState;
import ca.spottedleaf.moonrise.patches.collisions.shape.CollisionVoxelShape;
import ca.spottedleaf.moonrise.patches.collisions.util.NoneMatchStream;
import it.unimi.dsi.fastutil.floats.FloatArraySet;
import it.unimi.dsi.fastutil.floats.FloatArrays;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={Entity.class})
abstract class EntityMixin {
    @Shadow
    private Level level;
    @Shadow
    public boolean noPhysics;
    @Shadow
    private EntityDimensions dimensions;
    @Shadow
    private boolean onGround;

    EntityMixin() {
    }

    @Shadow
    public abstract AABB getBoundingBox();

    @Shadow
    public abstract float maxUpStep();

    @Shadow
    public abstract Vec3 getEyePosition();

    @Shadow
    public abstract boolean isAlive();

    @Shadow
    protected abstract void onInsideBlock(BlockState var1);

    @Unique
    private static float[] calculateStepHeights(AABB box, List<VoxelShape> voxels, List<AABB> aabbs, float stepHeight, float collidedY) {
        VoxelShape shape;
        int i;
        FloatArraySet ret = new FloatArraySet();
        int len = voxels.size();
        for (i = 0; i < len; ++i) {
            double yUnoffset;
            double y;
            float step;
            shape = voxels.get(i);
            double[] yCoords = ((CollisionVoxelShape)shape).moonrise$rootCoordinatesY();
            double yOffset = ((CollisionVoxelShape)shape).moonrise$offsetY();
            double[] dArray = yCoords;
            int n = dArray.length;
            for (int j = 0; j < n && !((step = (float)((y = (yUnoffset = dArray[j]) + yOffset) - box.minY)) > stepHeight); ++j) {
                if (step < 0.0f || step == collidedY) continue;
                ret.add(step);
            }
        }
        len = aabbs.size();
        for (i = 0; i < len; ++i) {
            shape = aabbs.get(i);
            float step1 = (float)(shape.minY - box.minY);
            float step2 = (float)(shape.maxY - box.minY);
            if (!(step1 < 0.0f) && step1 != collidedY && !(step1 > stepHeight)) {
                ret.add(step1);
            }
            if (step2 < 0.0f || step2 == collidedY || step2 > stepHeight) continue;
            ret.add(step2);
        }
        float[] steps = ret.toFloatArray();
        FloatArrays.unstableSort((float[])steps);
        return steps;
    }

    @Overwrite
    private Vec3 collide(Vec3 movement) {
        double stepHeight;
        boolean collidedDownwards;
        Vec3 collided;
        ArrayList<AABB> entityAABBs;
        AABB currentBox;
        block7: {
            block6: {
                double d;
                boolean zZero;
                boolean xZero = movement.x == 0.0;
                boolean yZero = movement.y == 0.0;
                boolean bl = zZero = movement.z == 0.0;
                if (xZero & yZero & zZero) {
                    return movement;
                }
                currentBox = this.getBoundingBox();
                ArrayList<VoxelShape> potentialCollisionsVoxel = new ArrayList<VoxelShape>();
                ArrayList<AABB> potentialCollisionsBB = new ArrayList<AABB>();
                AABB initialCollisionBox = xZero & zZero ? (movement.y < 0.0 ? CollisionUtil.cutDownwards(currentBox, movement.y) : CollisionUtil.cutUpwards(currentBox, movement.y)) : currentBox.expandTowards(movement);
                entityAABBs = new ArrayList<AABB>();
                CollisionUtil.getEntityHardCollisions(this.level, (Entity)this, initialCollisionBox, entityAABBs, 0, null);
                CollisionUtil.getCollisionsForBlocksOrWorldBorder(this.level, (Entity)this, initialCollisionBox, potentialCollisionsVoxel, potentialCollisionsBB, 4, null);
                potentialCollisionsBB.addAll(entityAABBs);
                collided = CollisionUtil.performCollisions(movement, currentBox, potentialCollisionsVoxel, potentialCollisionsBB);
                boolean collidedX = collided.x != movement.x;
                boolean collidedY = collided.y != movement.y;
                boolean collidedZ = collided.z != movement.z;
                boolean bl2 = collidedDownwards = collidedY && movement.y < 0.0;
                if (!collidedDownwards && !this.onGround || !collidedX && !collidedZ) break block6;
                stepHeight = this.maxUpStep();
                if (!(d <= 0.0)) break block7;
            }
            return collided;
        }
        AABB collidedYBox = collidedDownwards ? currentBox.move(0.0, collided.y, 0.0) : currentBox;
        AABB stepRetrievalBox = collidedYBox.expandTowards(movement.x, stepHeight, movement.z);
        if (!collidedDownwards) {
            stepRetrievalBox = stepRetrievalBox.expandTowards(0.0, (double)-1.0E-5f, 0.0);
        }
        ArrayList<VoxelShape> stepVoxels = new ArrayList<VoxelShape>();
        ArrayList<AABB> stepAABBs = entityAABBs;
        CollisionUtil.getCollisionsForBlocksOrWorldBorder(this.level, (Entity)this, stepRetrievalBox, stepVoxels, stepAABBs, 4, null);
        for (float step : EntityMixin.calculateStepHeights(collidedYBox, stepVoxels, stepAABBs, (float)stepHeight, (float)collided.y)) {
            Vec3 stepResult = CollisionUtil.performCollisions(new Vec3(movement.x, (double)step, movement.z), collidedYBox, stepVoxels, stepAABBs);
            if (!(stepResult.horizontalDistanceSqr() > collided.horizontalDistanceSqr())) continue;
            return stepResult.add(0.0, collidedYBox.minY - currentBox.minY, 0.0);
        }
        return collided;
    }

    @Overwrite
    public boolean isInWall() {
        if (this.noPhysics) {
            return false;
        }
        double reducedWith = this.dimensions.width() * 0.8f;
        AABB boundingBox = AABB.ofSize((Vec3)this.getEyePosition(), (double)reducedWith, (double)1.0E-6, (double)reducedWith);
        Level world = this.level;
        if (CollisionUtil.isEmpty(boundingBox)) {
            return false;
        }
        int minBlockX = Mth.floor((double)boundingBox.minX);
        int minBlockY = Mth.floor((double)boundingBox.minY);
        int minBlockZ = Mth.floor((double)boundingBox.minZ);
        int maxBlockX = Mth.floor((double)boundingBox.maxX);
        int maxBlockY = Mth.floor((double)boundingBox.maxY);
        int maxBlockZ = Mth.floor((double)boundingBox.maxZ);
        int minChunkX = minBlockX >> 4;
        int minChunkY = minBlockY >> 4;
        int minChunkZ = minBlockZ >> 4;
        int maxChunkX = maxBlockX >> 4;
        int maxChunkY = maxBlockY >> 4;
        int maxChunkZ = maxBlockZ >> 4;
        int minSection = WorldUtil.getMinSection(world);
        ChunkSource chunkSource = world.getChunkSource();
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (int currChunkZ = minChunkZ; currChunkZ <= maxChunkZ; ++currChunkZ) {
            for (int currChunkX = minChunkX; currChunkX <= maxChunkX; ++currChunkX) {
                LevelChunkSection[] sections = chunkSource.getChunk(currChunkX, currChunkZ, ChunkStatus.FULL, true).getSections();
                for (int currChunkY = minChunkY; currChunkY <= maxChunkY; ++currChunkY) {
                    LevelChunkSection section;
                    int sectionIdx = currChunkY - minSection;
                    if (sectionIdx < 0 || sectionIdx >= sections.length || (section = sections[sectionIdx]).hasOnlyAir()) continue;
                    PalettedContainer blocks = section.states;
                    int minXIterate = currChunkX == minChunkX ? minBlockX & 0xF : 0;
                    int maxXIterate = currChunkX == maxChunkX ? maxBlockX & 0xF : 15;
                    int minZIterate = currChunkZ == minChunkZ ? minBlockZ & 0xF : 0;
                    int maxZIterate = currChunkZ == maxChunkZ ? maxBlockZ & 0xF : 15;
                    int minYIterate = currChunkY == minChunkY ? minBlockY & 0xF : 0;
                    int maxYIterate = currChunkY == maxChunkY ? maxBlockY & 0xF : 15;
                    for (int currY = minYIterate; currY <= maxYIterate; ++currY) {
                        int blockY = currY | currChunkY << 4;
                        mutablePos.setY(blockY);
                        for (int currZ = minZIterate; currZ <= maxZIterate; ++currZ) {
                            int blockZ = currZ | currChunkZ << 4;
                            mutablePos.setZ(blockZ);
                            for (int currX = minXIterate; currX <= maxXIterate; ++currX) {
                                VoxelShape collisionShape;
                                int blockX = currX | currChunkX << 4;
                                mutablePos.setX(blockX);
                                BlockState blockState = (BlockState)blocks.get(currX | currZ << 4 | currY << 8);
                                if (((CollisionBlockState)blockState).moonrise$emptyCollisionShape() || !blockState.isSuffocating((BlockGetter)world, (BlockPos)mutablePos) || (collisionShape = blockState.getCollisionShape((BlockGetter)world, (BlockPos)mutablePos)).isEmpty()) continue;
                                AABB toCollide = boundingBox.move(-((double)blockX), -((double)blockY), -((double)blockZ));
                                AABB singleAABB = ((CollisionVoxelShape)collisionShape).moonrise$getSingleAABBRepresentation();
                                if (!(singleAABB != null ? CollisionUtil.voxelShapeIntersect(singleAABB, toCollide) : CollisionUtil.voxelShapeIntersectNoEmpty(collisionShape, toCollide))) continue;
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    @Redirect(method={"move"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;getBlockStatesIfLoaded(Lnet/minecraft/world/phys/AABB;)Ljava/util/stream/Stream;", ordinal=0))
    private <T> Stream<T> avoidStreams(Level world, AABB boundingBox) {
        int minBlockX = Mth.floor((double)boundingBox.minX);
        int minBlockY = Mth.floor((double)boundingBox.minY);
        int minBlockZ = Mth.floor((double)boundingBox.minZ);
        int maxBlockX = Mth.floor((double)boundingBox.maxX);
        int maxBlockY = Mth.floor((double)boundingBox.maxY);
        int maxBlockZ = Mth.floor((double)boundingBox.maxZ);
        int minChunkX = minBlockX >> 4;
        int minChunkY = minBlockY >> 4;
        int minChunkZ = minBlockZ >> 4;
        int maxChunkX = maxBlockX >> 4;
        int maxChunkY = maxBlockY >> 4;
        int maxChunkZ = maxBlockZ >> 4;
        if (!((ChunkSystemLevel)world).moonrise$areChunksLoaded(minChunkX, minChunkZ, maxChunkX, maxChunkZ)) {
            return new NoneMatchStream(true);
        }
        int minSection = WorldUtil.getMinSection(world);
        ChunkSource chunkSource = world.getChunkSource();
        for (int currChunkZ = minChunkZ; currChunkZ <= maxChunkZ; ++currChunkZ) {
            for (int currChunkX = minChunkX; currChunkX <= maxChunkX; ++currChunkX) {
                LevelChunkSection[] sections = chunkSource.getChunk(currChunkX, currChunkZ, ChunkStatus.FULL, false).getSections();
                for (int currChunkY = minChunkY; currChunkY <= maxChunkY; ++currChunkY) {
                    LevelChunkSection section;
                    int sectionIdx = currChunkY - minSection;
                    if (sectionIdx < 0 || sectionIdx >= sections.length || (section = sections[sectionIdx]).hasOnlyAir()) continue;
                    PalettedContainer blocks = section.states;
                    int minXIterate = currChunkX == minChunkX ? minBlockX & 0xF : 0;
                    int maxXIterate = currChunkX == maxChunkX ? maxBlockX & 0xF : 15;
                    int minZIterate = currChunkZ == minChunkZ ? minBlockZ & 0xF : 0;
                    int maxZIterate = currChunkZ == maxChunkZ ? maxBlockZ & 0xF : 15;
                    int minYIterate = currChunkY == minChunkY ? minBlockY & 0xF : 0;
                    int maxYIterate = currChunkY == maxChunkY ? maxBlockY & 0xF : 15;
                    for (int currY = minYIterate; currY <= maxYIterate; ++currY) {
                        for (int currZ = minZIterate; currZ <= maxZIterate; ++currZ) {
                            for (int currX = minXIterate; currX <= maxXIterate; ++currX) {
                                BlockState blockState = (BlockState)blocks.get(currX | currZ << 4 | currY << 8);
                                if (!blockState.is(Blocks.LAVA) && !blockState.is(BlockTags.FIRE)) continue;
                                return new NoneMatchStream(false);
                            }
                        }
                    }
                }
            }
        }
        return new NoneMatchStream(true);
    }

    @Overwrite
    public void checkInsideBlocks() {
        AABB boundingBox = this.getBoundingBox();
        int minBlockX = Mth.floor((double)(boundingBox.minX + 1.0E-7));
        int minBlockY = Mth.floor((double)(boundingBox.minY + 1.0E-7));
        int minBlockZ = Mth.floor((double)(boundingBox.minZ + 1.0E-7));
        int maxBlockX = Mth.floor((double)(boundingBox.maxX - 1.0E-7));
        int maxBlockY = Mth.floor((double)(boundingBox.maxY - 1.0E-7));
        int maxBlockZ = Mth.floor((double)(boundingBox.maxZ - 1.0E-7));
        int minChunkX = minBlockX >> 4;
        int minChunkY = minBlockY >> 4;
        int minChunkZ = minBlockZ >> 4;
        int maxChunkX = maxBlockX >> 4;
        int maxChunkY = maxBlockY >> 4;
        Level world = this.level;
        int maxChunkZ = maxBlockZ >> 4;
        if (!((ChunkSystemLevel)world).moonrise$areChunksLoaded(minChunkX, minChunkZ, maxChunkX, maxChunkZ)) {
            return;
        }
        int minSection = WorldUtil.getMinSection(world);
        ChunkSource chunkSource = world.getChunkSource();
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (int currChunkZ = minChunkZ; currChunkZ <= maxChunkZ; ++currChunkZ) {
            for (int currChunkX = minChunkX; currChunkX <= maxChunkX; ++currChunkX) {
                LevelChunkSection[] sections = chunkSource.getChunk(currChunkX, currChunkZ, ChunkStatus.FULL, false).getSections();
                for (int currChunkY = minChunkY; currChunkY <= maxChunkY; ++currChunkY) {
                    LevelChunkSection section;
                    int sectionIdx = currChunkY - minSection;
                    if (sectionIdx < 0 || sectionIdx >= sections.length || (section = sections[sectionIdx]).hasOnlyAir()) continue;
                    PalettedContainer blocks = section.states;
                    int minXIterate = currChunkX == minChunkX ? minBlockX & 0xF : 0;
                    int maxXIterate = currChunkX == maxChunkX ? maxBlockX & 0xF : 15;
                    int minZIterate = currChunkZ == minChunkZ ? minBlockZ & 0xF : 0;
                    int maxZIterate = currChunkZ == maxChunkZ ? maxBlockZ & 0xF : 15;
                    int minYIterate = currChunkY == minChunkY ? minBlockY & 0xF : 0;
                    int maxYIterate = currChunkY == maxChunkY ? maxBlockY & 0xF : 15;
                    for (int currY = minYIterate; currY <= maxYIterate; ++currY) {
                        mutablePos.setY(currY | currChunkY << 4);
                        for (int currZ = minZIterate; currZ <= maxZIterate; ++currZ) {
                            mutablePos.setZ(currZ | currChunkZ << 4);
                            for (int currX = minXIterate; currX <= maxXIterate; ++currX) {
                                mutablePos.setX(currX | currChunkX << 4);
                                BlockState blockState = (BlockState)blocks.get(currX | currZ << 4 | currY << 8);
                                if (!this.isAlive()) {
                                    return;
                                }
                                blockState.entityInside(world, (BlockPos)mutablePos, (Entity)this);
                                this.onInsideBlock(blockState);
                            }
                        }
                    }
                }
            }
        }
    }
}

