/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.collisions;

import ca.spottedleaf.moonrise.patches.chunk_system.entity.ChunkSystemEntity;
import ca.spottedleaf.moonrise.patches.chunk_system.world.ChunkSystemEntityGetter;
import ca.spottedleaf.moonrise.patches.collisions.CollisionUtil;
import ca.spottedleaf.moonrise.patches.collisions.shape.CollisionVoxelShape;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.EntityGetter;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={EntityGetter.class})
interface EntityGetterMixin {
    @Shadow
    public List<Entity> getEntities(Entity var1, AABB var2, Predicate<? super Entity> var3);

    @Shadow
    public List<Entity> getEntities(Entity var1, AABB var2);

    @Overwrite
    default public List<VoxelShape> getEntityCollisions(Entity entity, AABB box) {
        if (CollisionUtil.isEmpty(box)) {
            return new ArrayList<VoxelShape>();
        }
        box = box.inflate(-1.0E-7, -1.0E-7, -1.0E-7);
        List<Entity> entities = entity != null && ((ChunkSystemEntity)entity).moonrise$isHardColliding() ? this.getEntities(entity, box, null) : ((ChunkSystemEntityGetter)((Object)this)).moonrise$getHardCollidingEntities(entity, box, null);
        ArrayList<VoxelShape> ret = new ArrayList<VoxelShape>(Math.min(25, entities.size()));
        int len = entities.size();
        for (int i = 0; i < len; ++i) {
            Entity otherEntity = entities.get(i);
            if (otherEntity.isSpectator() || (entity != null || !otherEntity.canBeCollidedWith()) && (entity == null || !entity.canCollideWith(otherEntity))) continue;
            ret.add(Shapes.create((AABB)otherEntity.getBoundingBox()));
        }
        return ret;
    }

    @Overwrite
    default public boolean isUnobstructed(Entity entity, VoxelShape voxel) {
        if (voxel.isEmpty()) {
            return true;
        }
        AABB singleAABB = ((CollisionVoxelShape)voxel).moonrise$getSingleAABBRepresentation();
        List<Entity> entities = this.getEntities(entity, singleAABB == null ? voxel.bounds() : singleAABB.inflate(-1.0E-7, -1.0E-7, -1.0E-7));
        int len = entities.size();
        for (int i = 0; i < len; ++i) {
            AABB entityBB;
            Entity otherEntity = entities.get(i);
            if (otherEntity.isRemoved() || !otherEntity.blocksBuilding || entity != null && otherEntity.isPassengerOfSameVehicle(entity) || singleAABB == null && (CollisionUtil.isEmpty(entityBB = otherEntity.getBoundingBox()) || !CollisionUtil.voxelShapeIntersectNoEmpty(voxel, entityBB))) continue;
            return false;
        }
        return true;
    }
}

