/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.collisions;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={ArmorStand.class})
abstract class ArmorStandMixin
extends LivingEntity {
    @Shadow
    @Final
    private static Predicate<Entity> RIDABLE_MINECARTS;

    protected ArmorStandMixin(EntityType<? extends LivingEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Overwrite
    public void pushEntities() {
        List nearby = this.level().getEntitiesOfClass(AbstractMinecart.class, this.getBoundingBox(), RIDABLE_MINECARTS);
        int len = nearby.size();
        for (int i = 0; i < len; ++i) {
            AbstractMinecart minecart = (AbstractMinecart)nearby.get(i);
            if (!(this.distanceToSqr((Entity)minecart) <= 0.2)) continue;
            minecart.push((Entity)this);
        }
    }
}

