/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.chunk_tick_iteration;

import ca.spottedleaf.moonrise.common.list.ReferenceList;
import ca.spottedleaf.moonrise.common.misc.NearbyPlayers;
import ca.spottedleaf.moonrise.common.util.SimpleRandom;
import ca.spottedleaf.moonrise.patches.chunk_system.level.chunk.ChunkData;
import ca.spottedleaf.moonrise.patches.chunk_system.level.chunk.ChunkSystemChunkHolder;
import ca.spottedleaf.moonrise.patches.chunk_system.level.chunk.ChunkSystemLevelChunk;
import ca.spottedleaf.moonrise.patches.chunk_tick_iteration.ChunkTickServerLevel;
import com.llamalad7.mixinextras.sugar.Local;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.LevelChunk;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerChunkCache.class})
abstract class ServerChunkCacheMixin
extends ChunkSource {
    @Shadow
    @Final
    public ServerLevel level;
    @Unique
    private ServerChunkCache.ChunkAndHolder[] iterationCopy;
    @Unique
    private int iterationCopyLen;
    @Unique
    private final SimpleRandom shuffleRandom = new SimpleRandom(0L);

    ServerChunkCacheMixin() {
    }

    @Redirect(method={"tickChunks"}, at=@At(value="INVOKE", target="Lcom/google/common/collect/Lists;newArrayListWithCapacity(I)Ljava/util/ArrayList;"))
    private <T> ArrayList<T> avoidListCreation(int initialArraySize) {
        return null;
    }

    @ModifyVariable(method={"tickChunks"}, at=@At(value="STORE", opcode=58, ordinal=0))
    private List<ServerChunkCache.ChunkAndHolder> initTickChunks(List<ServerChunkCache.ChunkAndHolder> shouldBeNull) {
        ReferenceList<ServerChunkCache.ChunkAndHolder> tickingChunks = ((ChunkTickServerLevel)this.level).moonrise$getPlayerTickingChunks();
        ServerChunkCache.ChunkAndHolder[] raw = tickingChunks.getRawDataUnchecked();
        int size = tickingChunks.size();
        if (this.iterationCopy == null || this.iterationCopy.length < size) {
            this.iterationCopy = new ServerChunkCache.ChunkAndHolder[raw.length];
        }
        this.iterationCopyLen = size;
        System.arraycopy(raw, 0, this.iterationCopy, 0, size);
        return ObjectArrayList.wrap((Object[])this.iterationCopy, (int)size);
    }

    @Redirect(method={"tickChunks"}, at=@At(value="INVOKE", target="Lnet/minecraft/Util;shuffle(Ljava/util/List;Lnet/minecraft/util/RandomSource;)V"))
    private <T> void useBetterRandom(List<T> list, RandomSource randomSource) {
        this.shuffleRandom.setSeed(randomSource.nextLong());
        Util.shuffle(list, (RandomSource)this.shuffleRandom);
    }

    @Redirect(method={"tickChunks"}, at=@At(value="INVOKE", target="Ljava/util/Iterator;hasNext()Z", ordinal=0))
    private <E> boolean skipTickAdd(Iterator<E> instance) {
        return false;
    }

    @Redirect(method={"tickChunks"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ChunkMap;anyPlayerCloseEnoughForSpawning(Lnet/minecraft/world/level/ChunkPos;)Z"))
    private boolean useNearbyCache(ChunkMap instance, ChunkPos chunkPos, @Local(ordinal=0, argsOnly=false) LevelChunk levelChunk) {
        ChunkData chunkData = ((ChunkSystemChunkHolder)((ChunkSystemLevelChunk)levelChunk).moonrise$getChunkAndHolder().holder()).moonrise$getRealChunkHolder().holderData;
        NearbyPlayers.TrackedChunk nearbyPlayers = chunkData.nearbyPlayers;
        if (nearbyPlayers == null) {
            return false;
        }
        ReferenceList<ServerPlayer> players = nearbyPlayers.getPlayers(NearbyPlayers.NearbyMapType.SPAWN_RANGE);
        if (players == null) {
            return false;
        }
        ServerPlayer[] raw = players.getRawDataUnchecked();
        int len = players.size();
        Objects.checkFromIndexSize(0, len, raw.length);
        for (int i = 0; i < len; ++i) {
            if (!instance.playerIsCloseEnoughForSpawning(raw[i], chunkPos)) continue;
            return true;
        }
        return false;
    }

    @Inject(method={"tickChunks"}, at={@At(value="INVOKE", target="Ljava/util/List;forEach(Ljava/util/function/Consumer;)V", ordinal=0, shift=At.Shift.AFTER)})
    private void broadcastChanges(CallbackInfo ci) {
        Arrays.fill(this.iterationCopy, 0, this.iterationCopyLen, null);
    }
}

