/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.chunk_tick_iteration;

import ca.spottedleaf.moonrise.common.misc.PositionCountingAreaMap;
import ca.spottedleaf.moonrise.common.util.CoordinateUtils;
import ca.spottedleaf.moonrise.patches.chunk_tick_iteration.ChunkTickDistanceManager;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.DistanceManager;
import net.minecraft.server.level.ServerPlayer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={DistanceManager.class})
abstract class DistanceManagerMixin
implements ChunkTickDistanceManager {
    @Shadow
    private DistanceManager.FixedPlayerDistanceChunkTracker naturalSpawnChunkCounter;
    @Unique
    private final PositionCountingAreaMap<ServerPlayer> spawnChunkTracker = new PositionCountingAreaMap();

    DistanceManagerMixin() {
    }

    @Override
    public final void moonrise$addPlayer(ServerPlayer player, SectionPos pos) {
        this.spawnChunkTracker.add(player, pos.x(), pos.z(), 8);
    }

    @Override
    public final void moonrise$removePlayer(ServerPlayer player, SectionPos pos) {
        this.spawnChunkTracker.remove(player);
    }

    @Override
    public final void moonrise$updatePlayer(ServerPlayer player, SectionPos oldPos, SectionPos newPos, boolean oldIgnore, boolean newIgnore) {
        if (newIgnore) {
            this.spawnChunkTracker.remove(player);
        } else {
            this.spawnChunkTracker.addOrUpdate(player, newPos.x(), newPos.z(), 8);
        }
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void destroyFields(CallbackInfo ci) {
        this.naturalSpawnChunkCounter = null;
    }

    @Redirect(method={"addPlayer"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/DistanceManager$FixedPlayerDistanceChunkTracker;update(JIZ)V"))
    private void skipSpawnTrackerAdd(DistanceManager.FixedPlayerDistanceChunkTracker instance, long pos, int i0, boolean b0) {
    }

    @Redirect(method={"removePlayer"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/DistanceManager$FixedPlayerDistanceChunkTracker;update(JIZ)V"))
    private void skipSpawnTrackerRemove(DistanceManager.FixedPlayerDistanceChunkTracker instance, long pos, int i0, boolean b0) {
    }

    @Overwrite
    public int getNaturalSpawnChunkCount() {
        return this.spawnChunkTracker.getTotalPositions();
    }

    @Overwrite
    public boolean hasPlayersNearby(long pos) {
        return this.spawnChunkTracker.hasObjectsNear(CoordinateUtils.getChunkX(pos), CoordinateUtils.getChunkZ(pos));
    }
}

