/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.chunk_tick_iteration;

import ca.spottedleaf.moonrise.common.list.ReferenceList;
import ca.spottedleaf.moonrise.common.misc.NearbyPlayers;
import ca.spottedleaf.moonrise.patches.chunk_system.level.ChunkSystemServerLevel;
import ca.spottedleaf.moonrise.patches.chunk_tick_iteration.ChunkTickDistanceManager;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.entity.EntityAccess;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ChunkMap.class})
abstract class ChunkMapMixin {
    @Shadow
    @Final
    private ChunkMap.DistanceManager distanceManager;
    @Shadow
    @Final
    public ServerLevel level;

    ChunkMapMixin() {
    }

    @Shadow
    public abstract boolean playerIsCloseEnoughForSpawning(ServerPlayer var1, ChunkPos var2);

    @Inject(method={"move"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ChunkMap;updatePlayerPos(Lnet/minecraft/server/level/ServerPlayer;)V")})
    private void updateSpawnTracker(ServerPlayer player, CallbackInfo ci, @Local(ordinal=0) SectionPos oldPos, @Local(ordinal=1) SectionPos newPos, @Local(ordinal=0) boolean oldIgnore, @Local(ordinal=1) boolean newIgnore) {
        ((ChunkTickDistanceManager)this.distanceManager).moonrise$updatePlayer(player, oldPos, newPos, oldIgnore, newIgnore);
    }

    @Inject(method={"updatePlayerStatus"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ChunkMap$DistanceManager;addPlayer(Lnet/minecraft/core/SectionPos;Lnet/minecraft/server/level/ServerPlayer;)V")})
    private void addPlayerToSpawnTracker(ServerPlayer player, boolean add, CallbackInfo ci) {
        ((ChunkTickDistanceManager)this.distanceManager).moonrise$addPlayer(player, SectionPos.of((EntityAccess)player));
    }

    @Inject(method={"updatePlayerStatus"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ChunkMap$DistanceManager;removePlayer(Lnet/minecraft/core/SectionPos;Lnet/minecraft/server/level/ServerPlayer;)V")})
    private void removePlayerFromSpawnTracker(ServerPlayer player, boolean add, CallbackInfo ci) {
        ((ChunkTickDistanceManager)this.distanceManager).moonrise$removePlayer(player, SectionPos.of((EntityAccess)player));
    }

    @Overwrite
    public boolean anyPlayerCloseEnoughForSpawning(ChunkPos pos) {
        ReferenceList<ServerPlayer> players = ((ChunkSystemServerLevel)this.level).moonrise$getNearbyPlayers().getPlayers(pos, NearbyPlayers.NearbyMapType.SPAWN_RANGE);
        if (players == null) {
            return false;
        }
        ServerPlayer[] raw = players.getRawDataUnchecked();
        int len = players.size();
        Objects.checkFromIndexSize(0, len, raw.length);
        for (int i = 0; i < len; ++i) {
            if (!this.playerIsCloseEnoughForSpawning(raw[i], pos)) continue;
            return true;
        }
        return false;
    }

    @Overwrite
    public List<ServerPlayer> getPlayersCloseForSpawning(ChunkPos pos) {
        ReferenceList<ServerPlayer> players = ((ChunkSystemServerLevel)this.level).moonrise$getNearbyPlayers().getPlayers(pos, NearbyPlayers.NearbyMapType.SPAWN_RANGE);
        if (players == null) {
            return new ArrayList<ServerPlayer>();
        }
        ArrayList<ServerPlayer> ret = null;
        ServerPlayer[] raw = players.getRawDataUnchecked();
        int len = players.size();
        Objects.checkFromIndexSize(0, len, raw.length);
        for (int i = 0; i < len; ++i) {
            ServerPlayer player = raw[i];
            if (!this.playerIsCloseEnoughForSpawning(player, pos)) continue;
            if (ret == null) {
                ret = new ArrayList(len - i);
                ret.add(player);
                continue;
            }
            ret.add(player);
        }
        return ret == null ? new ArrayList<ServerPlayer>() : ret;
    }
}

