/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.chunk_system;

import ca.spottedleaf.moonrise.common.PlatformHooks;
import ca.spottedleaf.moonrise.common.list.ReferenceList;
import ca.spottedleaf.moonrise.common.util.CoordinateUtils;
import ca.spottedleaf.moonrise.common.util.TickThread;
import ca.spottedleaf.moonrise.common.util.WorldUtil;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.concurrentutil.map.ConcurrentLong2ReferenceChainedHashTable;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.concurrentutil.util.Priority;
import ca.spottedleaf.moonrise.patches.chunk_system.level.ChunkSystemServerLevel;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.ChunkHolderManager;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.ChunkTaskScheduler;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.NewChunkHolder;
import ca.spottedleaf.moonrise.patches.chunk_system.server.ChunkSystemMinecraftServer;
import ca.spottedleaf.moonrise.patches.chunk_system.world.ChunkSystemServerChunkCache;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.ChunkResult;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.GenerationChunkHolder;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LightChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerChunkCache.class})
abstract class ServerChunkCacheMixin
extends ChunkSource
implements ChunkSystemServerChunkCache {
    @Shadow
    @Final
    public ServerChunkCache.MainThreadExecutor mainThreadProcessor;
    @Shadow
    @Final
    public ServerLevel level;
    @Unique
    private final ConcurrentLong2ReferenceChainedHashTable<LevelChunk> fullChunks = new ConcurrentLong2ReferenceChainedHashTable();
    @Unique
    private long chunksTicked;

    ServerChunkCacheMixin() {
    }

    @Override
    public final void moonrise$setFullChunk(int chunkX, int chunkZ, LevelChunk chunk) {
        long key = CoordinateUtils.getChunkKey(chunkX, chunkZ);
        if (chunk == null) {
            this.fullChunks.remove(key);
        } else {
            this.fullChunks.put(key, chunk);
        }
    }

    @Override
    public final LevelChunk moonrise$getFullChunkIfLoaded(int chunkX, int chunkZ) {
        return this.fullChunks.get(CoordinateUtils.getChunkKey(chunkX, chunkZ));
    }

    @Unique
    private ChunkAccess syncLoad(int chunkX, int chunkZ, ChunkStatus toStatus) {
        ChunkAccess ret;
        ChunkTaskScheduler chunkTaskScheduler = ((ChunkSystemServerLevel)this.level).moonrise$getChunkTaskScheduler();
        CompletableFuture completable = new CompletableFuture();
        chunkTaskScheduler.scheduleChunkLoad(chunkX, chunkZ, toStatus, true, Priority.BLOCKING, completable::complete);
        if (!completable.isDone() && chunkTaskScheduler.hasShutdown()) {
            throw new IllegalStateException("Chunk system has shut down, cannot process chunk requests in world '" + WorldUtil.getWorldName((Level)this.level) + "' at (" + chunkX + "," + chunkZ + ") status: " + String.valueOf(toStatus));
        }
        if (TickThread.isTickThreadFor((Level)this.level, chunkX, chunkZ)) {
            ChunkTaskScheduler.pushChunkWait(this.level, chunkX, chunkZ);
            this.mainThreadProcessor.managedBlock(completable::isDone);
            ChunkTaskScheduler.popChunkWait();
        }
        if ((ret = (ChunkAccess)completable.join()) == null) {
            throw new IllegalStateException("Chunk not loaded when requested");
        }
        return ret;
    }

    @Unique
    private ChunkAccess getChunkFallback(int chunkX, int chunkZ, ChunkStatus toStatus, boolean load) {
        LevelChunk loading;
        ChunkAccess ifPresent;
        ChunkTaskScheduler chunkTaskScheduler = ((ChunkSystemServerLevel)this.level).moonrise$getChunkTaskScheduler();
        ChunkHolderManager chunkHolderManager = chunkTaskScheduler.chunkHolderManager;
        NewChunkHolder currentChunk = chunkHolderManager.getChunkHolder(CoordinateUtils.getChunkKey(chunkX, chunkZ));
        ChunkAccess chunkAccess = ifPresent = currentChunk == null ? null : currentChunk.getChunkIfPresent(toStatus);
        if (ifPresent != null && (toStatus != ChunkStatus.FULL || currentChunk.isFullChunkReady())) {
            return ifPresent;
        }
        PlatformHooks platformHooks = PlatformHooks.get();
        if (platformHooks.hasCurrentlyLoadingChunk() && currentChunk != null && (loading = platformHooks.getCurrentlyLoadingChunk((GenerationChunkHolder)currentChunk.vanillaChunkHolder)) != null && TickThread.isTickThread()) {
            return loading;
        }
        return load ? this.syncLoad(chunkX, chunkZ, toStatus) : null;
    }

    @Overwrite
    public ChunkAccess getChunk(int chunkX, int chunkZ, ChunkStatus toStatus, boolean load) {
        if (toStatus == ChunkStatus.FULL) {
            LevelChunk ret = this.fullChunks.get(CoordinateUtils.getChunkKey(chunkX, chunkZ));
            if (ret != null) {
                return ret;
            }
            return load ? this.getChunkFallback(chunkX, chunkZ, toStatus, load) : null;
        }
        return this.getChunkFallback(chunkX, chunkZ, toStatus, load);
    }

    @Overwrite
    public LevelChunk getChunkNow(int chunkX, int chunkZ) {
        LevelChunk ret = this.fullChunks.get(CoordinateUtils.getChunkKey(chunkX, chunkZ));
        if (!PlatformHooks.get().hasCurrentlyLoadingChunk()) {
            return ret;
        }
        if (ret != null || !TickThread.isTickThread()) {
            return ret;
        }
        NewChunkHolder holder = ((ChunkSystemServerLevel)this.level).moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(chunkX, chunkZ);
        if (holder == null) {
            return ret;
        }
        return PlatformHooks.get().getCurrentlyLoadingChunk((GenerationChunkHolder)holder.vanillaChunkHolder);
    }

    @Overwrite
    public boolean hasChunk(int chunkX, int chunkZ) {
        return this.getChunkNow(chunkX, chunkZ) != null;
    }

    @Overwrite
    public CompletableFuture<ChunkResult<ChunkAccess>> getChunkFutureMainThread(int chunkX, int chunkZ, ChunkStatus toStatus, boolean create) {
        ChunkAccess ifPresent;
        boolean needsFullScheduling;
        TickThread.ensureTickThread((Level)this.level, chunkX, chunkZ, "Scheduling chunk load off-main");
        int minLevel = ChunkLevel.byStatus((ChunkStatus)toStatus);
        NewChunkHolder chunkHolder = ((ChunkSystemServerLevel)this.level).moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(chunkX, chunkZ);
        boolean bl = needsFullScheduling = toStatus == ChunkStatus.FULL && (chunkHolder == null || !chunkHolder.getChunkStatus().isOrAfter(FullChunkStatus.FULL));
        if ((chunkHolder == null || chunkHolder.getTicketLevel() > minLevel || needsFullScheduling) && !create) {
            return ChunkHolder.UNLOADED_CHUNK_FUTURE;
        }
        ChunkAccess chunkAccess = ifPresent = chunkHolder == null ? null : chunkHolder.getChunkIfPresent(toStatus);
        if (needsFullScheduling || ifPresent == null) {
            CompletableFuture<ChunkResult<ChunkAccess>> ret = new CompletableFuture<ChunkResult<ChunkAccess>>();
            Consumer<ChunkAccess> complete = chunk -> {
                if (chunk == null) {
                    ret.complete(ChunkHolder.UNLOADED_CHUNK);
                } else {
                    ret.complete(ChunkResult.of((Object)chunk));
                }
            };
            ((ChunkSystemServerLevel)this.level).moonrise$getChunkTaskScheduler().scheduleChunkLoad(chunkX, chunkZ, toStatus, true, Priority.HIGHER, complete);
            return ret;
        }
        return CompletableFuture.completedFuture(ChunkResult.of((Object)ifPresent));
    }

    @Overwrite
    public LightChunk getChunkForLighting(int chunkX, int chunkZ) {
        NewChunkHolder newChunkHolder = ((ChunkSystemServerLevel)this.level).moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(chunkX, chunkZ);
        if (newChunkHolder == null) {
            return null;
        }
        return newChunkHolder.getChunkIfPresentUnchecked(ChunkStatus.INITIALIZE_LIGHT.getParent());
    }

    @Overwrite
    public boolean runDistanceManagerUpdates() {
        return ((ChunkSystemServerLevel)this.level).moonrise$getChunkTaskScheduler().chunkHolderManager.processTicketUpdates();
    }

    @Overwrite
    public boolean isPositionTicking(long los) {
        NewChunkHolder newChunkHolder = ((ChunkSystemServerLevel)this.level).moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(los);
        return newChunkHolder != null && newChunkHolder.isTickingReady();
    }

    @Overwrite
    public void close() throws IOException {
        ((ChunkSystemServerLevel)this.level).moonrise$getChunkTaskScheduler().chunkHolderManager.close(true, true);
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerChunkCache;tickChunks()V")})
    private void tickHook(CallbackInfo ci) {
        ((ChunkSystemServerLevel)this.level).moonrise$getPlayerChunkLoader().tick();
    }

    @Overwrite
    public void getFullChunk(long pos, Consumer<LevelChunk> consumer) {
        LevelChunk fullChunk = this.fullChunks.get(pos);
        if (fullChunk != null) {
            consumer.accept(fullChunk);
        }
    }

    @Redirect(method={"save"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerChunkCache;runDistanceManagerUpdates()Z"))
    private boolean skipSaveTicketUpdates(ServerChunkCache instance) {
        return false;
    }

    @Inject(method={"tickChunks"}, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/server/level/ServerLevel;tickChunk(Lnet/minecraft/world/level/chunk/LevelChunk;I)V")})
    private void midTickChunks(CallbackInfo ci) {
        if ((++this.chunksTicked & 7L) != 0L) {
            return;
        }
        ((ChunkSystemMinecraftServer)this.level.getServer()).moonrise$executeMidTickTasks();
    }

    @Redirect(method={"tickChunks"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;isNaturalSpawningAllowed(Lnet/minecraft/world/level/ChunkPos;)Z"))
    private boolean shortNaturalSpawning(ServerLevel instance, ChunkPos chunkPos) {
        return true;
    }

    @Redirect(method={"tickChunks"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;shouldTickBlocksAt(J)Z"))
    private boolean shortShouldTickBlocks(ServerLevel instance, long pos) {
        return true;
    }

    @Redirect(method={"tickChunks"}, at=@At(value="INVOKE", target="Ljava/util/List;forEach(Ljava/util/function/Consumer;)V"))
    private void fixBroadcastChanges(List<ServerChunkCache.ChunkAndHolder> instance, Consumer<ServerChunkCache.ChunkAndHolder> consumer) {
        ReferenceList<ChunkHolder> unsyncedChunks = ((ChunkSystemServerLevel)this.level).moonrise$getUnsyncedChunks();
        ChunkHolder[] chunkHolders = unsyncedChunks.getRawDataUnchecked();
        int totalUnsyncedChunks = unsyncedChunks.size();
        Objects.checkFromToIndex(0, totalUnsyncedChunks, chunkHolders.length);
        for (int i = 0; i < totalUnsyncedChunks; ++i) {
            ChunkHolder chunkHolder = chunkHolders[i];
            LevelChunk chunk = chunkHolder.getChunkToSend();
            if (chunk == null) continue;
            chunkHolder.broadcastChanges(chunk);
        }
        ((ChunkSystemServerLevel)this.level).moonrise$clearUnsyncedChunks();
    }
}

