/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.chunk_system;

import ca.spottedleaf.moonrise.patches.chunk_system.level.storage.ChunkSystemSectionStorage;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.RegistryOps;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.storage.RegionFileStorage;
import net.minecraft.world.level.chunk.storage.SectionStorage;
import net.minecraft.world.level.chunk.storage.SimpleRegionStorage;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SectionStorage.class})
abstract class SectionStorageMixin
implements ChunkSystemSectionStorage,
AutoCloseable {
    @Shadow
    private SimpleRegionStorage simpleRegionStorage;
    @Shadow
    @Final
    private static Logger LOGGER;
    @Unique
    private RegionFileStorage storage;

    SectionStorageMixin() {
    }

    @Override
    public final RegionFileStorage moonrise$getRegionStorage() {
        return this.storage;
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void initHook(CallbackInfo ci) {
        this.storage = this.simpleRegionStorage.worker.storage;
        this.simpleRegionStorage = null;
    }

    @Overwrite
    public final CompletableFuture<Optional<CompoundTag>> tryRead(ChunkPos pos) {
        try {
            return CompletableFuture.completedFuture(Optional.ofNullable(this.moonrise$read(pos.x, pos.z)));
        }
        catch (Throwable thr) {
            return CompletableFuture.failedFuture(thr);
        }
    }

    @Overwrite
    public void readColumn(ChunkPos pos, RegistryOps<Tag> ops, CompoundTag data) {
        throw new IllegalStateException("Only chunk system can load in state, offending class:" + this.getClass().getName());
    }

    @Redirect(method={"writeColumn(Lnet/minecraft/world/level/ChunkPos;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/chunk/storage/SimpleRegionStorage;write(Lnet/minecraft/world/level/ChunkPos;Lnet/minecraft/nbt/CompoundTag;)Ljava/util/concurrent/CompletableFuture;"))
    private CompletableFuture<Void> redirectWrite(SimpleRegionStorage instance, ChunkPos pos, CompoundTag tag) {
        try {
            this.moonrise$write(pos.x, pos.z, tag);
        }
        catch (IOException ex) {
            LOGGER.error("Error writing poi chunk data to disk for chunk " + String.valueOf(pos), (Throwable)ex);
        }
        return null;
    }

    @Redirect(method={"close"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/chunk/storage/SimpleRegionStorage;close()V"))
    private void redirectClose(SimpleRegionStorage instance) throws IOException {
        this.moonrise$close();
    }
}

