/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.chunk_system;

import ca.spottedleaf.moonrise.common.PlatformHooks;
import ca.spottedleaf.moonrise.common.util.CoordinateUtils;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.concurrentutil.map.ConcurrentLong2ReferenceChainedHashTable;
import ca.spottedleaf.moonrise.patches.chunk_system.level.ChunkSystemLevel;
import ca.spottedleaf.moonrise.patches.chunk_system.level.chunk.ChunkData;
import ca.spottedleaf.moonrise.patches.chunk_system.level.entity.EntityLookup;
import ca.spottedleaf.moonrise.patches.chunk_system.level.entity.dfl.DefaultEntityLookup;
import ca.spottedleaf.moonrise.patches.chunk_system.world.ChunkSystemEntityGetter;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Level.class})
abstract class LevelMixin
implements ChunkSystemLevel,
ChunkSystemEntityGetter,
LevelAccessor,
AutoCloseable {
    @Unique
    private EntityLookup entityLookup;
    @Unique
    private final ConcurrentLong2ReferenceChainedHashTable<ChunkData> chunkData = new ConcurrentLong2ReferenceChainedHashTable();

    LevelMixin() {
    }

    @Shadow
    public abstract ProfilerFiller getProfiler();

    @Shadow
    public abstract LevelChunk getChunk(int var1, int var2);

    @Shadow
    public abstract int getHeight(Heightmap.Types var1, int var2, int var3);

    @Override
    public final EntityLookup moonrise$getEntityLookup() {
        return this.entityLookup;
    }

    @Override
    public void moonrise$setEntityLookup(EntityLookup entityLookup) {
        if (this.entityLookup != null && !(this.entityLookup instanceof DefaultEntityLookup)) {
            throw new IllegalStateException("Entity lookup already initialised");
        }
        this.entityLookup = entityLookup;
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void initHook(CallbackInfo ci) {
        this.entityLookup = new DefaultEntityLookup((Level)this);
    }

    @Overwrite
    public List<Entity> getEntities(Entity entity, AABB boundingBox, Predicate<? super Entity> predicate) {
        this.getProfiler().incrementCounter("getEntities");
        ArrayList<Entity> ret = new ArrayList<Entity>();
        this.moonrise$getEntityLookup().getEntities(entity, boundingBox, ret, predicate);
        PlatformHooks.get().addToGetEntities((Level)this, entity, boundingBox, predicate, ret);
        return ret;
    }

    @Overwrite
    public <T extends Entity> void getEntities(EntityTypeTest<Entity, T> entityTypeTest, AABB boundingBox, Predicate<? super T> predicate, List<? super T> into, int maxCount) {
        this.getProfiler().incrementCounter("getEntities");
        if (entityTypeTest instanceof EntityType) {
            EntityType byType = (EntityType)entityTypeTest;
            if (maxCount != Integer.MAX_VALUE) {
                this.moonrise$getEntityLookup().getEntities(byType, boundingBox, into, predicate, maxCount);
                PlatformHooks.get().addToGetEntities((Level)this, entityTypeTest, boundingBox, predicate, into, maxCount);
                return;
            }
            this.moonrise$getEntityLookup().getEntities(byType, boundingBox, into, predicate);
            PlatformHooks.get().addToGetEntities((Level)this, entityTypeTest, boundingBox, predicate, into, maxCount);
            return;
        }
        if (entityTypeTest == null) {
            if (maxCount != Integer.MAX_VALUE) {
                this.moonrise$getEntityLookup().getEntities((Entity)null, boundingBox, into, predicate, maxCount);
                PlatformHooks.get().addToGetEntities((Level)this, entityTypeTest, boundingBox, predicate, into, maxCount);
                return;
            }
            this.moonrise$getEntityLookup().getEntities((Entity)null, boundingBox, into, predicate);
            PlatformHooks.get().addToGetEntities((Level)this, entityTypeTest, boundingBox, predicate, into, maxCount);
            return;
        }
        Class base = entityTypeTest.getBaseClass();
        Predicate<Entity> modifiedPredicate = predicate == null ? obj -> entityTypeTest.tryCast(obj) != null : obj -> {
            Entity casted = (Entity)entityTypeTest.tryCast(obj);
            if (casted == null) {
                return false;
            }
            return predicate.test(casted);
        };
        if (base == null || base == Entity.class) {
            if (maxCount != Integer.MAX_VALUE) {
                this.moonrise$getEntityLookup().getEntities((Entity)null, boundingBox, into, modifiedPredicate, maxCount);
                PlatformHooks.get().addToGetEntities((Level)this, entityTypeTest, boundingBox, predicate, into, maxCount);
                return;
            }
            this.moonrise$getEntityLookup().getEntities((Entity)null, boundingBox, into, modifiedPredicate);
            PlatformHooks.get().addToGetEntities((Level)this, entityTypeTest, boundingBox, predicate, into, maxCount);
            return;
        }
        if (maxCount != Integer.MAX_VALUE) {
            this.moonrise$getEntityLookup().getEntities(base, null, boundingBox, into, modifiedPredicate, maxCount);
            PlatformHooks.get().addToGetEntities((Level)this, entityTypeTest, boundingBox, predicate, into, maxCount);
            return;
        }
        this.moonrise$getEntityLookup().getEntities(base, null, boundingBox, into, modifiedPredicate);
        PlatformHooks.get().addToGetEntities((Level)this, entityTypeTest, boundingBox, predicate, into, maxCount);
    }

    public final <T extends Entity> List<T> getEntitiesOfClass(Class<T> entityClass, AABB boundingBox, Predicate<? super T> predicate) {
        this.getProfiler().incrementCounter("getEntities");
        ArrayList ret = new ArrayList();
        this.moonrise$getEntityLookup().getEntities(entityClass, null, boundingBox, ret, predicate);
        PlatformHooks.get().addToGetEntities((Level)this, EntityTypeTest.forClass(entityClass), boundingBox, predicate, ret, Integer.MAX_VALUE);
        return ret;
    }

    @Override
    public final List<Entity> moonrise$getHardCollidingEntities(Entity entity, AABB box, Predicate<? super Entity> predicate) {
        this.getProfiler().incrementCounter("getEntities");
        ArrayList<Entity> ret = new ArrayList<Entity>();
        this.moonrise$getEntityLookup().getHardCollidingEntities(entity, box, ret, predicate);
        return ret;
    }

    @Override
    public LevelChunk moonrise$getFullChunkIfLoaded(int chunkX, int chunkZ) {
        return (LevelChunk)this.getChunkSource().getChunk(chunkX, chunkZ, ChunkStatus.FULL, false);
    }

    @Override
    public ChunkAccess moonrise$getAnyChunkIfLoaded(int chunkX, int chunkZ) {
        return this.getChunkSource().getChunk(chunkX, chunkZ, ChunkStatus.EMPTY, false);
    }

    @Override
    public ChunkAccess moonrise$getSpecificChunkIfLoaded(int chunkX, int chunkZ, ChunkStatus leastStatus) {
        return this.getChunkSource().getChunk(chunkX, chunkZ, leastStatus, false);
    }

    @Override
    public void moonrise$midTickTasks() {
    }

    @Override
    public final ChunkData moonrise$getChunkData(long chunkKey) {
        return this.chunkData.get(chunkKey);
    }

    @Override
    public final ChunkData moonrise$getChunkData(int chunkX, int chunkZ) {
        return this.chunkData.get(CoordinateUtils.getChunkKey(chunkX, chunkZ));
    }

    @Override
    public final ChunkData moonrise$requestChunkData(long chunkKey) {
        return this.chunkData.compute(chunkKey, (keyInMap, valueInMap) -> {
            if (valueInMap == null) {
                ChunkData ret = new ChunkData();
                ret.increaseRef();
                return ret;
            }
            valueInMap.increaseRef();
            return valueInMap;
        });
    }

    @Override
    public final ChunkData moonrise$releaseChunkData(long chunkKey) {
        return this.chunkData.compute(chunkKey, (keyInMap, chunkData) -> chunkData.decreaseRef() == 0 ? null : chunkData);
    }

    @Override
    public boolean moonrise$areChunksLoaded(int fromX, int fromZ, int toX, int toZ) {
        ChunkSource chunkSource = this.getChunkSource();
        for (int currZ = fromZ; currZ <= toZ; ++currZ) {
            for (int currX = fromX; currX <= toX; ++currX) {
                if (chunkSource.hasChunk(currX, currZ)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean hasChunk(int x, int z) {
        return this.getChunkSource().hasChunk(x, z);
    }

    public boolean hasChunksAt(int minBlockX, int minBlockZ, int maxBlockX, int maxBlockZ) {
        return this.moonrise$areChunksLoaded(minBlockX >> 4, minBlockZ >> 4, maxBlockX >> 4, maxBlockZ >> 4);
    }

    public ChunkAccess getChunk(int x, int z, ChunkStatus status) {
        return ((Level)this).getChunk(x, z, status, true);
    }

    public BlockPos getHeightmapPos(Heightmap.Types types, BlockPos blockPos) {
        return new BlockPos(blockPos.getX(), this.getHeight(types, blockPos.getX(), blockPos.getZ()), blockPos.getZ());
    }

    @Redirect(method={"setBlock(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;II)Z", "markAndNotifyBlock(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/chunk/LevelChunk;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/state/BlockState;II)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/FullChunkStatus;isOrAfter(Lnet/minecraft/server/level/FullChunkStatus;)Z"))
    private boolean sendUpdatesForFullChunks(FullChunkStatus instance, FullChunkStatus fullChunkStatus) {
        return instance.isOrAfter(FullChunkStatus.FULL);
    }

    @Inject(method={"guardEntityTick"}, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Ljava/util/function/Consumer;accept(Ljava/lang/Object;)V")})
    private void midTickEntity(CallbackInfo ci) {
        this.moonrise$midTickTasks();
    }
}

