/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.chunk_system;

import ca.spottedleaf.moonrise.patches.chunk_system.ticks.ChunkSystemLevelChunkTicks;
import java.util.List;
import java.util.Queue;
import java.util.function.Function;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.ticks.LevelChunkTicks;
import net.minecraft.world.ticks.SavedTick;
import net.minecraft.world.ticks.ScheduledTick;
import net.minecraft.world.ticks.SerializableTickContainer;
import net.minecraft.world.ticks.TickContainerAccess;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LevelChunkTicks.class})
abstract class LevelChunkTicksMixin<T>
implements ChunkSystemLevelChunkTicks,
SerializableTickContainer<T>,
TickContainerAccess<T> {
    @Shadow
    @Final
    private Queue<ScheduledTick<T>> tickQueue;
    @Shadow
    private List<SavedTick<T>> pendingTicks;
    @Unique
    private boolean dirty;
    @Unique
    private long lastSaved = Long.MIN_VALUE;

    LevelChunkTicksMixin() {
    }

    @Override
    public final boolean moonrise$isDirty(long tick) {
        return this.dirty || !this.tickQueue.isEmpty() && tick != this.lastSaved;
    }

    @Override
    public final void moonrise$clearDirty() {
        this.dirty = false;
    }

    @Inject(method={"poll"}, at={@At(value="INVOKE", target="Ljava/util/Set;remove(Ljava/lang/Object;)Z")})
    private void pollHook(CallbackInfoReturnable<ScheduledTick<T>> cir) {
        this.dirty = true;
    }

    @Inject(method={"schedule"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/ticks/LevelChunkTicks;scheduleUnchecked(Lnet/minecraft/world/ticks/ScheduledTick;)V")})
    private void scheduleHook(CallbackInfo ci) {
        this.dirty = true;
    }

    @Inject(method={"removeIf"}, at={@At(value="INVOKE", target="Ljava/util/Iterator;remove()V")})
    private void removeHook(CallbackInfo ci) {
        this.dirty = true;
    }

    @Inject(method={"save(JLjava/util/function/Function;)Lnet/minecraft/nbt/ListTag;"}, at={@At(value="HEAD")})
    private void saveHook(long time, Function<T, String> idFunction, CallbackInfoReturnable<ListTag> cir) {
        this.lastSaved = time;
    }

    @Inject(method={"unpack"}, at={@At(value="HEAD")})
    private void unpackHook(long tick, CallbackInfo ci) {
        if (this.pendingTicks == null) {
            return;
        }
        this.lastSaved = tick;
    }
}

