/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.chunk_system;

import ca.spottedleaf.moonrise.patches.chunk_system.level.chunk.ChunkSystemChunkHolder;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.NewChunkHolder;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;
import net.minecraft.server.level.ChunkGenerationTask;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ChunkResult;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.GeneratingChunkMap;
import net.minecraft.server.level.GenerationChunkHolder;
import net.minecraft.util.StaticCache2D;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ImposterProtoChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.status.ChunkStep;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GenerationChunkHolder.class})
abstract class GenerationChunkHolderMixin {
    @Shadow
    private AtomicReference<ChunkStatus> startedWork;
    @Shadow
    private AtomicReferenceArray<CompletableFuture<ChunkResult<ChunkAccess>>> futures;
    @Shadow
    private AtomicReference<ChunkGenerationTask> task;
    @Shadow
    private AtomicInteger generationRefCount;

    GenerationChunkHolderMixin() {
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void init(CallbackInfo ci) {
        this.startedWork = null;
        this.futures = null;
        this.task = null;
        this.generationRefCount = null;
    }

    @Overwrite
    public CompletableFuture<ChunkResult<ChunkAccess>> scheduleChunkGenerationTask(ChunkStatus chunkStatus, ChunkMap chunkMap) {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public CompletableFuture<ChunkResult<ChunkAccess>> applyStep(ChunkStep chunkStep, GeneratingChunkMap generatingChunkMap, StaticCache2D<GenerationChunkHolder> staticCache2D) {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public void updateHighestAllowedStatus(ChunkMap chunkMap) {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public void replaceProtoChunk(ImposterProtoChunk imposterProtoChunk) {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public void removeTask(ChunkGenerationTask chunkGenerationTask) {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public void rescheduleChunkTask(ChunkMap chunkMap, ChunkStatus chunkStatus) {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public CompletableFuture<ChunkResult<ChunkAccess>> getOrCreateFuture(ChunkStatus chunkStatus) {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public void failAndClearPendingFuturesBetween(ChunkStatus from, ChunkStatus to) {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public void failAndClearPendingFuture(int idx, CompletableFuture<ChunkResult<ChunkAccess>> expect) {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public void completeFuture(ChunkStatus status, ChunkAccess chunk) {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public ChunkStatus findHighestStatusWithPendingFuture(ChunkStatus from) {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public boolean acquireStatusBump(ChunkStatus chunkStatus) {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public boolean isStatusDisallowed(ChunkStatus chunkStatus) {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public void increaseGenerationRefCount() {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public void decreaseGenerationRefCount() {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public int getGenerationRefCount() {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public ChunkAccess getChunkIfPresentUnchecked(ChunkStatus chunkStatus) {
        return ((ChunkSystemChunkHolder)((Object)this)).moonrise$getRealChunkHolder().getChunkIfPresentUnchecked(chunkStatus);
    }

    @Overwrite
    public ChunkAccess getChunkIfPresent(ChunkStatus chunkStatus) {
        return ((ChunkSystemChunkHolder)((Object)this)).moonrise$getRealChunkHolder().getChunkIfPresent(chunkStatus);
    }

    @Overwrite
    public ChunkAccess getLatestChunk() {
        NewChunkHolder.ChunkCompletion lastCompletion = ((ChunkSystemChunkHolder)((Object)this)).moonrise$getRealChunkHolder().getLastChunkCompletion();
        return lastCompletion == null ? null : lastCompletion.chunk();
    }

    @Overwrite
    public ChunkStatus getPersistedStatus() {
        ChunkAccess chunk = this.getLatestChunk();
        return chunk == null ? null : chunk.getPersistedStatus();
    }

    @Overwrite
    public FullChunkStatus getFullStatus() {
        return ((ChunkSystemChunkHolder)((Object)this)).moonrise$getRealChunkHolder().getChunkStatus();
    }

    @Overwrite
    public List<Pair<ChunkStatus, CompletableFuture<ChunkResult<ChunkAccess>>>> getAllFutures() {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public ChunkStatus getLatestStatus() {
        NewChunkHolder.ChunkCompletion lastCompletion = ((ChunkSystemChunkHolder)((Object)this)).moonrise$getRealChunkHolder().getLastChunkCompletion();
        return lastCompletion == null ? null : lastCompletion.genStatus();
    }
}

