/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.chunk_system;

import ca.spottedleaf.moonrise.common.list.IteratorSafeOrderedReferenceSet;
import com.llamalad7.mixinextras.sugar.Local;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.function.Consumer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.entity.EntityTickList;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EntityTickList.class})
abstract class EntityTickListMixin {
    @Shadow
    private Int2ObjectMap<Entity> active;
    @Shadow
    private Int2ObjectMap<Entity> passive;
    @Unique
    private final IteratorSafeOrderedReferenceSet<Entity> entities = new IteratorSafeOrderedReferenceSet();

    EntityTickListMixin() {
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void initHook(CallbackInfo ci) {
        this.active = null;
        this.passive = null;
    }

    @Overwrite
    public void ensureActiveIsNotIterated() {
    }

    @Redirect(method={"add"}, at=@At(value="INVOKE", target="Lit/unimi/dsi/fastutil/ints/Int2ObjectMap;put(ILjava/lang/Object;)Ljava/lang/Object;", remap=false))
    private <V> V hookAdd(Int2ObjectMap<V> instance, int key, V value) {
        this.entities.add((Entity)value);
        return null;
    }

    @Redirect(method={"remove"}, at=@At(value="INVOKE", target="Lit/unimi/dsi/fastutil/ints/Int2ObjectMap;remove(I)Ljava/lang/Object;", remap=false))
    private <V> V hookRemoveAvoidNPE(Int2ObjectMap<V> instance, int key, @Local(ordinal=0, argsOnly=true) Entity entity) {
        this.entities.remove(entity);
        return null;
    }

    @Overwrite
    public boolean contains(Entity entity) {
        return this.entities.contains(entity);
    }

    @Inject(method={"forEach"}, at={@At(value="HEAD")}, cancellable=true)
    private void injectForEach(Consumer<Entity> consumer, CallbackInfo ci) {
        this.forEach(consumer);
        ci.cancel();
    }

    @Unique
    private void forEach(Consumer<Entity> action) {
        IteratorSafeOrderedReferenceSet.Iterator<Entity> iterator = this.entities.iterator();
        try {
            while (iterator.hasNext()) {
                action.accept((Entity)iterator.next());
            }
        }
        finally {
            iterator.finishedIterating();
        }
    }
}

