/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.chunk_system;

import ca.spottedleaf.moonrise.common.util.MoonriseConstants;
import ca.spottedleaf.moonrise.patches.chunk_system.level.ChunkSystemServerLevel;
import ca.spottedleaf.moonrise.patches.chunk_system.level.chunk.ChunkSystemDistanceManager;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.ChunkHolderManager;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.NewChunkHolder;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Set;
import java.util.concurrent.Executor;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ChunkTaskPriorityQueueSorter;
import net.minecraft.server.level.DistanceManager;
import net.minecraft.server.level.Ticket;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.TickingTracker;
import net.minecraft.util.Mth;
import net.minecraft.util.SortedArraySet;
import net.minecraft.util.thread.ProcessorHandle;
import net.minecraft.world.level.ChunkPos;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={DistanceManager.class})
abstract class DistanceManagerMixin
implements ChunkSystemDistanceManager {
    @Shadow
    Long2ObjectOpenHashMap<SortedArraySet<Ticket<?>>> tickets;
    @Shadow
    private DistanceManager.ChunkTicketTracker ticketTracker;
    @Shadow
    private TickingTracker tickingTicketsTracker;
    @Shadow
    private DistanceManager.PlayerTicketTracker playerTicketManager;
    @Shadow
    Set<ChunkHolder> chunksToUpdateFutures;
    @Shadow
    ChunkTaskPriorityQueueSorter ticketThrottler;
    @Shadow
    ProcessorHandle<ChunkTaskPriorityQueueSorter.Message<Runnable>> ticketThrottlerInput;
    @Shadow
    ProcessorHandle<ChunkTaskPriorityQueueSorter.Release> ticketThrottlerReleaser;
    @Shadow
    LongSet ticketsToRelease;
    @Shadow
    Executor mainThreadExecutor;
    @Shadow
    private DistanceManager.FixedPlayerDistanceChunkTracker naturalSpawnChunkCounter;
    @Shadow
    private int simulationDistance;

    DistanceManagerMixin() {
    }

    @Override
    public ChunkMap moonrise$getChunkMap() {
        throw new AbstractMethodError();
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void destroyFields(CallbackInfo ci) {
        this.tickets = null;
        this.ticketTracker = null;
        this.tickingTicketsTracker = null;
        this.playerTicketManager = null;
        this.chunksToUpdateFutures = null;
        this.ticketThrottler = null;
        this.ticketThrottlerInput = null;
        this.ticketThrottlerReleaser = null;
        this.ticketsToRelease = null;
        this.mainThreadExecutor = null;
        this.simulationDistance = -1;
    }

    @Override
    public ChunkHolderManager moonrise$getChunkHolderManager() {
        return ((ChunkSystemServerLevel)this.moonrise$getChunkMap().level).moonrise$getChunkTaskScheduler().chunkHolderManager;
    }

    @Overwrite
    public void purgeStaleTickets() {
        this.moonrise$getChunkHolderManager().tick();
    }

    @Overwrite
    public boolean runAllUpdates(ChunkMap chunkStorage) {
        return this.moonrise$getChunkHolderManager().processTicketUpdates();
    }

    @Overwrite
    public void addTicket(long pos, Ticket<?> ticket) {
        this.moonrise$getChunkHolderManager().addTicketAtLevel(ticket.getType(), pos, ticket.getTicketLevel(), ticket.key);
    }

    @Overwrite
    public void removeTicket(long pos, Ticket<?> ticket) {
        this.moonrise$getChunkHolderManager().removeTicketAtLevel(ticket.getType(), pos, ticket.getTicketLevel(), ticket.key);
    }

    @Overwrite
    public SortedArraySet<Ticket<?>> getTickets(long pos) {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public void updateChunkForced(ChunkPos pos, boolean forced) {
        if (forced) {
            this.moonrise$getChunkHolderManager().addTicketAtLevel(TicketType.FORCED, pos, ChunkMap.FORCED_TICKET_LEVEL, pos);
        } else {
            this.moonrise$getChunkHolderManager().removeTicketAtLevel(TicketType.FORCED, pos, ChunkMap.FORCED_TICKET_LEVEL, pos);
        }
    }

    @Redirect(method={"addPlayer"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/DistanceManager$PlayerTicketTracker;update(JIZ)V"))
    private void skipTickingTicketTrackerAdd(DistanceManager.PlayerTicketTracker instance, long l, int i, boolean b) {
    }

    @Redirect(method={"addPlayer"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/TickingTracker;addTicket(Lnet/minecraft/server/level/TicketType;Lnet/minecraft/world/level/ChunkPos;ILjava/lang/Object;)V"))
    private <T> void skipTickingTicketTrackerAdd(TickingTracker instance, TicketType<T> ticketType, ChunkPos chunkPos, int i, T object) {
    }

    @Redirect(method={"addPlayer"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/DistanceManager;getPlayerTicketLevel()I"))
    private int skipTicketLevelAdd(DistanceManager instance) {
        return 0;
    }

    @Redirect(method={"removePlayer"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/DistanceManager$PlayerTicketTracker;update(JIZ)V"))
    private void skipTickingTicketTrackerRemove(DistanceManager.PlayerTicketTracker instance, long l, int i, boolean b) {
    }

    @Redirect(method={"removePlayer"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/TickingTracker;removeTicket(Lnet/minecraft/server/level/TicketType;Lnet/minecraft/world/level/ChunkPos;ILjava/lang/Object;)V"))
    private <T> void skipTickingTicketTrackerRemove(TickingTracker instance, TicketType<T> ticketType, ChunkPos chunkPos, int i, T object) {
    }

    @Redirect(method={"removePlayer"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/DistanceManager;getPlayerTicketLevel()I"))
    private int skipTicketLevelRemove(DistanceManager instance) {
        return 0;
    }

    @Overwrite
    public int getPlayerTicketLevel() {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public boolean inEntityTickingRange(long pos) {
        NewChunkHolder chunkHolder = this.moonrise$getChunkHolderManager().getChunkHolder(pos);
        return chunkHolder != null && chunkHolder.isEntityTickingReady();
    }

    @Overwrite
    public boolean inBlockTickingRange(long pos) {
        NewChunkHolder chunkHolder = this.moonrise$getChunkHolderManager().getChunkHolder(pos);
        return chunkHolder != null && chunkHolder.isTickingReady();
    }

    @Overwrite
    public String getTicketDebugString(long pos) {
        return this.moonrise$getChunkHolderManager().getTicketDebugString(pos);
    }

    @Overwrite
    public void updatePlayerTickets(int viewDistance) {
        this.moonrise$getChunkMap().setServerViewDistance(viewDistance);
    }

    @Overwrite
    public void updateSimulationDistance(int simulationDistance) {
        int clamped = Mth.clamp((int)simulationDistance, (int)0, (int)MoonriseConstants.MAX_VIEW_DISTANCE);
        ((ChunkSystemServerLevel)this.moonrise$getChunkMap().level).moonrise$getPlayerChunkLoader().setTickDistance(clamped);
    }

    @Overwrite
    public String getDebugStatus() {
        return "No DistanceManager stats available";
    }

    @Overwrite
    public void dumpTickets(String file) {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public TickingTracker tickingTracker() {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public void removeTicketsOnClosing() {
    }

    @Overwrite
    public boolean hasTickets() {
        throw new UnsupportedOperationException();
    }
}

