/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.chunk_system;

import ca.spottedleaf.moonrise.common.util.ChunkSystem;
import ca.spottedleaf.moonrise.common.util.MoonriseConstants;
import ca.spottedleaf.moonrise.patches.chunk_system.io.MoonriseRegionFileIO;
import ca.spottedleaf.moonrise.patches.chunk_system.level.ChunkSystemChunkMap;
import ca.spottedleaf.moonrise.patches.chunk_system.level.ChunkSystemServerLevel;
import ca.spottedleaf.moonrise.patches.chunk_system.level.chunk.ChunkSystemChunkHolder;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.NewChunkHolder;
import com.mojang.datafixers.DataFixer;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import java.util.function.IntFunction;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.server.level.ChunkGenerationTask;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ChunkResult;
import net.minecraft.server.level.ChunkTaskPriorityQueueSorter;
import net.minecraft.server.level.ChunkTrackingView;
import net.minecraft.server.level.GeneratingChunkMap;
import net.minecraft.server.level.GenerationChunkHolder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.util.Mth;
import net.minecraft.util.StaticCache2D;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraft.util.thread.ProcessorHandle;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LightChunkGetter;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.status.ChunkStep;
import net.minecraft.world.level.chunk.storage.ChunkStorage;
import net.minecraft.world.level.chunk.storage.IOWorker;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.entity.ChunkStatusUpdateListener;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraft.world.level.storage.LevelStorageSource;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ChunkMap.class})
abstract class ChunkMapMixin
extends ChunkStorage
implements ChunkSystemChunkMap,
ChunkHolder.PlayerProvider,
GeneratingChunkMap {
    @Shadow
    @Final
    public ServerLevel level;
    @Shadow
    private Long2ObjectLinkedOpenHashMap<ChunkHolder> updatingChunkMap;
    @Shadow
    private volatile Long2ObjectLinkedOpenHashMap<ChunkHolder> visibleChunkMap;
    @Shadow
    private ChunkTaskPriorityQueueSorter queueSorter;
    @Shadow
    private ProcessorHandle<ChunkTaskPriorityQueueSorter.Message<Runnable>> worldgenMailbox;
    @Shadow
    private ProcessorHandle<ChunkTaskPriorityQueueSorter.Message<Runnable>> mainThreadMailbox;
    @Shadow
    private int serverViewDistance;
    @Shadow
    private Long2ObjectLinkedOpenHashMap<ChunkHolder> pendingUnloads;
    @Shadow
    private List<ChunkGenerationTask> pendingGenerationTasks;
    @Shadow
    private Queue<Runnable> unloadQueue;

    public ChunkMapMixin(RegionStorageInfo regionStorageInfo, Path path, DataFixer dataFixer, boolean bl) {
        super(regionStorageInfo, path, dataFixer, bl);
    }

    @Override
    public final void moonrise$writeFinishCallback(ChunkPos pos) throws IOException {
        this.handleLegacyStructureIndex(pos);
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void constructor(ServerLevel arg, LevelStorageSource.LevelStorageAccess arg2, DataFixer dataFixer, StructureTemplateManager arg3, Executor executor, BlockableEventLoop<Runnable> arg4, LightChunkGetter arg5, ChunkGenerator arg6, ChunkProgressListener arg7, ChunkStatusUpdateListener arg8, Supplier<DimensionDataStorage> supplier, int j, boolean bl, CallbackInfo ci) {
        this.updatingChunkMap = null;
        this.visibleChunkMap = null;
        this.pendingUnloads = null;
        this.queueSorter = null;
        this.worldgenMailbox = null;
        this.mainThreadMailbox = null;
        this.pendingGenerationTasks = null;
        this.unloadQueue = null;
        this.worker = new IOWorker(new RegionStorageInfo(arg2.getLevelId(), arg.dimension(), "chunk"), arg2.getDimensionPath(arg.dimension()).resolve("region"), bl){

            public boolean isOldChunkAround(ChunkPos chunkPos, int i) {
                throw new UnsupportedOperationException();
            }

            public CompletableFuture<Void> store(ChunkPos chunkPos, @Nullable CompoundTag compoundTag) {
                throw new UnsupportedOperationException();
            }

            public CompletableFuture<Optional<CompoundTag>> loadAsync(ChunkPos chunkPos) {
                CompletableFuture<Optional<CompoundTag>> future = new CompletableFuture<Optional<CompoundTag>>();
                MoonriseRegionFileIO.loadDataAsync(ChunkMapMixin.this.level, chunkPos.x, chunkPos.z, MoonriseRegionFileIO.RegionFileType.CHUNK_DATA, (tag, throwable) -> {
                    if (throwable != null) {
                        future.completeExceptionally((Throwable)throwable);
                    } else {
                        future.complete(Optional.ofNullable(tag));
                    }
                }, false);
                return future;
            }

            public CompletableFuture<Void> synchronize(boolean bl) {
                throw new UnsupportedOperationException();
            }

            public CompletableFuture<Void> scanChunk(ChunkPos chunkPos, StreamTagVisitor streamTagVisitor) {
                throw new UnsupportedOperationException();
            }

            public void close() throws IOException {
                throw new UnsupportedOperationException();
            }

            public RegionStorageInfo storageInfo() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Overwrite
    public boolean isChunkTracked(ServerPlayer player, int chunkX, int chunkZ) {
        return ((ChunkSystemServerLevel)this.level).moonrise$getPlayerChunkLoader().isChunkSent(player, chunkX, chunkZ);
    }

    @Overwrite
    public boolean isChunkOnTrackedBorder(ServerPlayer player, int chunkX, int chunkZ) {
        return ((ChunkSystemServerLevel)this.level).moonrise$getPlayerChunkLoader().isChunkSent(player, chunkX, chunkZ, true);
    }

    @Overwrite
    public ChunkHolder getUpdatingChunkIfPresent(long pos) {
        NewChunkHolder holder = ((ChunkSystemServerLevel)this.level).moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(pos);
        return holder == null ? null : holder.vanillaChunkHolder;
    }

    @Overwrite
    public ChunkHolder getVisibleChunkIfPresent(long pos) {
        NewChunkHolder holder = ((ChunkSystemServerLevel)this.level).moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(pos);
        return holder == null ? null : holder.vanillaChunkHolder;
    }

    @Overwrite
    public IntSupplier getChunkQueueLevel(long pos) {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public CompletableFuture<ChunkResult<List<ChunkAccess>>> getChunkRangeFuture(ChunkHolder centerChunk, int margin, IntFunction<ChunkStatus> distanceToStatus) {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public CompletableFuture<ChunkResult<List<ChunkAccess>>> prepareEntityTickingChunk(ChunkHolder chunk) {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public ChunkHolder updateChunkScheduling(long pos, int level, ChunkHolder holder, int newLevel) {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public void close() throws IOException {
        throw new UnsupportedOperationException("Use ServerChunkCache#close");
    }

    @Overwrite
    public void saveAllChunks(boolean flush) {
        boolean shutdown = ((ChunkSystemServerLevel)this.level).moonrise$isMarkedClosing();
        if (!shutdown) {
            ((ChunkSystemServerLevel)this.level).moonrise$getChunkTaskScheduler().chunkHolderManager.saveAllChunks(flush, false, false);
        } else {
            ((ChunkSystemServerLevel)this.level).moonrise$getChunkTaskScheduler().chunkHolderManager.close(true, true);
        }
    }

    @Overwrite
    public boolean hasWork() {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public void processUnloads(BooleanSupplier shouldKeepTicking) {
        ((ChunkSystemServerLevel)this.level).moonrise$getChunkTaskScheduler().chunkHolderManager.processUnloads();
        ((ChunkSystemServerLevel)this.level).moonrise$getChunkTaskScheduler().chunkHolderManager.autoSave();
    }

    @Overwrite
    public void scheduleUnload(long pos, ChunkHolder holder) {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public boolean promoteChunkMap() {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public CompletableFuture<ChunkResult<ChunkAccess>> scheduleChunkLoad(ChunkPos pos) {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public GenerationChunkHolder acquireGeneration(long pos) {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public void releaseGeneration(GenerationChunkHolder holder) {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public CompletableFuture<ChunkAccess> applyStep(GenerationChunkHolder generationChunkHolder, ChunkStep chunkStep, StaticCache2D<GenerationChunkHolder> staticCache2D) {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public ChunkGenerationTask scheduleGenerationTask(ChunkStatus chunkStatus, ChunkPos chunkPos) {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public void runGenerationTasks() {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public CompletableFuture<ChunkResult<LevelChunk>> prepareTickingChunk(ChunkHolder holder) {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public void onChunkReadyToSend(LevelChunk chunk) {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public CompletableFuture<ChunkResult<LevelChunk>> prepareAccessibleChunk(ChunkHolder holder) {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public boolean saveChunkIfNeeded(ChunkHolder chunkHolder) {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public boolean save(ChunkAccess chunk) {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public boolean isExistingChunkFull(ChunkPos pos) {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public void setServerViewDistance(int watchDistance) {
        int clamped = Mth.clamp((int)watchDistance, (int)2, (int)MoonriseConstants.MAX_VIEW_DISTANCE);
        if (clamped == this.serverViewDistance) {
            return;
        }
        this.serverViewDistance = clamped;
        ((ChunkSystemServerLevel)this.level).moonrise$getPlayerChunkLoader().setLoadDistance(this.serverViewDistance + 1);
    }

    @Overwrite
    public int getPlayerViewDistance(ServerPlayer player) {
        return ChunkSystem.getSendViewDistance(player);
    }

    @Overwrite
    public void markChunkPendingToSend(ServerPlayer player, ChunkPos pos) {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public static void markChunkPendingToSend(ServerPlayer player, LevelChunk chunk) {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public static void dropChunk(ServerPlayer player, ChunkPos pos) {
    }

    @Overwrite
    public void dumpChunks(Writer writer) throws IOException {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<Optional<CompoundTag>> read(ChunkPos pos) {
        CompletableFuture<Optional<CompoundTag>> ret = new CompletableFuture<Optional<CompoundTag>>();
        MoonriseRegionFileIO.loadDataAsync(this.level, pos.x, pos.z, MoonriseRegionFileIO.RegionFileType.CHUNK_DATA, (data, thr) -> {
            if (thr != null) {
                ret.completeExceptionally((Throwable)thr);
            } else {
                ret.complete(Optional.ofNullable(data));
            }
        }, false);
        return ret;
    }

    public CompletableFuture<Void> write(ChunkPos pos, CompoundTag tag) {
        MoonriseRegionFileIO.scheduleSave(this.level, pos.x, pos.z, tag, MoonriseRegionFileIO.RegionFileType.CHUNK_DATA);
        return null;
    }

    public void flushWorker() {
        MoonriseRegionFileIO.flush(this.level);
    }

    @Redirect(method={"updatePlayerStatus"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ChunkMap;updateChunkTracking(Lnet/minecraft/server/level/ServerPlayer;)V"))
    private void avoidUpdateChunkTrackingInUpdate(ChunkMap instance, ServerPlayer serverPlayer) {
        ChunkSystem.addPlayerToDistanceMaps(this.level, serverPlayer);
    }

    @Redirect(method={"tick()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ChunkMap;updateChunkTracking(Lnet/minecraft/server/level/ServerPlayer;)V"))
    private void skipChunkTrackingInTick(ChunkMap instance, ServerPlayer serverPlayer) {
    }

    @Redirect(method={"updatePlayerStatus"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ChunkMap;applyChunkTrackingView(Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/server/level/ChunkTrackingView;)V"))
    private void avoidApplyChunkTrackingViewInUpdate(ChunkMap instance, ServerPlayer serverPlayer, ChunkTrackingView chunkTrackingView) {
        ChunkSystem.removePlayerFromDistanceMaps(this.level, serverPlayer);
    }

    @Inject(method={"move"}, at={@At(value="RETURN")})
    private void updateMapsHook(ServerPlayer player, CallbackInfo ci) {
        ChunkSystem.updateMaps(this.level, player);
    }

    @Redirect(method={"move"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ChunkMap;updateChunkTracking(Lnet/minecraft/server/level/ServerPlayer;)V"))
    private void avoidSetChunkTrackingViewInMove(ChunkMap instance, ServerPlayer serverPlayer) {
    }

    @Overwrite
    public void updateChunkTracking(ServerPlayer player) {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public void applyChunkTrackingView(ServerPlayer player, ChunkTrackingView chunkFilter) {
        throw new UnsupportedOperationException();
    }

    @Overwrite
    public List<ServerPlayer> getPlayers(ChunkPos chunkPos, boolean onlyOnWatchDistanceEdge) {
        ChunkHolder holder = this.getVisibleChunkIfPresent(chunkPos.toLong());
        if (holder == null) {
            return new ArrayList<ServerPlayer>();
        }
        return ((ChunkSystemChunkHolder)holder).moonrise$getPlayers(onlyOnWatchDistanceEdge);
    }

    @Overwrite
    public void waitForLightBeforeSending(ChunkPos centerPos, int radius) {
    }

    @Overwrite
    public int size() {
        return ((ChunkSystemServerLevel)this.level).moonrise$getChunkTaskScheduler().chunkHolderManager.size();
    }

    @Overwrite
    public Iterable<ChunkHolder> getChunks() {
        return ((ChunkSystemServerLevel)this.level).moonrise$getChunkTaskScheduler().chunkHolderManager.getOldChunkHoldersIterable();
    }
}

