/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.blockstate_propertyaccess;

import ca.spottedleaf.moonrise.patches.blockstate_propertyaccess.PropertyAccessStateHolder;
import ca.spottedleaf.moonrise.patches.blockstate_propertyaccess.util.ZeroCollidingReferenceStateTable;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={StateHolder.class})
abstract class StateHolderMixin<O, S>
implements PropertyAccessStateHolder {
    @Shadow
    @Final
    protected O owner;
    @Shadow
    @Mutable
    @Final
    private Reference2ObjectArrayMap<Property<?>, Comparable<?>> values;
    @Unique
    protected ZeroCollidingReferenceStateTable<O, S> optimisedTable;
    @Unique
    protected long tableIndex;

    StateHolderMixin() {
    }

    @Override
    public final long moonrise$getTableIndex() {
        return this.tableIndex;
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void init(CallbackInfo ci) {
        this.optimisedTable = new ZeroCollidingReferenceStateTable((Collection<Property<?>>)this.values.keySet());
        this.tableIndex = this.optimisedTable.getIndex((StateHolder)this);
    }

    @Inject(method={"populateNeighbours"}, cancellable=true, at={@At(value="HEAD")})
    private void loadTable(Map<Map<Property<?>, Comparable<?>>, S> map, CallbackInfo ci) {
        S value;
        if (this.optimisedTable.isLoaded()) {
            ci.cancel();
            return;
        }
        this.optimisedTable.loadInTable(map);
        for (Map.Entry<Map<Property<?>, Comparable<?>>, S> entry : map.entrySet()) {
            value = entry.getValue();
            ((StateHolderMixin)((StateHolder)value)).optimisedTable = this.optimisedTable;
        }
        this.values = null;
        for (Map.Entry<Map<Property<?>, Comparable<?>>, S> entry : map.entrySet()) {
            value = entry.getValue();
            ((StateHolderMixin)((StateHolder)value)).values = null;
        }
        ci.cancel();
    }

    @Overwrite
    public <T extends Comparable<T>, V extends T> S setValue(Property<T> property, V value) {
        S ret = this.optimisedTable.set(this.tableIndex, property, value);
        if (ret != null) {
            return ret;
        }
        throw new IllegalArgumentException("Cannot set property " + String.valueOf(property) + " to " + String.valueOf(value) + " on " + String.valueOf(this.owner));
    }

    @Overwrite
    public <T extends Comparable<T>, V extends T> S trySetValue(Property<T> property, V value) {
        if (property == null) {
            return (S)((StateHolder)this);
        }
        StateHolder ret = this.optimisedTable.trySet(this.tableIndex, property, value, (StateHolder)this);
        if (ret != null) {
            return (S)ret;
        }
        throw new IllegalArgumentException("Cannot set property " + String.valueOf(property) + " to " + String.valueOf(value) + " on " + String.valueOf(this.owner));
    }

    @Overwrite
    public <T extends Comparable<T>> Optional<T> getOptionalValue(Property<T> property) {
        return property == null ? Optional.empty() : Optional.ofNullable(this.optimisedTable.get(this.tableIndex, property));
    }

    @Overwrite
    public <T extends Comparable<T>> T getValue(Property<T> property) {
        T ret = this.optimisedTable.get(this.tableIndex, property);
        if (ret != null) {
            return ret;
        }
        throw new IllegalArgumentException("Cannot get property " + String.valueOf(property) + " as it does not exist in " + String.valueOf(this.owner));
    }

    @Overwrite
    public <T extends Comparable<T>> boolean hasProperty(Property<T> property) {
        return property != null && this.optimisedTable.hasProperty(property);
    }

    @Overwrite
    public Collection<Property<?>> getProperties() {
        return this.optimisedTable.getProperties();
    }

    @Overwrite
    public Map<Property<?>, Comparable<?>> getValues() {
        ZeroCollidingReferenceStateTable<O, S> table = this.optimisedTable;
        return table.isLoaded() ? table.getMapView(this.tableIndex) : this.values;
    }
}

