/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.block_counting;

import ca.spottedleaf.moonrise.patches.block_counting.BlockCountingBitStorage;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.shorts.ShortArrayList;
import net.minecraft.util.BitStorage;
import net.minecraft.util.SimpleBitStorage;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={SimpleBitStorage.class})
abstract class SimpleBitStorageMixin
implements BitStorage,
BlockCountingBitStorage {
    @Shadow
    @Final
    private long[] data;
    @Shadow
    @Final
    private int valuesPerLong;
    @Shadow
    @Final
    private int bits;
    @Shadow
    @Final
    private int size;

    SimpleBitStorageMixin() {
    }

    @Override
    public final Int2ObjectOpenHashMap<ShortArrayList> moonrise$countEntries() {
        int valuesPerLong = this.valuesPerLong;
        int bits = this.bits;
        long mask = (1L << bits) - 1L;
        int size = this.size;
        if (bits <= 6) {
            ShortArrayList[] byId = new ShortArrayList[1 << bits];
            Int2ObjectOpenHashMap ret = new Int2ObjectOpenHashMap(1 << bits);
            int index = 0;
            for (long value : this.data) {
                int li = 0;
                do {
                    ShortArrayList newCoords;
                    int paletteIdx = (int)(value & mask);
                    value >>= bits;
                    ++li;
                    ShortArrayList coords = byId[paletteIdx];
                    if (coords != null) {
                        coords.add((short)index++);
                        continue;
                    }
                    byId[paletteIdx] = newCoords = new ShortArrayList(64);
                    newCoords.add((short)index++);
                    ret.put(paletteIdx, (Object)newCoords);
                } while (li < valuesPerLong && index < size);
            }
            return ret;
        }
        Int2ObjectOpenHashMap ret = new Int2ObjectOpenHashMap(64);
        int index = 0;
        for (long value : this.data) {
            int li = 0;
            do {
                int paletteIdx = (int)(value & mask);
                value >>= bits;
                ((ShortArrayList)ret.computeIfAbsent(paletteIdx, key -> new ShortArrayList(64))).add((short)index++);
            } while (++li < valuesPerLong && index < size);
        }
        return ret;
    }
}

