/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.mixin.block_counting;

import ca.spottedleaf.moonrise.common.list.ShortList;
import ca.spottedleaf.moonrise.patches.block_counting.BlockCountingBitStorage;
import ca.spottedleaf.moonrise.patches.block_counting.BlockCountingChunkSection;
import ca.spottedleaf.moonrise.patches.collisions.CollisionUtil;
import com.llamalad7.mixinextras.sugar.Local;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.shorts.ShortArrayList;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.util.BitStorage;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.Palette;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.material.FluidState;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LevelChunkSection.class})
abstract class LevelChunkSectionMixin
implements BlockCountingChunkSection {
    @Shadow
    @Final
    public PalettedContainer<BlockState> states;
    @Shadow
    private short nonEmptyBlockCount;
    @Shadow
    private short tickingBlockCount;
    @Shadow
    private short tickingFluidCount;
    @Unique
    private static final ShortArrayList FULL_LIST = new ShortArrayList(4096);
    @Unique
    private boolean isClient;
    @Unique
    private static final short CLIENT_FORCED_SPECIAL_COLLIDING_BLOCKS = 9999;
    @Unique
    private short specialCollidingBlocks;
    @Unique
    private final ShortList tickingBlocks = new ShortList();

    LevelChunkSectionMixin() {
    }

    @Shadow
    public abstract boolean maybeHas(Predicate<BlockState> var1);

    @Override
    public final boolean moonrise$hasSpecialCollidingBlocks() {
        return this.specialCollidingBlocks != 0;
    }

    @Override
    public final ShortList moonrise$getTickingBlockList() {
        return this.tickingBlocks;
    }

    @Inject(method={"setBlockState(IIILnet/minecraft/world/level/block/state/BlockState;Z)Lnet/minecraft/world/level/block/state/BlockState;"}, at={@At(value="RETURN")})
    private void updateBlockCallback(int x, int y, int z, BlockState newState, boolean lock, CallbackInfoReturnable<BlockState> cir, @Local(ordinal=1) BlockState oldState) {
        boolean newTicking;
        boolean oldTicking;
        boolean isSpecialNew;
        if (oldState == newState) {
            return;
        }
        if (this.isClient) {
            if (CollisionUtil.isSpecialCollidingBlock((BlockBehaviour.BlockStateBase)newState)) {
                this.specialCollidingBlocks = (short)9999;
            }
            return;
        }
        boolean isSpecialOld = CollisionUtil.isSpecialCollidingBlock((BlockBehaviour.BlockStateBase)oldState);
        if (isSpecialOld != (isSpecialNew = CollisionUtil.isSpecialCollidingBlock((BlockBehaviour.BlockStateBase)newState))) {
            this.specialCollidingBlocks = isSpecialOld ? (short)(this.specialCollidingBlocks - 1) : (short)(this.specialCollidingBlocks + 1);
        }
        if ((oldTicking = oldState.isRandomlyTicking()) != (newTicking = newState.isRandomlyTicking())) {
            ShortList tickingBlocks = this.tickingBlocks;
            short position = (short)(x | z << 4 | y << 8);
            if (oldTicking) {
                tickingBlocks.remove(position);
            } else {
                tickingBlocks.add(position);
            }
        }
    }

    @Redirect(method={"setBlockState(IIILnet/minecraft/world/level/block/state/BlockState;Z)Lnet/minecraft/world/level/block/state/BlockState;"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/material/FluidState;isEmpty()Z"))
    private boolean fixTickingFluidCount(FluidState instance) {
        return !instance.isRandomlyTicking();
    }

    @Overwrite
    public void recalcBlockCounts() {
        this.nonEmptyBlockCount = 0;
        this.tickingBlockCount = 0;
        this.tickingFluidCount = 0;
        this.specialCollidingBlocks = 0;
        this.tickingBlocks.clear();
        if (this.maybeHas(state -> !state.isAir())) {
            Int2ObjectOpenHashMap counts;
            PalettedContainer.Data data = this.states.data;
            Palette palette = data.palette;
            int paletteSize = palette.getSize();
            BitStorage storage = data.storage;
            if (paletteSize == 1) {
                counts = new Int2ObjectOpenHashMap(1);
                counts.put(0, (Object)FULL_LIST);
            } else {
                counts = ((BlockCountingBitStorage)storage).moonrise$countEntries();
            }
            ObjectIterator iterator = counts.int2ObjectEntrySet().fastIterator();
            while (iterator.hasNext()) {
                FluidState fluid;
                Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)iterator.next();
                int paletteIdx = entry.getIntKey();
                ShortArrayList coordinates = (ShortArrayList)entry.getValue();
                int paletteCount = coordinates.size();
                BlockState state2 = (BlockState)palette.valueFor(paletteIdx);
                if (state2.isAir()) continue;
                if (CollisionUtil.isSpecialCollidingBlock((BlockBehaviour.BlockStateBase)state2)) {
                    this.specialCollidingBlocks = (short)(this.specialCollidingBlocks + (short)paletteCount);
                }
                this.nonEmptyBlockCount = (short)(this.nonEmptyBlockCount + (short)paletteCount);
                if (state2.isRandomlyTicking()) {
                    this.tickingBlockCount = (short)(this.tickingBlockCount + (short)paletteCount);
                    short[] raw = coordinates.elements();
                    int rawLen = raw.length;
                    ShortList tickingBlocks = this.tickingBlocks;
                    tickingBlocks.setMinCapacity(Math.min((rawLen + tickingBlocks.size()) * 3 / 2, 4096));
                    Objects.checkFromToIndex(0, paletteCount, rawLen);
                    for (int i = 0; i < paletteCount; ++i) {
                        tickingBlocks.add(raw[i]);
                    }
                }
                if ((fluid = state2.getFluidState()).isEmpty() || !fluid.isRandomlyTicking()) continue;
                this.tickingFluidCount = (short)(this.tickingFluidCount + (short)paletteCount);
            }
        }
    }

    @Inject(method={"read"}, at={@At(value="RETURN")})
    private void callRecalcBlocksClient(CallbackInfo ci) {
        this.isClient = true;
        this.specialCollidingBlocks = this.nonEmptyBlockCount != 0 && this.maybeHas(CollisionUtil::isSpecialCollidingBlock) ? 9999 : 0;
    }

    static {
        for (short i = 0; i < 4096; i = (short)(i + 1)) {
            FULL_LIST.add(i);
        }
    }
}

