/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.libs.ca.spottedleaf.yamlconfig.type;

import java.math.BigDecimal;

public final class Duration {
    private final String string;
    private final long timeNS;

    private Duration(String string, long timeNS) {
        this.string = string;
        this.timeNS = timeNS;
    }

    public static Duration parse(String value) {
        if (value.length() < 2) {
            throw new IllegalArgumentException("Invalid duration: " + value);
        }
        char last = value.charAt(value.length() - 1);
        BigDecimal parsed = new BigDecimal(value.substring(0, value.length() - 1)).multiply(new BigDecimal(switch (last) {
            case 's' -> 1000000000L;
            case 't' -> 50000000L;
            case 'm' -> 60000000000L;
            case 'h' -> 3600000000000L;
            case 'd' -> 86400000000000L;
            default -> throw new IllegalArgumentException("Duration must end with one of: [s, t, m, h, d]");
        }));
        return new Duration(value, parsed.toBigInteger().longValueExact());
    }

    public long getTimeNS() {
        return this.timeNS;
    }

    public long getTimeMS() {
        return this.timeNS / 1000000L;
    }

    public long getTimeS() {
        return this.timeNS / 1000000000L;
    }

    public long getTimeTicks() {
        return this.timeNS / 50000000L;
    }

    public String toString() {
        return this.string;
    }
}

