/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.libs.ca.spottedleaf.yamlconfig.adapter.primitive;

import ca.spottedleaf.moonrise.libs.ca.spottedleaf.yamlconfig.adapter.TypeAdapter;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.yamlconfig.adapter.TypeAdapterRegistry;
import java.lang.reflect.Type;
import java.math.BigInteger;

public final class LongTypeAdapter
extends TypeAdapter<Long, Long> {
    public static final LongTypeAdapter INSTANCE = new LongTypeAdapter();

    @Override
    public Long deserialize(TypeAdapterRegistry registry, Object input, Type type) {
        if (input instanceof Number) {
            Long l;
            Number number = (Number)input;
            if (number instanceof BigInteger) {
                BigInteger bigInteger = (BigInteger)number;
                l = bigInteger.longValueExact();
            } else {
                l = number.longValue();
            }
            return l;
        }
        if (input instanceof String) {
            String string = (String)input;
            try {
                return Long.parseLong(string);
            }
            catch (NumberFormatException ex) {
                return (long)Double.parseDouble(string);
            }
        }
        throw new IllegalArgumentException("Not a long type: " + String.valueOf(input.getClass()));
    }

    @Override
    public Long serialize(TypeAdapterRegistry registry, Long value, Type type) {
        return value;
    }
}

