/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.libs.ca.spottedleaf.yamlconfig.adapter.primitive;

import ca.spottedleaf.moonrise.libs.ca.spottedleaf.yamlconfig.adapter.TypeAdapter;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.yamlconfig.adapter.TypeAdapterRegistry;
import java.lang.reflect.Type;
import java.math.BigInteger;

public final class IntegerTypeAdapter
extends TypeAdapter<Integer, Integer> {
    public static final IntegerTypeAdapter INSTANCE = new IntegerTypeAdapter();

    private static Integer cast(Object original, long value) {
        if (value < Integer.MIN_VALUE || value > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Integer value is out of range: " + original.toString());
        }
        return (int)value;
    }

    @Override
    public Integer deserialize(TypeAdapterRegistry registry, Object input, Type type) {
        if (input instanceof Number) {
            long l;
            Number number = (Number)input;
            if (number instanceof BigInteger) {
                BigInteger bigInteger = (BigInteger)number;
                l = bigInteger.longValueExact();
            } else {
                l = number.longValue();
            }
            return IntegerTypeAdapter.cast(input, l);
        }
        if (input instanceof String) {
            String string = (String)input;
            return IntegerTypeAdapter.cast(input, (long)Double.parseDouble(string));
        }
        throw new IllegalArgumentException("Not an integer type: " + String.valueOf(input.getClass()));
    }

    @Override
    public Integer serialize(TypeAdapterRegistry registry, Integer value, Type type) {
        return value;
    }
}

