/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.libs.ca.spottedleaf.concurrentutil.util;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.concurrent.locks.LockSupport;

public final class ConcurrentUtil {
    public static String genericToString(Object object) {
        return object == null ? "null" : object.getClass().getName() + ":" + object.hashCode() + ":" + object.toString();
    }

    public static void rethrow(Throwable exception) {
        ConcurrentUtil.rethrow0(exception);
    }

    private static <T extends Throwable> void rethrow0(Throwable thr) throws T {
        throw thr;
    }

    public static VarHandle getVarHandle(Class<?> lookIn, String fieldName, Class<?> fieldType) {
        try {
            return MethodHandles.privateLookupIn(lookIn, MethodHandles.lookup()).findVarHandle(lookIn, fieldName, fieldType);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static VarHandle getStaticVarHandle(Class<?> lookIn, String fieldName, Class<?> fieldType) {
        try {
            return MethodHandles.privateLookupIn(lookIn, MethodHandles.lookup()).findStaticVarHandle(lookIn, fieldName, fieldType);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void backoff() {
        Thread.onSpinWait();
    }

    public static long exponentiallyBackoffSimple(long counter) {
        for (long i = 0L; i < counter; ++i) {
            ConcurrentUtil.backoff();
        }
        return counter + 1L;
    }

    public static long exponentiallyBackoffComplex(long counter) {
        if (counter < 100L) {
            return ConcurrentUtil.exponentiallyBackoffSimple(counter);
        }
        if (counter < 1200L) {
            Thread.yield();
            LockSupport.parkNanos(1000L);
            return counter + 1L;
        }
        Thread.yield();
        LockSupport.parkNanos(100000L * counter);
        return counter + 1L;
    }

    public static long linearLongBackoff(long counter, long scale, long max) {
        counter = Math.min(Long.MAX_VALUE, counter + 1L);
        max = Math.max(0L, max);
        if (scale <= 0L) {
            return counter;
        }
        long time = scale * counter;
        if (time > max || time / scale != counter) {
            time = max;
        }
        boolean interrupted = Thread.interrupted();
        if (time > 1000000L) {
            Thread.yield();
        }
        LockSupport.parkNanos(time);
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        return counter;
    }

    public static long linearLongBackoffDeadline(long counter, long scale, long max, long deadline) {
        counter = Math.min(Long.MAX_VALUE, counter + 1L);
        max = Math.max(0L, max);
        if (scale <= 0L) {
            return counter;
        }
        long time = scale * counter;
        if (time / scale != counter) {
            --counter;
            time = max;
        } else if (time > max) {
            time = max;
        }
        long currTime = System.nanoTime();
        long diff = deadline - currTime;
        if (diff <= 0L) {
            return counter;
        }
        if (diff <= 1500000L) {
            time = 100000L;
        } else if (time > 1000000L) {
            Thread.yield();
        }
        boolean interrupted = Thread.interrupted();
        LockSupport.parkNanos(time);
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        return counter;
    }

    public static VarHandle getArrayHandle(Class<?> type) {
        return MethodHandles.arrayElementVarHandle(type);
    }
}

