/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.libs.ca.spottedleaf.concurrentutil.map;

import ca.spottedleaf.moonrise.libs.ca.spottedleaf.concurrentutil.function.BiLongObjectConsumer;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.concurrentutil.util.ConcurrentUtil;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.concurrentutil.util.HashUtil;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.concurrentutil.util.IntegerUtil;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.concurrentutil.util.Validate;
import java.lang.invoke.VarHandle;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.LongConsumer;

public class SWMRLong2ObjectHashTable<V> {
    protected int size;
    protected TableEntry<V>[] table;
    protected final float loadFactor;
    protected static final VarHandle SIZE_HANDLE = ConcurrentUtil.getVarHandle(SWMRLong2ObjectHashTable.class, "size", Integer.TYPE);
    protected static final VarHandle TABLE_HANDLE = ConcurrentUtil.getVarHandle(SWMRLong2ObjectHashTable.class, "table", TableEntry[].class);
    protected static final int DEFAULT_CAPACITY = 16;
    protected static final float DEFAULT_LOAD_FACTOR = 0.75f;
    protected static final int MAXIMUM_CAPACITY = 0x40000000;
    protected int threshold;

    protected final int getSizePlain() {
        return SIZE_HANDLE.get(this);
    }

    protected final int getSizeOpaque() {
        return SIZE_HANDLE.getOpaque(this);
    }

    protected final int getSizeAcquire() {
        return SIZE_HANDLE.getAcquire(this);
    }

    protected final void setSizePlain(int value) {
        SIZE_HANDLE.set(this, value);
    }

    protected final void setSizeOpaque(int value) {
        SIZE_HANDLE.setOpaque(this, value);
    }

    protected final void setSizeRelease(int value) {
        SIZE_HANDLE.setRelease(this, value);
    }

    protected final TableEntry<V>[] getTablePlain() {
        return TABLE_HANDLE.get(this);
    }

    protected final TableEntry<V>[] getTableAcquire() {
        return TABLE_HANDLE.getAcquire(this);
    }

    protected final void setTablePlain(TableEntry<V>[] table) {
        TABLE_HANDLE.set(this, table);
    }

    protected final void setTableRelease(TableEntry<V>[] table) {
        TABLE_HANDLE.setRelease(this, table);
    }

    public SWMRLong2ObjectHashTable() {
        this(16, 0.75f);
    }

    public SWMRLong2ObjectHashTable(int capacity) {
        this(capacity, 0.75f);
    }

    public SWMRLong2ObjectHashTable(int capacity, float loadFactor) {
        int tableSize = SWMRLong2ObjectHashTable.getCapacityFor(capacity);
        if ((double)loadFactor <= 0.0 || !Float.isFinite(loadFactor)) {
            throw new IllegalArgumentException("Invalid load factor: " + loadFactor);
        }
        TableEntry[] table = new TableEntry[tableSize];
        this.setTablePlain(table);
        this.threshold = tableSize == 0x40000000 ? -1 : SWMRLong2ObjectHashTable.getTargetCapacity(tableSize, loadFactor);
        this.loadFactor = loadFactor;
    }

    public SWMRLong2ObjectHashTable(SWMRLong2ObjectHashTable<V> other) {
        this(16, 0.75f, other);
    }

    public SWMRLong2ObjectHashTable(int capacity, SWMRLong2ObjectHashTable<V> other) {
        this(capacity, 0.75f, other);
    }

    public SWMRLong2ObjectHashTable(int capacity, float loadFactor, SWMRLong2ObjectHashTable<V> other) {
        this(Math.max(Validate.notNull(other, "Null map").size(), capacity), loadFactor);
        this.putAll(other);
    }

    protected static <V> TableEntry<V> getAtIndexOpaque(TableEntry<V>[] table, int index) {
        return TableEntry.TABLE_ENTRY_ARRAY_HANDLE.getOpaque(table, index);
    }

    protected static <V> void setAtIndexRelease(TableEntry<V>[] table, int index, TableEntry<V> value) {
        TableEntry.TABLE_ENTRY_ARRAY_HANDLE.setRelease(table, index, value);
    }

    public final float getLoadFactor() {
        return this.loadFactor;
    }

    protected static int getCapacityFor(int capacity) {
        if (capacity <= 0) {
            throw new IllegalArgumentException("Invalid capacity: " + capacity);
        }
        if (capacity >= 0x40000000) {
            return 0x40000000;
        }
        return IntegerUtil.roundCeilLog2(capacity);
    }

    protected final TableEntry<V> getEntryForOpaque(long key) {
        int hash = SWMRLong2ObjectHashTable.getHash(key);
        TableEntry<V>[] table = this.getTableAcquire();
        for (TableEntry<V> curr = SWMRLong2ObjectHashTable.getAtIndexOpaque(table, hash & table.length - 1); curr != null; curr = curr.getNextOpaque()) {
            if (key != curr.key) continue;
            return curr;
        }
        return null;
    }

    protected final TableEntry<V> getEntryForPlain(long key) {
        int hash = SWMRLong2ObjectHashTable.getHash(key);
        TableEntry<V>[] table = this.getTablePlain();
        for (TableEntry<V> curr = table[hash & table.length - 1]; curr != null; curr = curr.getNextPlain()) {
            if (key != curr.key) continue;
            return curr;
        }
        return null;
    }

    protected static int getHash(long key) {
        return (int)HashUtil.mix(key);
    }

    protected static int getTargetCapacity(int capacity, float loadFactor) {
        double ret = (double)capacity * (double)loadFactor;
        if (Double.isInfinite(ret) || ret >= 2.147483647E9) {
            return -1;
        }
        return (int)ret;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SWMRLong2ObjectHashTable)) {
            return false;
        }
        SWMRLong2ObjectHashTable other = (SWMRLong2ObjectHashTable)obj;
        if (this.size() != other.size()) {
            return false;
        }
        TableEntry<V>[] table = this.getTableAcquire();
        int len = table.length;
        for (int i = 0; i < len; ++i) {
            for (TableEntry<V> curr = SWMRLong2ObjectHashTable.getAtIndexOpaque(table, i); curr != null; curr = curr.getNextOpaque()) {
                V value = curr.getValueAcquire();
                V otherValue = other.get(curr.key);
                if (otherValue != null && (value == otherValue || !value.equals(otherValue))) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hash = 0;
        TableEntry<V>[] table = this.getTableAcquire();
        int len = table.length;
        for (int i = 0; i < len; ++i) {
            for (TableEntry<V> curr = SWMRLong2ObjectHashTable.getAtIndexOpaque(table, i); curr != null; curr = curr.getNextOpaque()) {
                hash += curr.hashCode();
            }
        }
        return hash;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(64);
        builder.append("SingleWriterMultiReaderHashMap:{");
        this.forEach((long key, ? super V value) -> builder.append("{key: \"").append(key).append("\", value: \"").append(value).append("\"}"));
        return builder.append('}').toString();
    }

    public SWMRLong2ObjectHashTable<V> clone() {
        return new SWMRLong2ObjectHashTable<V>(this.getTableAcquire().length, this.loadFactor, this);
    }

    public void forEach(Consumer<? super TableEntry<V>> action) {
        Validate.notNull(action, "Null action");
        TableEntry<V>[] table = this.getTableAcquire();
        int len = table.length;
        for (int i = 0; i < len; ++i) {
            for (TableEntry<V> curr = SWMRLong2ObjectHashTable.getAtIndexOpaque(table, i); curr != null; curr = curr.getNextOpaque()) {
                action.accept(curr);
            }
        }
    }

    public void forEach(BiLongObjectConsumer<? super V> action) {
        Validate.notNull(action, "Null action");
        TableEntry<V>[] table = this.getTableAcquire();
        int len = table.length;
        for (int i = 0; i < len; ++i) {
            for (TableEntry<V> curr = SWMRLong2ObjectHashTable.getAtIndexOpaque(table, i); curr != null; curr = curr.getNextOpaque()) {
                V value = curr.getValueAcquire();
                action.accept(curr.key, value);
            }
        }
    }

    public void forEachKey(LongConsumer action) {
        Validate.notNull(action, "Null action");
        TableEntry<V>[] table = this.getTableAcquire();
        int len = table.length;
        for (int i = 0; i < len; ++i) {
            for (TableEntry<V> curr = SWMRLong2ObjectHashTable.getAtIndexOpaque(table, i); curr != null; curr = curr.getNextOpaque()) {
                action.accept(curr.key);
            }
        }
    }

    public void forEachValue(Consumer<? super V> action) {
        Validate.notNull(action, "Null action");
        TableEntry<V>[] table = this.getTableAcquire();
        int len = table.length;
        for (int i = 0; i < len; ++i) {
            for (TableEntry<V> curr = SWMRLong2ObjectHashTable.getAtIndexOpaque(table, i); curr != null; curr = curr.getNextOpaque()) {
                V value = curr.getValueAcquire();
                action.accept(value);
            }
        }
    }

    public V get(long key) {
        TableEntry<V> entry = this.getEntryForOpaque(key);
        return entry == null ? null : (V)entry.getValueAcquire();
    }

    public boolean containsKey(long key) {
        return this.get(key) != null;
    }

    public V getOrDefault(long key, V defaultValue) {
        TableEntry<V> entry = this.getEntryForOpaque(key);
        return entry == null ? defaultValue : entry.getValueAcquire();
    }

    public int size() {
        return this.getSizeAcquire();
    }

    public boolean isEmpty() {
        return this.getSizeAcquire() == 0;
    }

    protected final void checkResize(int minCapacity) {
        int newCapacity;
        if (minCapacity <= this.threshold || this.threshold < 0) {
            return;
        }
        TableEntry<V>[] table = this.getTablePlain();
        int n = newCapacity = minCapacity >= 0x40000000 ? 0x40000000 : IntegerUtil.roundCeilLog2(minCapacity);
        if (newCapacity < 0) {
            newCapacity = 0x40000000;
        }
        if (newCapacity <= table.length) {
            if (newCapacity == 0x40000000) {
                return;
            }
            newCapacity = table.length << 1;
        }
        TableEntry[] newTable = new TableEntry[newCapacity];
        int indexMask = newCapacity - 1;
        int len = table.length;
        for (int i = 0; i < len; ++i) {
            for (TableEntry<V> entry = table[i]; entry != null; entry = entry.getNextPlain()) {
                long key = entry.key;
                int hash = SWMRLong2ObjectHashTable.getHash(key);
                int index = hash & indexMask;
                TableEntry<V> insert = new TableEntry<V>(key, entry.getValuePlain());
                TableEntry prev = newTable[index];
                newTable[index] = insert;
                insert.setNextPlain(prev);
            }
        }
        this.threshold = newCapacity == 0x40000000 ? -1 : SWMRLong2ObjectHashTable.getTargetCapacity(newCapacity, this.loadFactor);
        this.setTableRelease(newTable);
    }

    protected final int addToSize(int num) {
        int newSize = this.getSizePlain() + num;
        this.setSizeOpaque(newSize);
        this.checkResize(newSize);
        return newSize;
    }

    protected final int removeFromSize(int num) {
        int newSize = this.getSizePlain() - num;
        this.setSizeOpaque(newSize);
        return newSize;
    }

    protected final V put(long key, V value, boolean onlyIfAbsent) {
        int hash;
        int index;
        TableEntry<V>[] table = this.getTablePlain();
        TableEntry<V> head = table[index = (hash = SWMRLong2ObjectHashTable.getHash(key)) & table.length - 1];
        if (head == null) {
            TableEntry<V> insert = new TableEntry<V>(key, value);
            SWMRLong2ObjectHashTable.setAtIndexRelease(table, index, insert);
            this.addToSize(1);
            return null;
        }
        TableEntry<V> curr = head;
        while (true) {
            if (key == curr.key) {
                if (onlyIfAbsent) {
                    return curr.getValuePlain();
                }
                V currVal = curr.getValuePlain();
                curr.setValueRelease(value);
                return currVal;
            }
            TableEntry<V> next = curr.getNextPlain();
            if (next == null) break;
            curr = next;
        }
        TableEntry<V> insert = new TableEntry<V>(key, value);
        curr.setNextRelease(insert);
        this.addToSize(1);
        return null;
    }

    public V put(long key, V value) {
        Validate.notNull(value, "Null value");
        return this.put(key, value, false);
    }

    public V putIfAbsent(long key, V value) {
        Validate.notNull(value, "Null value");
        return this.put(key, value, true);
    }

    protected final V remove(long key, int hash) {
        int index;
        TableEntry<V>[] table = this.getTablePlain();
        TableEntry<V> head = table[index = table.length - 1 & hash];
        if (head == null) {
            return null;
        }
        if (head.key == key) {
            SWMRLong2ObjectHashTable.setAtIndexRelease(table, index, head.getNextPlain());
            this.removeFromSize(1);
            return head.getValuePlain();
        }
        TableEntry<V> prev = head;
        for (TableEntry<V> curr = head.getNextPlain(); curr != null; curr = curr.getNextPlain()) {
            if (key == curr.key) {
                prev.setNextRelease(curr.getNextPlain());
                this.removeFromSize(1);
                return curr.getValuePlain();
            }
            prev = curr;
        }
        return null;
    }

    protected final V remove(long key, int hash, V expect) {
        int index;
        TableEntry<V>[] table = this.getTablePlain();
        TableEntry<V> head = table[index = table.length - 1 & hash];
        if (head == null) {
            return null;
        }
        if (head.key == key) {
            Object val = head.value;
            if (val == expect || val.equals(expect)) {
                SWMRLong2ObjectHashTable.setAtIndexRelease(table, index, head.getNextPlain());
                this.removeFromSize(1);
                return head.getValuePlain();
            }
            return null;
        }
        TableEntry<V> prev = head;
        for (TableEntry<V> curr = head.getNextPlain(); curr != null; curr = curr.getNextPlain()) {
            if (key == curr.key) {
                Object val = curr.value;
                if (val == expect || val.equals(expect)) {
                    prev.setNextRelease(curr.getNextPlain());
                    this.removeFromSize(1);
                    return curr.getValuePlain();
                }
                return null;
            }
            prev = curr;
        }
        return null;
    }

    public V remove(long key) {
        return this.remove(key, SWMRLong2ObjectHashTable.getHash(key));
    }

    public boolean remove(long key, V expect) {
        return this.remove(key, SWMRLong2ObjectHashTable.getHash(key), expect) != null;
    }

    public void putAll(SWMRLong2ObjectHashTable<? extends V> map) {
        Validate.notNull(map, "Null map");
        int size = map.size();
        this.checkResize(Math.max(this.getSizePlain() + size / 2, size));
        map.forEach(this::put);
    }

    public void clear() {
        Arrays.fill(this.getTablePlain(), null);
        this.setSizeRelease(0);
    }

    public static final class TableEntry<V> {
        protected static final VarHandle TABLE_ENTRY_ARRAY_HANDLE = ConcurrentUtil.getArrayHandle(TableEntry[].class);
        protected final long key;
        protected V value;
        protected TableEntry<V> next;
        protected static final VarHandle VALUE_HANDLE = ConcurrentUtil.getVarHandle(TableEntry.class, "value", Object.class);
        protected static final VarHandle NEXT_HANDLE = ConcurrentUtil.getVarHandle(TableEntry.class, "next", TableEntry.class);

        protected final V getValuePlain() {
            return (V)VALUE_HANDLE.get(this);
        }

        protected final V getValueAcquire() {
            return (V)VALUE_HANDLE.getAcquire(this);
        }

        protected final void setValueRelease(V to) {
            VALUE_HANDLE.setRelease(this, to);
        }

        protected final TableEntry<V> getNextPlain() {
            return NEXT_HANDLE.get(this);
        }

        protected final TableEntry<V> getNextOpaque() {
            return NEXT_HANDLE.getOpaque(this);
        }

        protected final void setNextPlain(TableEntry<V> next) {
            NEXT_HANDLE.set(this, next);
        }

        protected final void setNextRelease(TableEntry<V> next) {
            NEXT_HANDLE.setRelease(this, next);
        }

        protected TableEntry(long key, V value) {
            this.key = key;
            this.value = value;
        }

        public long getKey() {
            return this.key;
        }

        public V getValue() {
            return this.getValueAcquire();
        }
    }
}

