/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.libs.ca.spottedleaf.concurrentutil.map;

import ca.spottedleaf.moonrise.libs.ca.spottedleaf.concurrentutil.util.CollectionUtil;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.concurrentutil.util.ConcurrentUtil;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.concurrentutil.util.HashUtil;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.concurrentutil.util.IntegerUtil;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.concurrentutil.util.Validate;
import java.lang.invoke.VarHandle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;

public class SWMRHashTable<K, V>
implements Map<K, V>,
Iterable<Map.Entry<K, V>> {
    protected int size;
    protected TableEntry<K, V>[] table;
    protected final float loadFactor;
    protected static final VarHandle SIZE_HANDLE = ConcurrentUtil.getVarHandle(SWMRHashTable.class, "size", Integer.TYPE);
    protected static final VarHandle TABLE_HANDLE = ConcurrentUtil.getVarHandle(SWMRHashTable.class, "table", TableEntry[].class);
    protected static final int DEFAULT_CAPACITY = 16;
    protected static final float DEFAULT_LOAD_FACTOR = 0.75f;
    protected static final int MAXIMUM_CAPACITY = 0x40000000;
    protected KeySet<K, V> keyset;
    protected ValueCollection<K, V> values;
    protected EntrySet<K, V> entrySet;
    protected int threshold;

    protected final int getSizePlain() {
        return SIZE_HANDLE.get(this);
    }

    protected final int getSizeOpaque() {
        return SIZE_HANDLE.getOpaque(this);
    }

    protected final int getSizeAcquire() {
        return SIZE_HANDLE.getAcquire(this);
    }

    protected final void setSizePlain(int value) {
        SIZE_HANDLE.set(this, value);
    }

    protected final void setSizeOpaque(int value) {
        SIZE_HANDLE.setOpaque(this, value);
    }

    protected final void setSizeRelease(int value) {
        SIZE_HANDLE.setRelease(this, value);
    }

    protected final TableEntry<K, V>[] getTablePlain() {
        return TABLE_HANDLE.get(this);
    }

    protected final TableEntry<K, V>[] getTableAcquire() {
        return TABLE_HANDLE.getAcquire(this);
    }

    protected final void setTablePlain(TableEntry<K, V>[] table) {
        TABLE_HANDLE.set(this, table);
    }

    protected final void setTableRelease(TableEntry<K, V>[] table) {
        TABLE_HANDLE.setRelease(this, table);
    }

    public SWMRHashTable() {
        this(16, 0.75f);
    }

    public SWMRHashTable(int capacity) {
        this(capacity, 0.75f);
    }

    public SWMRHashTable(int capacity, float loadFactor) {
        int tableSize = SWMRHashTable.getCapacityFor(capacity);
        if ((double)loadFactor <= 0.0 || !Float.isFinite(loadFactor)) {
            throw new IllegalArgumentException("Invalid load factor: " + loadFactor);
        }
        TableEntry[] table = new TableEntry[tableSize];
        this.setTablePlain(table);
        this.threshold = tableSize == 0x40000000 ? -1 : SWMRHashTable.getTargetCapacity(tableSize, loadFactor);
        this.loadFactor = loadFactor;
    }

    public SWMRHashTable(Map<K, V> other) {
        this(16, 0.75f, other);
    }

    public SWMRHashTable(int capacity, Map<K, V> other) {
        this(capacity, 0.75f, other);
    }

    public SWMRHashTable(int capacity, float loadFactor, Map<K, V> other) {
        this(Math.max(Validate.notNull(other, "Null map").size(), capacity), loadFactor);
        this.putAll(other);
    }

    protected static <K, V> TableEntry<K, V> getAtIndexOpaque(TableEntry<K, V>[] table, int index) {
        return TableEntry.TABLE_ENTRY_ARRAY_HANDLE.getOpaque(table, index);
    }

    protected static <K, V> void setAtIndexRelease(TableEntry<K, V>[] table, int index, TableEntry<K, V> value) {
        TableEntry.TABLE_ENTRY_ARRAY_HANDLE.setRelease(table, index, value);
    }

    public final float getLoadFactor() {
        return this.loadFactor;
    }

    protected static int getCapacityFor(int capacity) {
        if (capacity <= 0) {
            throw new IllegalArgumentException("Invalid capacity: " + capacity);
        }
        if (capacity >= 0x40000000) {
            return 0x40000000;
        }
        return IntegerUtil.roundCeilLog2(capacity);
    }

    protected final TableEntry<K, V> getEntryForOpaque(K key) {
        int hash = SWMRHashTable.getHash(key);
        TableEntry<K, V>[] table = this.getTableAcquire();
        for (TableEntry<K, V> curr = SWMRHashTable.getAtIndexOpaque(table, hash & table.length - 1); curr != null; curr = curr.getNextOpaque()) {
            if (hash != curr.hash || key != curr.key && !curr.key.equals(key)) continue;
            return curr;
        }
        return null;
    }

    protected final TableEntry<K, V> getEntryForPlain(K key) {
        int hash = SWMRHashTable.getHash(key);
        TableEntry<K, V>[] table = this.getTablePlain();
        for (TableEntry<K, V> curr = table[hash & table.length - 1]; curr != null; curr = curr.getNextPlain()) {
            if (hash != curr.hash || key != curr.key && !curr.key.equals(key)) continue;
            return curr;
        }
        return null;
    }

    private static int getHash(Object key) {
        int hash = key == null ? 0 : key.hashCode();
        return HashUtil.mix(hash);
    }

    protected static int getTargetCapacity(int capacity, float loadFactor) {
        double ret = (double)capacity * (double)loadFactor;
        if (Double.isInfinite(ret) || ret >= 2.147483647E9) {
            return -1;
        }
        return (int)ret;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Map)) {
            return false;
        }
        Map other = (Map)obj;
        if (this.size() != other.size()) {
            return false;
        }
        TableEntry<K, V>[] table = this.getTableAcquire();
        int len = table.length;
        for (int i = 0; i < len; ++i) {
            for (TableEntry<K, V> curr = SWMRHashTable.getAtIndexOpaque(table, i); curr != null; curr = curr.getNextOpaque()) {
                V value = curr.getValueAcquire();
                Object otherValue = other.get(curr.key);
                if (otherValue != null && (value == otherValue || !value.equals(otherValue))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        TableEntry<K, V>[] table = this.getTableAcquire();
        int len = table.length;
        for (int i = 0; i < len; ++i) {
            for (TableEntry<K, V> curr = SWMRHashTable.getAtIndexOpaque(table, i); curr != null; curr = curr.getNextOpaque()) {
                hash += curr.hashCode();
            }
        }
        return hash;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(64);
        builder.append("SWMRHashTable:{");
        this.forEach((? super K key, ? super V value) -> builder.append("{key: \"").append(key).append("\", value: \"").append(value).append("\"}"));
        return builder.append('}').toString();
    }

    public SWMRHashTable<K, V> clone() {
        return new SWMRHashTable<K, V>(this.getTableAcquire().length, this.loadFactor, this);
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return new EntryIterator<K, V>(this.getTableAcquire(), this);
    }

    @Override
    public void forEach(Consumer<? super Map.Entry<K, V>> action) {
        Validate.notNull(action, "Null action");
        TableEntry<K, V>[] table = this.getTableAcquire();
        int len = table.length;
        for (int i = 0; i < len; ++i) {
            for (TableEntry<K, V> curr = SWMRHashTable.getAtIndexOpaque(table, i); curr != null; curr = curr.getNextOpaque()) {
                action.accept(curr);
            }
        }
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        Validate.notNull(action, "Null action");
        TableEntry<K, V>[] table = this.getTableAcquire();
        int len = table.length;
        for (int i = 0; i < len; ++i) {
            for (TableEntry<K, V> curr = SWMRHashTable.getAtIndexOpaque(table, i); curr != null; curr = curr.getNextOpaque()) {
                V value = curr.getValueAcquire();
                action.accept(curr.key, value);
            }
        }
    }

    public void forEachKey(Consumer<? super K> action) {
        Validate.notNull(action, "Null action");
        TableEntry<K, V>[] table = this.getTableAcquire();
        int len = table.length;
        for (int i = 0; i < len; ++i) {
            for (TableEntry<K, V> curr = SWMRHashTable.getAtIndexOpaque(table, i); curr != null; curr = curr.getNextOpaque()) {
                action.accept(curr.key);
            }
        }
    }

    public void forEachValue(Consumer<? super V> action) {
        Validate.notNull(action, "Null action");
        TableEntry<K, V>[] table = this.getTableAcquire();
        int len = table.length;
        for (int i = 0; i < len; ++i) {
            for (TableEntry<K, V> curr = SWMRHashTable.getAtIndexOpaque(table, i); curr != null; curr = curr.getNextOpaque()) {
                V value = curr.getValueAcquire();
                action.accept(value);
            }
        }
    }

    @Override
    public V get(Object key) {
        Validate.notNull(key, "Null key");
        TableEntry<Object, V> entry = this.getEntryForOpaque(key);
        return entry == null ? null : (V)entry.getValueAcquire();
    }

    @Override
    public boolean containsKey(Object key) {
        Validate.notNull(key, "Null key");
        return this.get(key) != null;
    }

    public boolean contains(Object key, Object value) {
        Validate.notNull(key, "Null key");
        TableEntry<Object, V> entry = this.getEntryForOpaque(key);
        if (entry == null) {
            return false;
        }
        V entryVal = entry.getValueAcquire();
        return entryVal == value || entryVal.equals(value);
    }

    @Override
    public boolean containsValue(Object value) {
        Validate.notNull(value, "Null value");
        TableEntry<K, V>[] table = this.getTableAcquire();
        int len = table.length;
        for (int i = 0; i < len; ++i) {
            for (TableEntry<K, V> curr = SWMRHashTable.getAtIndexOpaque(table, i); curr != null; curr = curr.getNextOpaque()) {
                V currVal = curr.getValueAcquire();
                if (currVal != value && !currVal.equals(value)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        Validate.notNull(key, "Null key");
        TableEntry<Object, V> entry = this.getEntryForOpaque(key);
        return entry == null ? defaultValue : entry.getValueAcquire();
    }

    @Override
    public int size() {
        return this.getSizeAcquire();
    }

    @Override
    public boolean isEmpty() {
        return this.getSizeAcquire() == 0;
    }

    @Override
    public Set<K> keySet() {
        return this.keyset == null ? (this.keyset = new KeySet(this)) : this.keyset;
    }

    @Override
    public Collection<V> values() {
        return this.values == null ? (this.values = new ValueCollection(this)) : this.values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.entrySet == null ? (this.entrySet = new EntrySet(this)) : this.entrySet;
    }

    protected final void checkResize(int minCapacity) {
        int newCapacity;
        if (minCapacity <= this.threshold || this.threshold < 0) {
            return;
        }
        TableEntry<K, V>[] table = this.getTablePlain();
        int n = newCapacity = minCapacity >= 0x40000000 ? 0x40000000 : IntegerUtil.roundCeilLog2(minCapacity);
        if (newCapacity < 0) {
            newCapacity = 0x40000000;
        }
        if (newCapacity <= table.length) {
            if (newCapacity == 0x40000000) {
                return;
            }
            newCapacity = table.length << 1;
        }
        TableEntry[] newTable = new TableEntry[newCapacity];
        int indexMask = newCapacity - 1;
        int len = table.length;
        for (int i = 0; i < len; ++i) {
            for (TableEntry<K, V> entry = table[i]; entry != null; entry = entry.getNextPlain()) {
                int hash = entry.hash;
                int index = hash & indexMask;
                TableEntry insert = new TableEntry(hash, entry.key, entry.getValuePlain());
                TableEntry prev = newTable[index];
                newTable[index] = insert;
                insert.setNextPlain(prev);
            }
        }
        this.threshold = newCapacity == 0x40000000 ? -1 : SWMRHashTable.getTargetCapacity(newCapacity, this.loadFactor);
        this.setTableRelease(newTable);
    }

    protected final int addToSize(int num) {
        int newSize = this.getSizePlain() + num;
        this.setSizeOpaque(newSize);
        this.checkResize(newSize);
        return newSize;
    }

    protected final int removeFromSize(int num) {
        int newSize = this.getSizePlain() - num;
        this.setSizeOpaque(newSize);
        return newSize;
    }

    protected final int removeFromSizePlain(int num) {
        int newSize = this.getSizePlain() - num;
        this.setSizePlain(newSize);
        return newSize;
    }

    protected final V put(K key, V value, boolean onlyIfAbsent) {
        int hash;
        int index;
        TableEntry<K, V>[] table = this.getTablePlain();
        TableEntry<K, V> head = table[index = (hash = SWMRHashTable.getHash(key)) & table.length - 1];
        if (head == null) {
            TableEntry<K, V> insert = new TableEntry<K, V>(hash, key, value);
            SWMRHashTable.setAtIndexRelease(table, index, insert);
            this.addToSize(1);
            return null;
        }
        TableEntry<K, V> curr = head;
        while (true) {
            if (curr.hash == hash && (key == curr.key || curr.key.equals(key))) {
                if (onlyIfAbsent) {
                    return curr.getValuePlain();
                }
                V currVal = curr.getValuePlain();
                curr.setValueRelease(value);
                return currVal;
            }
            TableEntry<K, V> next = curr.getNextPlain();
            if (next == null) break;
            curr = next;
        }
        TableEntry<K, V> insert = new TableEntry<K, V>(hash, key, value);
        curr.setNextRelease(insert);
        this.addToSize(1);
        return null;
    }

    public int removeIf(BiPredicate<K, V> predicate) {
        Validate.notNull(predicate, "Null predicate");
        int removed = 0;
        TableEntry<K, V>[] table = this.getTablePlain();
        int len = table.length;
        block0: for (int i = 0; i < len; ++i) {
            TableEntry<K, V> curr = table[i];
            if (curr == null) continue;
            while (predicate.test(curr.key, curr.getValuePlain())) {
                ++removed;
                this.removeFromSizePlain(1);
                curr = curr.getNextPlain();
                SWMRHashTable.setAtIndexRelease(table, i, curr);
                if (curr != null) continue;
                continue block0;
            }
            TableEntry<K, V> prev = curr;
            curr = curr.getNextPlain();
            while (curr != null) {
                if (predicate.test(curr.key, curr.getValuePlain())) {
                    ++removed;
                    this.removeFromSizePlain(1);
                    curr = curr.getNextPlain();
                    prev.setNextRelease(curr);
                    continue;
                }
                prev = curr;
                curr = curr.getNextPlain();
            }
        }
        return removed;
    }

    public int removeEntryIf(Predicate<? super Map.Entry<K, V>> predicate) {
        Validate.notNull(predicate, "Null predicate");
        int removed = 0;
        TableEntry<K, V>[] table = this.getTablePlain();
        int len = table.length;
        block0: for (int i = 0; i < len; ++i) {
            TableEntry<K, V> curr = table[i];
            if (curr == null) continue;
            while (predicate.test(curr)) {
                ++removed;
                this.removeFromSizePlain(1);
                curr = curr.getNextPlain();
                SWMRHashTable.setAtIndexRelease(table, i, curr);
                if (curr != null) continue;
                continue block0;
            }
            TableEntry<K, V> prev = curr;
            curr = curr.getNextPlain();
            while (curr != null) {
                if (predicate.test(curr)) {
                    ++removed;
                    this.removeFromSizePlain(1);
                    curr = curr.getNextPlain();
                    prev.setNextRelease(curr);
                    continue;
                }
                prev = curr;
                curr = curr.getNextPlain();
            }
        }
        return removed;
    }

    @Override
    public V put(K key, V value) {
        Validate.notNull(key, "Null key");
        Validate.notNull(value, "Null value");
        return this.put(key, value, false);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        Validate.notNull(key, "Null key");
        Validate.notNull(value, "Null value");
        return this.put(key, value, true);
    }

    @Override
    public boolean remove(Object key, Object value) {
        Validate.notNull(key, "Null key");
        Validate.notNull(value, "Null value");
        TableEntry<K, V>[] table = this.getTablePlain();
        int hash = SWMRHashTable.getHash(key);
        int index = hash & table.length - 1;
        TableEntry<K, V> head = table[index];
        if (head == null) {
            return false;
        }
        if (head.hash == hash && (head.key == key || head.key.equals(key))) {
            V currVal = head.getValuePlain();
            if (currVal != value && !currVal.equals(value)) {
                return false;
            }
            SWMRHashTable.setAtIndexRelease(table, index, head.getNextPlain());
            this.removeFromSize(1);
            return true;
        }
        TableEntry<K, V> prev = head;
        for (TableEntry<K, V> curr = head.getNextPlain(); curr != null; curr = curr.getNextPlain()) {
            if (curr.hash == hash && (curr.key == key || curr.key.equals(key))) {
                V currVal = curr.getValuePlain();
                if (currVal != value && !currVal.equals(value)) {
                    return false;
                }
                prev.setNextRelease(curr.getNextPlain());
                this.removeFromSize(1);
                return true;
            }
            prev = curr;
        }
        return false;
    }

    protected final V remove(Object key, int hash) {
        int index;
        TableEntry<K, V>[] table = this.getTablePlain();
        TableEntry<K, V> head = table[index = table.length - 1 & hash];
        if (head == null) {
            return null;
        }
        if (hash == head.hash && (head.key == key || head.key.equals(key))) {
            SWMRHashTable.setAtIndexRelease(table, index, head.getNextPlain());
            this.removeFromSize(1);
            return head.getValuePlain();
        }
        TableEntry<K, V> prev = head;
        for (TableEntry<K, V> curr = head.getNextPlain(); curr != null; curr = curr.getNextPlain()) {
            if (curr.hash == hash && (key == curr.key || curr.key.equals(key))) {
                prev.setNextRelease(curr.getNextPlain());
                this.removeFromSize(1);
                return curr.getValuePlain();
            }
            prev = curr;
        }
        return null;
    }

    @Override
    public V remove(Object key) {
        Validate.notNull(key, "Null key");
        return this.remove(key, SWMRHashTable.getHash(key));
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        Validate.notNull(key, "Null key");
        Validate.notNull(oldValue, "Null oldValue");
        Validate.notNull(newValue, "Null newValue");
        TableEntry<K, V> entry = this.getEntryForPlain(key);
        if (entry == null) {
            return false;
        }
        V currValue = entry.getValuePlain();
        if (currValue == oldValue || currValue.equals(oldValue)) {
            entry.setValueRelease(newValue);
            return true;
        }
        return false;
    }

    @Override
    public V replace(K key, V value) {
        Validate.notNull(key, "Null key");
        Validate.notNull(value, "Null value");
        TableEntry<K, V> entry = this.getEntryForPlain(key);
        if (entry == null) {
            return null;
        }
        V prev = entry.getValuePlain();
        entry.setValueRelease(value);
        return prev;
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        Validate.notNull(function, "Null function");
        TableEntry<K, V>[] table = this.getTablePlain();
        int len = table.length;
        for (int i = 0; i < len; ++i) {
            for (TableEntry<K, V> curr = table[i]; curr != null; curr = curr.getNextPlain()) {
                V value = curr.getValuePlain();
                V newValue = function.apply(curr.key, value);
                if (newValue == null) {
                    throw new NullPointerException();
                }
                curr.setValueRelease(newValue);
            }
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        Validate.notNull(map, "Null map");
        int size = map.size();
        this.checkResize(Math.max(this.getSizePlain() + size / 2, size));
        map.forEach(this::put);
    }

    @Override
    public void clear() {
        Arrays.fill(this.getTablePlain(), null);
        this.setSizeRelease(0);
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        Validate.notNull(key, "Null key");
        Validate.notNull(remappingFunction, "Null remappingFunction");
        int hash = SWMRHashTable.getHash(key);
        TableEntry<K, V>[] table = this.getTablePlain();
        int index = hash & table.length - 1;
        TableEntry<K, V> curr = table[index];
        TableEntry<K, V> prev = null;
        while (true) {
            if (curr == null) {
                V newVal = remappingFunction.apply(key, null);
                if (newVal == null) {
                    return null;
                }
                TableEntry<K, V> insert = new TableEntry<K, V>(hash, key, newVal);
                if (prev == null) {
                    SWMRHashTable.setAtIndexRelease(table, index, insert);
                } else {
                    prev.setNextRelease(insert);
                }
                this.addToSize(1);
                return newVal;
            }
            if (curr.hash == hash && (curr.key == key || curr.key.equals(key))) {
                V newVal = remappingFunction.apply(key, curr.getValuePlain());
                if (newVal != null) {
                    curr.setValueRelease(newVal);
                    return newVal;
                }
                if (prev == null) {
                    SWMRHashTable.setAtIndexRelease(table, index, curr.getNextPlain());
                } else {
                    prev.setNextRelease(curr.getNextPlain());
                }
                this.removeFromSize(1);
                return null;
            }
            prev = curr;
            curr = curr.getNextPlain();
        }
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        Validate.notNull(key, "Null key");
        Validate.notNull(remappingFunction, "Null remappingFunction");
        int hash = SWMRHashTable.getHash(key);
        TableEntry<K, V>[] table = this.getTablePlain();
        int index = hash & table.length - 1;
        TableEntry<K, V> prev = null;
        for (TableEntry<K, V> curr = table[index]; curr != null; curr = curr.getNextPlain()) {
            if (curr.hash == hash && (curr.key == key || curr.key.equals(key))) {
                V newVal = remappingFunction.apply(key, curr.getValuePlain());
                if (newVal != null) {
                    curr.setValueRelease(newVal);
                    return newVal;
                }
                if (prev == null) {
                    SWMRHashTable.setAtIndexRelease(table, index, curr.getNextPlain());
                } else {
                    prev.setNextRelease(curr.getNextPlain());
                }
                this.removeFromSize(1);
                return null;
            }
            prev = curr;
        }
        return null;
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        Validate.notNull(key, "Null key");
        Validate.notNull(mappingFunction, "Null mappingFunction");
        int hash = SWMRHashTable.getHash(key);
        TableEntry<K, V>[] table = this.getTablePlain();
        int index = hash & table.length - 1;
        TableEntry<K, V> curr = table[index];
        TableEntry<K, V> prev = null;
        while (true) {
            if (curr != null) {
                if (curr.hash == hash && (curr.key == key || curr.key.equals(key))) {
                    return curr.getValuePlain();
                }
            } else {
                V newVal = mappingFunction.apply(key);
                if (newVal == null) {
                    return null;
                }
                TableEntry<K, V> insert = new TableEntry<K, V>(hash, key, newVal);
                if (prev == null) {
                    SWMRHashTable.setAtIndexRelease(table, index, insert);
                } else {
                    prev.setNextRelease(insert);
                }
                this.addToSize(1);
                return newVal;
            }
            prev = curr;
            curr = curr.getNextPlain();
        }
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        Validate.notNull(key, "Null key");
        Validate.notNull(value, "Null value");
        Validate.notNull(remappingFunction, "Null remappingFunction");
        int hash = SWMRHashTable.getHash(key);
        TableEntry<K, V>[] table = this.getTablePlain();
        int index = hash & table.length - 1;
        TableEntry<K, V> curr = table[index];
        TableEntry<K, V> prev = null;
        while (true) {
            if (curr == null) {
                TableEntry<K, V> insert = new TableEntry<K, V>(hash, key, value);
                if (prev == null) {
                    SWMRHashTable.setAtIndexRelease(table, index, insert);
                } else {
                    prev.setNextRelease(insert);
                }
                this.addToSize(1);
                return value;
            }
            if (curr.hash == hash && (curr.key == key || curr.key.equals(key))) {
                V newVal = remappingFunction.apply(curr.getValuePlain(), value);
                if (newVal != null) {
                    curr.setValueRelease(newVal);
                    return newVal;
                }
                if (prev == null) {
                    SWMRHashTable.setAtIndexRelease(table, index, curr.getNextPlain());
                } else {
                    prev.setNextRelease(curr.getNextPlain());
                }
                this.removeFromSize(1);
                return null;
            }
            prev = curr;
            curr = curr.getNextPlain();
        }
    }

    protected static final class TableEntry<K, V>
    implements Map.Entry<K, V> {
        protected static final VarHandle TABLE_ENTRY_ARRAY_HANDLE = ConcurrentUtil.getArrayHandle(TableEntry[].class);
        protected final int hash;
        protected final K key;
        protected V value;
        protected TableEntry<K, V> next;
        protected static final VarHandle VALUE_HANDLE = ConcurrentUtil.getVarHandle(TableEntry.class, "value", Object.class);
        protected static final VarHandle NEXT_HANDLE = ConcurrentUtil.getVarHandle(TableEntry.class, "next", TableEntry.class);

        protected final V getValuePlain() {
            return (V)VALUE_HANDLE.get(this);
        }

        protected final V getValueAcquire() {
            return (V)VALUE_HANDLE.getAcquire(this);
        }

        protected final void setValueRelease(V to) {
            VALUE_HANDLE.setRelease(this, to);
        }

        protected final TableEntry<K, V> getNextPlain() {
            return NEXT_HANDLE.get(this);
        }

        protected final TableEntry<K, V> getNextOpaque() {
            return NEXT_HANDLE.getOpaque(this);
        }

        protected final void setNextPlain(TableEntry<K, V> next) {
            NEXT_HANDLE.set(this, next);
        }

        protected final void setNextRelease(TableEntry<K, V> next) {
            NEXT_HANDLE.setRelease(this, next);
        }

        protected TableEntry(int hash, K key, V value) {
            this.hash = hash;
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.getValueAcquire();
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }

        protected static int hash(Object key, Object value) {
            return key.hashCode() ^ (value == null ? 0 : value.hashCode());
        }

        @Override
        public int hashCode() {
            return TableEntry.hash(this.key, this.getValueAcquire());
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry other = (Map.Entry)obj;
            Object otherKey = other.getKey();
            Object otherValue = other.getValue();
            K thisKey = this.getKey();
            V thisVal = this.getValueAcquire();
            return !(thisKey != otherKey && !thisKey.equals(otherKey) || thisVal != otherValue && !thisVal.equals(otherValue));
        }
    }

    protected static final class EntryIterator<K, V>
    extends TableEntryIterator<K, V, Map.Entry<K, V>> {
        protected EntryIterator(TableEntry<K, V>[] table, SWMRHashTable<K, V> map) {
            super(table, map);
        }

        @Override
        public Map.Entry<K, V> next() {
            TableEntry curr = this.advanceEntry();
            if (curr == null) {
                throw new NoSuchElementException();
            }
            return curr;
        }
    }

    protected static final class KeySet<K, V>
    extends ViewSet<K, V, K> {
        protected KeySet(SWMRHashTable<K, V> map) {
            super(map);
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator(this.map.getTableAcquire(), this.map);
        }

        @Override
        public void forEach(Consumer<? super K> action) {
            Validate.notNull(action, "Null action");
            this.map.forEachKey(action);
        }

        @Override
        public boolean contains(Object key) {
            Validate.notNull(key, "Null key");
            return this.map.containsKey(key);
        }

        @Override
        public boolean remove(Object key) {
            Validate.notNull(key, "Null key");
            return this.map.remove(key) != null;
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            Validate.notNull(collection, "Null collection");
            return this.map.removeIf((K key, V value) -> !collection.contains(key)) != 0;
        }

        @Override
        public boolean removeIf(Predicate<? super K> filter) {
            Validate.notNull(filter, "Null filter");
            return this.map.removeIf((K key, V value) -> filter.test((Object)key)) != 0;
        }

        public String toString() {
            return CollectionUtil.toString(this, "SWMRHashTableKeySet");
        }
    }

    protected static final class ValueCollection<K, V>
    extends ViewSet<K, V, V>
    implements Collection<V> {
        protected ValueCollection(SWMRHashTable<K, V> map) {
            super(map);
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator(this.map.getTableAcquire(), this.map);
        }

        @Override
        public void forEach(Consumer<? super V> action) {
            Validate.notNull(action, "Null action");
            this.map.forEachValue(action);
        }

        @Override
        public boolean contains(Object object) {
            Validate.notNull(object, "Null object");
            return this.map.containsValue(object);
        }

        @Override
        public boolean remove(Object object) {
            Validate.notNull(object, "Null object");
            Iterator<V> itr = this.iterator();
            while (itr.hasNext()) {
                V val = itr.next();
                if (val != object && !val.equals(object)) continue;
                itr.remove();
                return true;
            }
            return false;
        }

        @Override
        public boolean removeIf(Predicate<? super V> filter) {
            Validate.notNull(filter, "Null filter");
            return this.map.removeIf((K key, V value) -> filter.test((Object)value)) != 0;
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            Validate.notNull(collection, "Null collection");
            return this.map.removeIf((K key, V value) -> !collection.contains(value)) != 0;
        }

        public String toString() {
            return CollectionUtil.toString(this, "SWMRHashTableValues");
        }
    }

    protected static final class EntrySet<K, V>
    extends ViewSet<K, V, Map.Entry<K, V>>
    implements Set<Map.Entry<K, V>> {
        protected EntrySet(SWMRHashTable<K, V> map) {
            super(map);
        }

        @Override
        public boolean remove(Object object) {
            Object value;
            Object key;
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            try {
                key = entry.getKey();
                value = entry.getValue();
            }
            catch (IllegalStateException ex) {
                return false;
            }
            return this.map.remove(key, value);
        }

        @Override
        public boolean removeIf(Predicate<? super Map.Entry<K, V>> filter) {
            Validate.notNull(filter, "Null filter");
            return this.map.removeEntryIf(filter) != 0;
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            Validate.notNull(collection, "Null collection");
            return this.map.removeEntryIf(entry -> !collection.contains(entry)) != 0;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator(this.map.getTableAcquire(), this.map);
        }

        @Override
        public void forEach(Consumer<? super Map.Entry<K, V>> action) {
            this.map.forEach(action);
        }

        @Override
        public boolean contains(Object object) {
            Object value;
            Object key;
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            try {
                key = entry.getKey();
                value = entry.getValue();
            }
            catch (IllegalStateException ex) {
                return false;
            }
            return this.map.contains(key, value);
        }

        public String toString() {
            return CollectionUtil.toString(this, "SWMRHashTableEntrySet");
        }
    }

    protected static abstract class ViewSet<K, V, T>
    extends ViewCollection<K, V, T>
    implements Set<T> {
        protected ViewSet(SWMRHashTable<K, V> map) {
            super(map);
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Set)) {
                return false;
            }
            Set other = (Set)obj;
            if (other.size() != this.size()) {
                return false;
            }
            return this.containsAll(other);
        }
    }

    protected static abstract class ViewCollection<K, V, T>
    implements Collection<T> {
        protected final SWMRHashTable<K, V> map;

        protected ViewCollection(SWMRHashTable<K, V> map) {
            this.map = map;
        }

        @Override
        public boolean add(T element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends T> collections) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            Validate.notNull(collection, "Null collection");
            boolean modified = false;
            for (Object element : collection) {
                modified |= this.remove(element);
            }
            return modified;
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            Validate.notNull(collection, "Null collection");
            for (Object element : collection) {
                if (this.contains(element)) continue;
                return false;
            }
            return true;
        }

        @Override
        public Object[] toArray() {
            ArrayList list = new ArrayList(this.size());
            this.forEach(list::add);
            return list.toArray();
        }

        @Override
        public <E> E[] toArray(E[] array) {
            ArrayList list = new ArrayList(this.size());
            this.forEach(list::add);
            return list.toArray(array);
        }

        @Override
        public <E> E[] toArray(IntFunction<E[]> generator) {
            ArrayList list = new ArrayList(this.size());
            this.forEach(list::add);
            return list.toArray(generator);
        }

        @Override
        public int hashCode() {
            int hash = 0;
            for (Object element : this) {
                hash += element == null ? 0 : element.hashCode();
            }
            return hash;
        }

        @Override
        public Spliterator<T> spliterator() {
            return Spliterators.spliterator(this, 256);
        }
    }

    protected static final class KeyIterator<K, V>
    extends TableEntryIterator<K, V, K> {
        protected KeyIterator(TableEntry<K, V>[] table, SWMRHashTable<K, V> map) {
            super(table, map);
        }

        @Override
        public K next() {
            TableEntry curr = this.advanceEntry();
            if (curr == null) {
                throw new NoSuchElementException();
            }
            return curr.key;
        }
    }

    protected static final class ValueIterator<K, V>
    extends TableEntryIterator<K, V, V> {
        protected ValueIterator(TableEntry<K, V>[] table, SWMRHashTable<K, V> map) {
            super(table, map);
        }

        @Override
        public V next() {
            TableEntry entry = this.advanceEntry();
            if (entry == null) {
                throw new NoSuchElementException();
            }
            return entry.getValueAcquire();
        }
    }

    protected static abstract class TableEntryIterator<K, V, T>
    implements Iterator<T> {
        protected final TableEntry<K, V>[] table;
        protected final SWMRHashTable<K, V> map;
        protected int tableIndex;
        protected TableEntry<K, V> currEntry;
        protected TableEntry<K, V> nextEntry;

        protected TableEntryIterator(TableEntry<K, V>[] table, SWMRHashTable<K, V> map) {
            int tableIndex;
            this.table = table;
            this.map = map;
            int len = table.length;
            for (tableIndex = 0; tableIndex < len; ++tableIndex) {
                TableEntry<K, V> entry = SWMRHashTable.getAtIndexOpaque(table, tableIndex);
                if (entry == null) continue;
                this.nextEntry = entry;
                this.tableIndex = tableIndex + 1;
                return;
            }
            this.tableIndex = tableIndex;
        }

        @Override
        public boolean hasNext() {
            return this.nextEntry != null;
        }

        protected final TableEntry<K, V> advanceEntry() {
            int tableIndex;
            TableEntry<K, V>[] table = this.table;
            int tableLength = table.length;
            TableEntry<K, V> curr = this.nextEntry;
            if (curr == null) {
                return null;
            }
            this.currEntry = curr;
            TableEntry<K, V> next = curr.getNextOpaque();
            if (next != null) {
                this.nextEntry = next;
                return curr;
            }
            for (tableIndex = this.tableIndex; tableIndex < tableLength; ++tableIndex) {
                next = SWMRHashTable.getAtIndexOpaque(table, tableIndex);
                if (next == null) continue;
                this.nextEntry = next;
                this.tableIndex = tableIndex + 1;
                return curr;
            }
            this.nextEntry = null;
            this.tableIndex = tableIndex;
            return curr;
        }

        @Override
        public void remove() {
            TableEntry<K, V> curr = this.currEntry;
            if (curr == null) {
                throw new IllegalStateException();
            }
            this.map.remove(curr.key, curr.hash);
            this.currEntry = null;
        }
    }
}

