/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.libs.ca.spottedleaf.concurrentutil.executor.thread;

import ca.spottedleaf.moonrise.libs.ca.spottedleaf.concurrentutil.executor.PrioritisedExecutor;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.concurrentutil.executor.queue.PrioritisedTaskQueue;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.concurrentutil.executor.thread.PrioritisedQueueExecutorThread;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.concurrentutil.util.Priority;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.concurrentutil.util.TimeUtil;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PrioritisedThreadPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(PrioritisedThreadPool.class);
    private final Consumer<Thread> threadModifier;
    private final COWArrayList<ExecutorGroup> executors = new COWArrayList<ExecutorGroup>(ExecutorGroup.class);
    private final COWArrayList<PrioritisedThread> threads = new COWArrayList<PrioritisedThread>(PrioritisedThread.class);
    private final COWArrayList<PrioritisedThread> aliveThreads = new COWArrayList<PrioritisedThread>(PrioritisedThread.class);
    private static final Priority HIGH_PRIORITY_NOTIFY_THRESHOLD = Priority.HIGH;
    private static final Priority QUEUE_SHUTDOWN_PRIORITY = Priority.HIGH;
    private boolean shutdown;

    public PrioritisedThreadPool(Consumer<Thread> threadModifier) {
        this.threadModifier = threadModifier;
        if (threadModifier == null) {
            throw new NullPointerException("Thread factory may not be null");
        }
    }

    public Thread[] getAliveThreads() {
        PrioritisedThread[] threads = this.aliveThreads.getArray();
        return (Thread[])Arrays.copyOf(threads, threads.length, Thread[].class);
    }

    public Thread[] getCoreThreads() {
        PrioritisedThread[] threads = this.threads.getArray();
        return (Thread[])Arrays.copyOf(threads, threads.length, Thread[].class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void halt(boolean shutdownQueues) {
        Object[] objectArray = this;
        synchronized (this) {
            this.shutdown = true;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (shutdownQueues) {
                for (ExecutorGroup group : this.executors.getArray()) {
                    for (ExecutorGroup.ThreadPoolExecutor executor : group.executors.getArray()) {
                        executor.shutdown();
                    }
                }
            }
            for (PrioritisedThread thread : this.threads.getArray()) {
                thread.halt(false);
            }
            return;
        }
    }

    public boolean join(long msToWait) {
        try {
            return this.join(msToWait, false);
        }
        catch (InterruptedException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public boolean joinInterruptable(long msToWait) throws InterruptedException {
        return this.join(msToWait, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean join(long msToWait, boolean interruptable) throws InterruptedException {
        long nsToWait = msToWait * 1000000L;
        long start = System.nanoTime();
        long deadline = start + nsToWait;
        boolean interrupted = false;
        try {
            for (PrioritisedThread thread : this.aliveThreads.getArray()) {
                while (thread.isAlive()) {
                    long current = System.nanoTime();
                    if (current >= deadline && msToWait > 0L) {
                        boolean bl = false;
                        return bl;
                    }
                    try {
                        thread.join(msToWait <= 0L ? 0L : Math.max(1L, (deadline - current) / 1000000L));
                    }
                    catch (InterruptedException ex) {
                        if (interruptable) {
                            throw ex;
                        }
                        interrupted = true;
                    }
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(boolean wait) {
        Object[] objectArray = this;
        synchronized (this) {
            this.shutdown = true;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            for (ExecutorGroup group : this.executors.getArray()) {
                for (ExecutorGroup.ThreadPoolExecutor executor : group.executors.getArray()) {
                    executor.shutdown();
                }
            }
            for (PrioritisedThread thread : this.threads.getArray()) {
                thread.close(false, false);
            }
            if (wait) {
                this.join(0L);
            }
            return;
        }
    }

    private void die(PrioritisedThread thread) {
        this.aliveThreads.remove(thread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void adjustThreadCount(int threads) {
        PrioritisedThreadPool prioritisedThreadPool = this;
        synchronized (prioritisedThreadPool) {
            if (this.shutdown) {
                return;
            }
            PrioritisedThread[] currentThreads = this.threads.getArray();
            if (threads == currentThreads.length) {
                return;
            }
            if (threads < currentThreads.length) {
                int difference = currentThreads.length - threads;
                for (int i = 0; i < difference; ++i) {
                    PrioritisedThread remove = currentThreads[currentThreads.length - i - 1];
                    remove.halt(false);
                    this.threads.remove(remove);
                }
            } else {
                int difference = threads - currentThreads.length;
                for (int i = 0; i < difference; ++i) {
                    PrioritisedThread thread = new PrioritisedThread();
                    this.threadModifier.accept(thread);
                    this.aliveThreads.add(thread);
                    this.threads.add(thread);
                    thread.start();
                }
            }
        }
    }

    private static int compareInsideGroup(ExecutorGroup.ThreadPoolExecutor src, Priority srcPriority, ExecutorGroup.ThreadPoolExecutor dst, Priority dstPriority) {
        int priorityCompare = srcPriority.ordinal() - dstPriority.ordinal();
        if (priorityCompare != 0) {
            return priorityCompare;
        }
        int parallelismCompare = src.currentParallelism - dst.currentParallelism;
        if (parallelismCompare != 0) {
            return parallelismCompare;
        }
        return TimeUtil.compareTimes(src.lastRetrieved, dst.lastRetrieved);
    }

    private static int compareOutsideGroup(ExecutorGroup.ThreadPoolExecutor src, Priority srcPriority, ExecutorGroup.ThreadPoolExecutor dst, Priority dstPriority) {
        int priorityCompare;
        if (src.getGroup().division == dst.getGroup().division && (priorityCompare = srcPriority.ordinal() - dstPriority.ordinal()) != 0) {
            return priorityCompare;
        }
        int parallelismCompare = src.getGroup().currentParallelism - dst.getGroup().currentParallelism;
        if (parallelismCompare != 0) {
            return parallelismCompare;
        }
        return TimeUtil.compareTimes(src.lastRetrieved, dst.lastRetrieved);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecutorGroup.ThreadPoolExecutor obtainQueue() {
        long time = System.nanoTime();
        PrioritisedThreadPool prioritisedThreadPool = this;
        synchronized (prioritisedThreadPool) {
            ExecutorGroup.ThreadPoolExecutor ret = null;
            Priority retPriority = null;
            for (ExecutorGroup executorGroup : this.executors.getArray()) {
                ExecutorGroup.ThreadPoolExecutor highest = null;
                Priority highestPriority = null;
                for (ExecutorGroup.ThreadPoolExecutor executor : executorGroup.executors.getArray()) {
                    Priority priority;
                    int maxParallelism = executor.maxParallelism;
                    if (maxParallelism > 0 && executor.currentParallelism >= maxParallelism || (priority = executor.getTargetPriority()) == null || highestPriority != null && PrioritisedThreadPool.compareInsideGroup(highest, highestPriority, executor, priority) <= 0) continue;
                    highest = executor;
                    highestPriority = priority;
                }
                if (highest == null || ret != null && PrioritisedThreadPool.compareOutsideGroup(ret, retPriority, highest, highestPriority) <= 0) continue;
                ret = highest;
                retPriority = highestPriority;
            }
            if (ret != null) {
                ret.lastRetrieved = time;
                ++ret.currentParallelism;
                ++ret.getGroup().currentParallelism;
                return ret;
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void returnQueue(ExecutorGroup.ThreadPoolExecutor executor) {
        PrioritisedThreadPool prioritisedThreadPool = this;
        synchronized (prioritisedThreadPool) {
            --executor.currentParallelism;
            --executor.getGroup().currentParallelism;
        }
        if (executor.isShutdown() && executor.queue.hasNoScheduledTasks()) {
            executor.getGroup().executors.remove(executor);
        }
    }

    private void notifyAllThreads() {
        for (PrioritisedThread thread : this.threads.getArray()) {
            thread.notifyTasks();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutorGroup createExecutorGroup(int division, int flags) {
        PrioritisedThreadPool prioritisedThreadPool = this;
        synchronized (prioritisedThreadPool) {
            if (this.shutdown) {
                throw new IllegalStateException("Queue is shutdown: " + this.toString());
            }
            ExecutorGroup ret = new ExecutorGroup(division, flags);
            this.executors.add(ret);
            return ret;
        }
    }

    private static final class COWArrayList<E> {
        private volatile E[] array;

        public COWArrayList(Class<E> clazz) {
            this.array = (Object[])Array.newInstance(clazz, 0);
        }

        public E[] getArray() {
            return this.array;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(E element) {
            COWArrayList cOWArrayList = this;
            synchronized (cOWArrayList) {
                E[] array = this.array;
                E[] copy = Arrays.copyOf(array, array.length + 1);
                copy[array.length] = element;
                this.array = copy;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean remove(E element) {
            COWArrayList cOWArrayList = this;
            synchronized (cOWArrayList) {
                E[] array = this.array;
                int index = -1;
                int len = array.length;
                for (int i = 0; i < len; ++i) {
                    if (array[i] != element) continue;
                    index = i;
                    break;
                }
                if (index == -1) {
                    return false;
                }
                Object[] copy = (Object[])Array.newInstance(array.getClass().getComponentType(), array.length - 1);
                System.arraycopy(array, 0, copy, 0, index);
                System.arraycopy(array, index + 1, copy, index, array.length - 1 - index);
                this.array = copy;
            }
            return true;
        }
    }

    public final class ExecutorGroup {
        private final AtomicLong subOrderGenerator = new AtomicLong();
        private final COWArrayList<ThreadPoolExecutor> executors = new COWArrayList<ThreadPoolExecutor>(ThreadPoolExecutor.class);
        private final int division;
        private int currentParallelism;

        private ExecutorGroup(int division, int flags) {
            this.division = division;
        }

        public ThreadPoolExecutor[] getAllExecutors() {
            return (ThreadPoolExecutor[])this.executors.getArray().clone();
        }

        private PrioritisedThreadPool getThreadPool() {
            return PrioritisedThreadPool.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ThreadPoolExecutor createExecutor(int maxParallelism, long queueMaxHoldTime, int flags) {
            PrioritisedThreadPool prioritisedThreadPool = PrioritisedThreadPool.this;
            synchronized (prioritisedThreadPool) {
                if (PrioritisedThreadPool.this.shutdown) {
                    throw new IllegalStateException("Queue is shutdown: " + PrioritisedThreadPool.this.toString());
                }
                ThreadPoolExecutor ret = new ThreadPoolExecutor(maxParallelism, queueMaxHoldTime, flags);
                this.executors.add(ret);
                return ret;
            }
        }

        public final class ThreadPoolExecutor
        implements PrioritisedExecutor {
            private final PrioritisedTaskQueue queue = new PrioritisedTaskQueue();
            private volatile int maxParallelism;
            private final long queueMaxHoldTime;
            private volatile int currentParallelism;
            private volatile boolean halt;
            private long lastRetrieved = System.nanoTime();

            private ThreadPoolExecutor(int maxParallelism, long queueMaxHoldTime, int flags) {
                this.maxParallelism = maxParallelism;
                this.queueMaxHoldTime = queueMaxHoldTime;
            }

            private ExecutorGroup getGroup() {
                return ExecutorGroup.this;
            }

            private boolean canNotify() {
                if (this.halt) {
                    return false;
                }
                int max = this.maxParallelism;
                return max < 0 || this.currentParallelism < max;
            }

            private void notifyHighPriority() {
                if (!this.canNotify()) {
                    return;
                }
                for (PrioritisedThread thread : this.getGroup().getThreadPool().threads.getArray()) {
                    if (!thread.alertHighPriorityExecutor()) continue;
                    return;
                }
            }

            private void notifyScheduled() {
                if (!this.canNotify()) {
                    return;
                }
                for (PrioritisedThread thread : this.getGroup().getThreadPool().threads.getArray()) {
                    if (!thread.notifyTasks()) continue;
                    return;
                }
            }

            public void halt() {
                this.halt = true;
                ExecutorGroup.this.executors.remove(this);
            }

            public boolean isActive() {
                if (this.halt) {
                    return this.currentParallelism > 0;
                }
                if (!this.isShutdown()) {
                    return true;
                }
                return !this.queue.hasNoScheduledTasks();
            }

            @Override
            public boolean shutdown() {
                if (!this.queue.shutdown()) {
                    return false;
                }
                if (this.queue.hasNoScheduledTasks()) {
                    ExecutorGroup.this.executors.remove(this);
                }
                return true;
            }

            @Override
            public boolean isShutdown() {
                return this.queue.isShutdown();
            }

            public void setMaxParallelism(int maxParallelism) {
                this.maxParallelism = maxParallelism;
                if (this.getTargetPriority() != null) {
                    ExecutorGroup.this.getThreadPool().notifyAllThreads();
                }
            }

            Priority getTargetPriority() {
                Priority ret = this.queue.getHighestPriority();
                if (!this.isShutdown()) {
                    return ret;
                }
                return ret == null ? QUEUE_SHUTDOWN_PRIORITY : Priority.max(ret, QUEUE_SHUTDOWN_PRIORITY);
            }

            @Override
            public long getTotalTasksScheduled() {
                return this.queue.getTotalTasksScheduled();
            }

            @Override
            public long getTotalTasksExecuted() {
                return this.queue.getTotalTasksExecuted();
            }

            @Override
            public long generateNextSubOrder() {
                return ExecutorGroup.this.subOrderGenerator.getAndIncrement();
            }

            @Override
            public boolean executeTask() {
                return this.queue.executeTask();
            }

            @Override
            public PrioritisedExecutor.PrioritisedTask queueTask(Runnable task) {
                PrioritisedExecutor.PrioritisedTask ret = this.createTask(task);
                ret.queue();
                return ret;
            }

            @Override
            public PrioritisedExecutor.PrioritisedTask queueTask(Runnable task, Priority priority) {
                PrioritisedExecutor.PrioritisedTask ret = this.createTask(task, priority);
                ret.queue();
                return ret;
            }

            @Override
            public PrioritisedExecutor.PrioritisedTask queueTask(Runnable task, Priority priority, long subOrder) {
                PrioritisedExecutor.PrioritisedTask ret = this.createTask(task, priority, subOrder);
                ret.queue();
                return ret;
            }

            @Override
            public PrioritisedExecutor.PrioritisedTask createTask(Runnable task) {
                return this.createTask(task, Priority.NORMAL);
            }

            @Override
            public PrioritisedExecutor.PrioritisedTask createTask(Runnable task, Priority priority) {
                return this.createTask(task, priority, this.generateNextSubOrder());
            }

            @Override
            public PrioritisedExecutor.PrioritisedTask createTask(Runnable task, Priority priority, long subOrder) {
                return new WrappedTask(this.queue.createTask(task, priority, subOrder));
            }

            private final class WrappedTask
            implements PrioritisedExecutor.PrioritisedTask {
                private final PrioritisedExecutor.PrioritisedTask wrapped;

                private WrappedTask(PrioritisedExecutor.PrioritisedTask wrapped) {
                    this.wrapped = wrapped;
                }

                @Override
                public PrioritisedExecutor getExecutor() {
                    return ThreadPoolExecutor.this;
                }

                @Override
                public boolean queue() {
                    if (this.wrapped.queue()) {
                        Priority priority = this.getPriority();
                        if (priority != Priority.COMPLETING) {
                            if (priority.isHigherOrEqualPriority(HIGH_PRIORITY_NOTIFY_THRESHOLD)) {
                                ThreadPoolExecutor.this.notifyHighPriority();
                            } else {
                                ThreadPoolExecutor.this.notifyScheduled();
                            }
                        }
                        return true;
                    }
                    return false;
                }

                @Override
                public boolean isQueued() {
                    return this.wrapped.isQueued();
                }

                @Override
                public boolean cancel() {
                    return this.wrapped.cancel();
                }

                @Override
                public boolean execute() {
                    return this.wrapped.execute();
                }

                @Override
                public Priority getPriority() {
                    return this.wrapped.getPriority();
                }

                @Override
                public boolean setPriority(Priority priority) {
                    if (this.wrapped.setPriority(priority)) {
                        if (priority.isHigherOrEqualPriority(HIGH_PRIORITY_NOTIFY_THRESHOLD)) {
                            ThreadPoolExecutor.this.notifyHighPriority();
                        }
                        return true;
                    }
                    return false;
                }

                @Override
                public boolean raisePriority(Priority priority) {
                    if (this.wrapped.raisePriority(priority)) {
                        if (priority.isHigherOrEqualPriority(HIGH_PRIORITY_NOTIFY_THRESHOLD)) {
                            ThreadPoolExecutor.this.notifyHighPriority();
                        }
                        return true;
                    }
                    return false;
                }

                @Override
                public boolean lowerPriority(Priority priority) {
                    return this.wrapped.lowerPriority(priority);
                }

                @Override
                public long getSubOrder() {
                    return this.wrapped.getSubOrder();
                }

                @Override
                public boolean setSubOrder(long subOrder) {
                    return this.wrapped.setSubOrder(subOrder);
                }

                @Override
                public boolean raiseSubOrder(long subOrder) {
                    return this.wrapped.raiseSubOrder(subOrder);
                }

                @Override
                public boolean lowerSubOrder(long subOrder) {
                    return this.wrapped.lowerSubOrder(subOrder);
                }

                @Override
                public boolean setPriorityAndSubOrder(Priority priority, long subOrder) {
                    if (this.wrapped.setPriorityAndSubOrder(priority, subOrder)) {
                        if (priority.isHigherOrEqualPriority(HIGH_PRIORITY_NOTIFY_THRESHOLD)) {
                            ThreadPoolExecutor.this.notifyHighPriority();
                        }
                        return true;
                    }
                    return false;
                }
            }
        }
    }

    private final class PrioritisedThread
    extends PrioritisedQueueExecutorThread {
        private final AtomicBoolean alertedHighPriority;

        public PrioritisedThread() {
            super((PrioritisedExecutor)null);
            this.alertedHighPriority = new AtomicBoolean();
        }

        public boolean alertHighPriorityExecutor() {
            if (!this.notifyTasks()) {
                if (!this.alertedHighPriority.get()) {
                    this.alertedHighPriority.set(true);
                }
                return false;
            }
            return true;
        }

        private boolean isAlertedHighPriority() {
            return this.alertedHighPriority.get() && this.alertedHighPriority.getAndSet(false);
        }

        @Override
        protected void die() {
            PrioritisedThreadPool.this.die(this);
        }

        @Override
        protected boolean pollTasks() {
            ExecutorGroup.ThreadPoolExecutor executor;
            boolean ret = false;
            while (!this.halted && (executor = PrioritisedThreadPool.this.obtainQueue()) != null) {
                long deadline = System.nanoTime() + executor.queueMaxHoldTime;
                do {
                    try {
                        if (this.halted || executor.halt || !executor.executeTask()) break;
                        ret = true;
                    }
                    catch (Throwable throwable) {
                        LOGGER.error("Exception thrown from thread '" + this.getName() + "' in queue '" + executor.toString() + "'", throwable);
                    }
                } while (!this.isAlertedHighPriority() && System.nanoTime() <= deadline);
                PrioritisedThreadPool.this.returnQueue(executor);
            }
            return ret;
        }
    }
}

