/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.common.util;

import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;

public final class WorldUtil {
    public static int getMaxSection(LevelHeightAccessor world) {
        return world.getMaxSection() - 1;
    }

    public static int getMaxSection(Level world) {
        return world.getMaxSection() - 1;
    }

    public static int getMinSection(LevelHeightAccessor world) {
        return world.getMinSection();
    }

    public static int getMinSection(Level world) {
        return world.getMinSection();
    }

    public static int getMaxLightSection(LevelHeightAccessor world) {
        return WorldUtil.getMaxSection(world) + 1;
    }

    public static int getMinLightSection(LevelHeightAccessor world) {
        return WorldUtil.getMinSection(world) - 1;
    }

    public static int getTotalSections(LevelHeightAccessor world) {
        return WorldUtil.getMaxSection(world) - WorldUtil.getMinSection(world) + 1;
    }

    public static int getTotalLightSections(LevelHeightAccessor world) {
        return WorldUtil.getMaxLightSection(world) - WorldUtil.getMinLightSection(world) + 1;
    }

    public static int getMinBlockY(LevelHeightAccessor world) {
        return WorldUtil.getMinSection(world) << 4;
    }

    public static int getMaxBlockY(LevelHeightAccessor world) {
        return WorldUtil.getMaxSection(world) << 4 | 0xF;
    }

    public static String getWorldName(Level world) {
        if (world == null) {
            return "null world";
        }
        return world.dimension().toString();
    }

    private WorldUtil() {
        throw new RuntimeException();
    }
}

