/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.common.util;

import net.minecraft.world.level.levelgen.LegacyRandomSource;

public final class SimpleRandom
extends LegacyRandomSource {
    private static final long MULTIPLIER = 25214903917L;
    private static final long ADDEND = 11L;
    private static final int BITS = 48;
    private static final long MASK = 0xFFFFFFFFFFFFL;
    private long value;

    public SimpleRandom(long seed) {
        super(0L);
        this.value = seed;
    }

    public void setSeed(long seed) {
        this.value = (seed ^ 0x5DEECE66DL) & 0xFFFFFFFFFFFFL;
    }

    private long advanceSeed() {
        this.value = this.value * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
        return this.value;
    }

    public int next(int bits) {
        return (int)(this.advanceSeed() >>> 48 - bits);
    }

    public int nextInt() {
        long seed = this.advanceSeed();
        return (int)(seed >>> 16);
    }

    public int nextInt(int bound) {
        if (bound <= 0) {
            throw new IllegalArgumentException();
        }
        long value = this.advanceSeed() >>> 16;
        return (int)(value * (long)bound >>> 32);
    }
}

