/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.common.misc;

import ca.spottedleaf.moonrise.libs.ca.spottedleaf.concurrentutil.util.IntegerUtil;

public abstract class SingleUserAreaMap<T> {
    public static final int NOT_SET = Integer.MIN_VALUE;
    private final T parameter;
    private int lastChunkX = Integer.MIN_VALUE;
    private int lastChunkZ = Integer.MIN_VALUE;
    private int distance = Integer.MIN_VALUE;

    public SingleUserAreaMap(T parameter) {
        this.parameter = parameter;
    }

    public final T getParameter() {
        return this.parameter;
    }

    public final int getLastChunkX() {
        return this.lastChunkX;
    }

    public final int getLastChunkZ() {
        return this.lastChunkZ;
    }

    public final int getLastDistance() {
        return this.distance;
    }

    protected static int sign(int val) {
        return 1 | val >> 31;
    }

    protected abstract void addCallback(T var1, int var2, int var3);

    protected abstract void removeCallback(T var1, int var2, int var3);

    private void addToNew(T parameter, int chunkX, int chunkZ, int distance) {
        int maxX = chunkX + distance;
        int maxZ = chunkZ + distance;
        for (int cx = chunkX - distance; cx <= maxX; ++cx) {
            for (int cz = chunkZ - distance; cz <= maxZ; ++cz) {
                this.addCallback(parameter, cx, cz);
            }
        }
    }

    private void removeFromOld(T parameter, int chunkX, int chunkZ, int distance) {
        int maxX = chunkX + distance;
        int maxZ = chunkZ + distance;
        for (int cx = chunkX - distance; cx <= maxX; ++cx) {
            for (int cz = chunkZ - distance; cz <= maxZ; ++cz) {
                this.removeCallback(parameter, cx, cz);
            }
        }
    }

    public final boolean add(int chunkX, int chunkZ, int distance) {
        if (distance < 0) {
            throw new IllegalArgumentException(Integer.toString(distance));
        }
        if (this.lastChunkX != Integer.MIN_VALUE) {
            return false;
        }
        this.lastChunkX = chunkX;
        this.lastChunkZ = chunkZ;
        this.distance = distance;
        this.addToNew(this.parameter, chunkX, chunkZ, distance);
        return true;
    }

    public final boolean update(int toX, int toZ, int newViewDistance) {
        int currZ;
        int currX;
        int minZ;
        int maxZ;
        int minX;
        int maxX;
        int totalZ;
        if (newViewDistance < 0) {
            throw new IllegalArgumentException(Integer.toString(newViewDistance));
        }
        int fromX = this.lastChunkX;
        int fromZ = this.lastChunkZ;
        int oldViewDistance = this.distance;
        if (fromX == Integer.MIN_VALUE) {
            return false;
        }
        this.lastChunkX = toX;
        this.lastChunkZ = toZ;
        this.distance = newViewDistance;
        T parameter = this.parameter;
        int dx = toX - fromX;
        int dz = toZ - fromZ;
        int totalX = IntegerUtil.branchlessAbs(fromX - toX);
        if (Math.max(totalX, totalZ = IntegerUtil.branchlessAbs(fromZ - toZ)) > 2 * Math.max(newViewDistance, oldViewDistance)) {
            this.removeFromOld(parameter, fromX, fromZ, oldViewDistance);
            this.addToNew(parameter, toX, toZ, newViewDistance);
            return true;
        }
        if (oldViewDistance != newViewDistance) {
            int oldMinX = fromX - oldViewDistance;
            int oldMinZ = fromZ - oldViewDistance;
            int oldMaxX = fromX + oldViewDistance;
            int oldMaxZ = fromZ + oldViewDistance;
            for (int currX2 = oldMinX; currX2 <= oldMaxX; ++currX2) {
                for (int currZ2 = oldMinZ; currZ2 <= oldMaxZ; ++currZ2) {
                    if (Math.max(IntegerUtil.branchlessAbs(currX2 - toX), IntegerUtil.branchlessAbs(currZ2 - toZ)) <= newViewDistance) continue;
                    this.removeCallback(parameter, currX2, currZ2);
                }
            }
            int newMinX = toX - newViewDistance;
            int newMinZ = toZ - newViewDistance;
            int newMaxX = toX + newViewDistance;
            int newMaxZ = toZ + newViewDistance;
            for (int currX3 = newMinX; currX3 <= newMaxX; ++currX3) {
                for (int currZ3 = newMinZ; currZ3 <= newMaxZ; ++currZ3) {
                    if (Math.max(IntegerUtil.branchlessAbs(currX3 - fromX), IntegerUtil.branchlessAbs(currZ3 - fromZ)) <= oldViewDistance) continue;
                    this.addCallback(parameter, currX3, currZ3);
                }
            }
            return true;
        }
        int up = SingleUserAreaMap.sign(dz);
        int right = SingleUserAreaMap.sign(dx);
        if (dx != 0) {
            maxX = toX + oldViewDistance * right + right;
            minX = fromX + oldViewDistance * right + right;
            maxZ = fromZ + oldViewDistance * up + up;
            minZ = toZ - oldViewDistance * up;
            for (currX = minX; currX != maxX; currX += right) {
                for (currZ = minZ; currZ != maxZ; currZ += up) {
                    this.addCallback(parameter, currX, currZ);
                }
            }
        }
        if (dz != 0) {
            maxX = toX + oldViewDistance * right + right;
            minX = toX - oldViewDistance * right;
            maxZ = toZ + oldViewDistance * up + up;
            minZ = fromZ + oldViewDistance * up + up;
            for (currX = minX; currX != maxX; currX += right) {
                for (currZ = minZ; currZ != maxZ; currZ += up) {
                    this.addCallback(parameter, currX, currZ);
                }
            }
        }
        if (dx != 0) {
            maxX = toX - oldViewDistance * right;
            minX = fromX - oldViewDistance * right;
            maxZ = fromZ + oldViewDistance * up + up;
            minZ = toZ - oldViewDistance * up;
            for (currX = minX; currX != maxX; currX += right) {
                for (currZ = minZ; currZ != maxZ; currZ += up) {
                    this.removeCallback(parameter, currX, currZ);
                }
            }
        }
        if (dz != 0) {
            maxX = fromX + oldViewDistance * right + right;
            minX = fromX - oldViewDistance * right;
            maxZ = toZ - oldViewDistance * up;
            minZ = fromZ - oldViewDistance * up;
            for (currX = minX; currX != maxX; currX += right) {
                for (currZ = minZ; currZ != maxZ; currZ += up) {
                    this.removeCallback(parameter, currX, currZ);
                }
            }
        }
        return true;
    }

    public final boolean remove() {
        int chunkX = this.lastChunkX;
        int chunkZ = this.lastChunkZ;
        int distance = this.distance;
        if (chunkX == Integer.MIN_VALUE) {
            return false;
        }
        this.distance = Integer.MIN_VALUE;
        this.lastChunkZ = Integer.MIN_VALUE;
        this.lastChunkX = Integer.MIN_VALUE;
        this.removeFromOld(this.parameter, chunkX, chunkZ, distance);
        return true;
    }
}

