/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.common.misc;

import ca.spottedleaf.moonrise.common.misc.SingleUserAreaMap;
import ca.spottedleaf.moonrise.libs.ca.spottedleaf.concurrentutil.util.IntPairUtil;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceSet;

public final class PositionCountingAreaMap<T> {
    private final Reference2ReferenceOpenHashMap<T, PositionCounter> counters = new Reference2ReferenceOpenHashMap();
    private final Long2IntOpenHashMap positions = new Long2IntOpenHashMap();

    public ReferenceSet<T> getObjects() {
        return this.counters.keySet();
    }

    public int getTotalPositions() {
        return this.positions.size();
    }

    public boolean hasObjectsNear(int toX, int toZ) {
        return this.positions.containsKey(IntPairUtil.key(toX, toZ));
    }

    public int getObjectsNear(int toX, int toZ) {
        return this.positions.get(IntPairUtil.key(toX, toZ));
    }

    public boolean add(T parameter, int toX, int toZ, int distance) {
        PositionCounter existing = (PositionCounter)this.counters.get(parameter);
        if (existing != null) {
            return false;
        }
        PositionCounter counter = new PositionCounter(parameter);
        this.counters.put(parameter, (Object)counter);
        return counter.add(toX, toZ, distance);
    }

    public boolean addOrUpdate(T parameter, int toX, int toZ, int distance) {
        PositionCounter existing = (PositionCounter)this.counters.get(parameter);
        if (existing != null) {
            return existing.update(toX, toZ, distance);
        }
        PositionCounter counter = new PositionCounter(parameter);
        this.counters.put(parameter, (Object)counter);
        return counter.add(toX, toZ, distance);
    }

    public boolean remove(T parameter) {
        PositionCounter counter = (PositionCounter)this.counters.remove(parameter);
        if (counter == null) {
            return false;
        }
        counter.remove();
        return true;
    }

    public boolean update(T parameter, int toX, int toZ, int distance) {
        PositionCounter counter = (PositionCounter)this.counters.get(parameter);
        if (counter == null) {
            return false;
        }
        return counter.update(toX, toZ, distance);
    }

    private final class PositionCounter
    extends SingleUserAreaMap<T> {
        public PositionCounter(T parameter) {
            super(parameter);
        }

        @Override
        protected void addCallback(T parameter, int toX, int toZ) {
            PositionCountingAreaMap.this.positions.addTo(IntPairUtil.key(toX, toZ), 1);
        }

        @Override
        protected void removeCallback(T parameter, int toX, int toZ) {
            long key = IntPairUtil.key(toX, toZ);
            if (PositionCountingAreaMap.this.positions.addTo(key, -1) == 1) {
                PositionCountingAreaMap.this.positions.remove(key);
            }
        }
    }
}

