/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.common.misc;

import ca.spottedleaf.moonrise.common.misc.Delayed8WayDistancePropagator2D;
import ca.spottedleaf.moonrise.common.util.CoordinateUtils;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongListIterator;

public final class Delayed26WayDistancePropagator3D {
    protected final Delayed8WayDistancePropagator2D.LevelMap levels = new Delayed8WayDistancePropagator2D.LevelMap(16384, 0.6f);
    protected final Long2ByteOpenHashMap sources = new Long2ByteOpenHashMap(4096, 0.6f);
    protected final LongLinkedOpenHashSet updatedSources = new LongLinkedOpenHashSet();
    protected final LevelChangeCallback changeCallback;
    protected final Delayed8WayDistancePropagator2D.WorkQueue[] levelIncreaseWorkQueues = new Delayed8WayDistancePropagator2D.WorkQueue[64];
    protected final Delayed8WayDistancePropagator2D.WorkQueue[] levelRemoveWorkQueues;
    protected long levelIncreaseWorkQueueBitset;
    protected long levelRemoveWorkQueueBitset;

    public Delayed26WayDistancePropagator3D() {
        this(null);
    }

    public Delayed26WayDistancePropagator3D(LevelChangeCallback changeCallback) {
        int i;
        for (i = 0; i < this.levelIncreaseWorkQueues.length; ++i) {
            this.levelIncreaseWorkQueues[i] = new Delayed8WayDistancePropagator2D.WorkQueue();
        }
        this.levelRemoveWorkQueues = new Delayed8WayDistancePropagator2D.WorkQueue[64];
        for (i = 0; i < this.levelRemoveWorkQueues.length; ++i) {
            this.levelRemoveWorkQueues[i] = new Delayed8WayDistancePropagator2D.WorkQueue();
        }
        this.changeCallback = changeCallback;
    }

    public int getLevel(long pos) {
        return this.levels.get(pos);
    }

    public int getLevel(int x, int y, int z) {
        return this.levels.get(CoordinateUtils.getChunkSectionKey(x, y, z));
    }

    public void setSource(int x, int y, int z, int level) {
        this.setSource(CoordinateUtils.getChunkSectionKey(x, y, z), level);
    }

    public void setSource(long coordinate, int level) {
        if ((level & 0x3F) != level || level == 0) {
            throw new IllegalArgumentException("Level must be in (0, 63], not " + level);
        }
        byte byteLevel = (byte)level;
        byte oldLevel = this.sources.put(coordinate, byteLevel);
        if (oldLevel == byteLevel) {
            return;
        }
        this.updatedSources.add(coordinate);
    }

    public void removeSource(int x, int y, int z) {
        this.removeSource(CoordinateUtils.getChunkSectionKey(x, y, z));
    }

    public void removeSource(long coordinate) {
        if (this.sources.remove(coordinate) != 0) {
            this.updatedSources.add(coordinate);
        }
    }

    protected final void addToIncreaseWorkQueue(long coordinate, byte level) {
        Delayed8WayDistancePropagator2D.WorkQueue queue = this.levelIncreaseWorkQueues[level];
        queue.queuedCoordinates.enqueue(coordinate);
        queue.queuedLevels.enqueue(level);
        this.levelIncreaseWorkQueueBitset |= 1L << level;
    }

    protected final void addToIncreaseWorkQueue(long coordinate, byte index, byte level) {
        Delayed8WayDistancePropagator2D.WorkQueue queue = this.levelIncreaseWorkQueues[index];
        queue.queuedCoordinates.enqueue(coordinate);
        queue.queuedLevels.enqueue(level);
        this.levelIncreaseWorkQueueBitset |= 1L << index;
    }

    protected final void addToRemoveWorkQueue(long coordinate, byte level) {
        Delayed8WayDistancePropagator2D.WorkQueue queue = this.levelRemoveWorkQueues[level];
        queue.queuedCoordinates.enqueue(coordinate);
        queue.queuedLevels.enqueue(level);
        this.levelRemoveWorkQueueBitset |= 1L << level;
    }

    public boolean propagateUpdates() {
        if (this.updatedSources.isEmpty()) {
            return false;
        }
        boolean ret = false;
        LongListIterator iterator = this.updatedSources.iterator();
        while (iterator.hasNext()) {
            byte updatedSource;
            long coordinate = iterator.nextLong();
            byte currentLevel = this.levels.get(coordinate);
            if (currentLevel == (updatedSource = this.sources.get(coordinate))) continue;
            ret = true;
            if (updatedSource > currentLevel) {
                this.addToIncreaseWorkQueue(coordinate, updatedSource);
                continue;
            }
            this.addToRemoveWorkQueue(coordinate, currentLevel);
        }
        this.updatedSources.clear();
        this.propagateIncreases();
        this.propagateDecreases();
        return ret;
    }

    protected void propagateIncreases() {
        int queueIndex = 0x3F ^ Long.numberOfLeadingZeros(this.levelIncreaseWorkQueueBitset);
        while (this.levelIncreaseWorkQueueBitset != 0L) {
            Delayed8WayDistancePropagator2D.WorkQueue queue = this.levelIncreaseWorkQueues[queueIndex];
            while (!queue.queuedLevels.isEmpty()) {
                byte currentLevel;
                boolean neighbourCheck;
                long coordinate = queue.queuedCoordinates.removeFirstLong();
                byte level = queue.queuedLevels.removeFirstByte();
                boolean bl = neighbourCheck = level < 0;
                if (neighbourCheck) {
                    level = -level;
                    currentLevel = this.levels.get(coordinate);
                } else {
                    currentLevel = this.levels.putIfGreater(coordinate, level);
                }
                if (!neighbourCheck ? currentLevel >= level : currentLevel != level) continue;
                if (this.changeCallback != null) {
                    this.changeCallback.onLevelUpdate(coordinate, currentLevel, level);
                }
                if (level == 1) continue;
                byte neighbourLevel = (byte)(level - 1);
                int x = CoordinateUtils.getChunkSectionX(coordinate);
                int y = CoordinateUtils.getChunkSectionY(coordinate);
                int z = CoordinateUtils.getChunkSectionZ(coordinate);
                for (int dy = -1; dy <= 1; ++dy) {
                    for (int dz = -1; dz <= 1; ++dz) {
                        for (int dx = -1; dx <= 1; ++dx) {
                            if ((dy | dz | dx) == 0) continue;
                            long neighbourCoordinate = CoordinateUtils.getChunkSectionKey(dx + x, dy + y, dz + z);
                            this.addToIncreaseWorkQueue(neighbourCoordinate, neighbourLevel);
                        }
                    }
                }
            }
            this.levelIncreaseWorkQueueBitset ^= 1L << queueIndex;
            queueIndex = 0x3F ^ Long.numberOfLeadingZeros(this.levelIncreaseWorkQueueBitset);
        }
    }

    protected void propagateDecreases() {
        int queueIndex = 0x3F ^ Long.numberOfLeadingZeros(this.levelRemoveWorkQueueBitset);
        while (this.levelRemoveWorkQueueBitset != 0L) {
            Delayed8WayDistancePropagator2D.WorkQueue queue = this.levelRemoveWorkQueues[queueIndex];
            while (!queue.queuedLevels.isEmpty()) {
                byte source;
                byte level;
                long coordinate = queue.queuedCoordinates.removeFirstLong();
                byte currentLevel = this.levels.removeIfGreaterOrEqual(coordinate, level = queue.queuedLevels.removeFirstByte());
                if (currentLevel == 0) continue;
                if (currentLevel > level) {
                    this.addToIncreaseWorkQueue(coordinate, currentLevel, -currentLevel);
                    continue;
                }
                if (this.changeCallback != null) {
                    this.changeCallback.onLevelUpdate(coordinate, currentLevel, (byte)0);
                }
                if ((source = this.sources.get(coordinate)) != 0) {
                    this.addToIncreaseWorkQueue(coordinate, source);
                }
                if (level == 0) continue;
                byte neighbourLevel = (byte)(level - 1);
                int x = CoordinateUtils.getChunkSectionX(coordinate);
                int y = CoordinateUtils.getChunkSectionY(coordinate);
                int z = CoordinateUtils.getChunkSectionZ(coordinate);
                for (int dy = -1; dy <= 1; ++dy) {
                    for (int dz = -1; dz <= 1; ++dz) {
                        for (int dx = -1; dx <= 1; ++dx) {
                            if ((dy | dz | dx) == 0) continue;
                            long neighbourCoordinate = CoordinateUtils.getChunkSectionKey(dx + x, dy + y, dz + z);
                            this.addToRemoveWorkQueue(neighbourCoordinate, neighbourLevel);
                        }
                    }
                }
            }
            this.levelRemoveWorkQueueBitset ^= 1L << queueIndex;
            queueIndex = 0x3F ^ Long.numberOfLeadingZeros(this.levelRemoveWorkQueueBitset);
        }
        this.propagateIncreases();
    }

    @FunctionalInterface
    public static interface LevelChangeCallback {
        public void onLevelUpdate(long var1, byte var3, byte var4);
    }
}

