/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.common.list;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Comparator;

public final class SortedList<E> {
    private static final Object[] EMPTY_LIST = new Object[0];
    private Comparator<? super E> comparator;
    private E[] elements;
    private int count;

    public SortedList(Comparator<? super E> comparator) {
        this(EMPTY_LIST, comparator);
    }

    public SortedList(E[] elements, Comparator<? super E> comparator) {
        this.elements = elements;
        this.comparator = comparator;
    }

    private static <E> int insertIdx(E[] elements, E element, Comparator<E> comparator, int start, int end) {
        while (start <= end) {
            int middle = start + end >>> 1;
            E middleVal = elements[middle];
            int cmp = comparator.compare(element, middleVal);
            if (cmp < 0) {
                end = middle - 1;
                continue;
            }
            start = middle + 1;
        }
        return start;
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public int add(E element) {
        E[] elements = this.elements;
        int count = this.count;
        this.count = count + 1;
        Comparator<? super E> comparator = this.comparator;
        int idx = SortedList.insertIdx(elements, element, comparator, 0, count - 1);
        if (count >= elements.length) {
            if (idx == count) {
                this.elements = elements = Arrays.copyOf(elements, (int)Math.max(4L, (long)count * 2L));
                elements[count] = element;
                return idx;
            }
            Object[] newElements = (Object[])Array.newInstance(elements.getClass().getComponentType(), (int)Math.max(4L, (long)count * 2L));
            System.arraycopy(elements, 0, newElements, 0, idx);
            newElements[idx] = element;
            System.arraycopy(elements, idx, newElements, idx + 1, count - idx);
            this.elements = newElements;
            return idx;
        }
        if (idx == count) {
            elements[idx] = element;
            return idx;
        }
        System.arraycopy(elements, idx, elements, idx + 1, count - idx);
        elements[idx] = element;
        return idx;
    }

    public E get(int idx) {
        if (idx < 0 || idx >= this.count) {
            throw new IndexOutOfBoundsException(idx);
        }
        return this.elements[idx];
    }

    public E remove(E element) {
        int last;
        E[] elements = this.elements;
        int count = this.count;
        Comparator<? super E> comparator = this.comparator;
        int idx = Arrays.binarySearch(elements, 0, count, element, comparator);
        if (idx < 0) {
            return null;
        }
        this.count = last = this.count - 1;
        E ret = elements[idx];
        System.arraycopy(elements, idx + 1, elements, idx, last - idx);
        elements[last] = null;
        return ret;
    }
}

