/*
 * Decompiled with CFR 0.152.
 */
package customskinloader.mixin.core;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import customskinloader.log.LogManager;
import customskinloader.log.Logger;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.file.Paths;
import java.util.List;
import java.util.Set;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class MixinConfigPlugin
implements IMixinConfigPlugin {
    public static Logger logger = LogManager.getLogger("Core");
    private long world_version;
    private long protocol_version;

    public void onLoad(String mixinPackage) {
        LogManager.setLogFile(Paths.get("./CustomSkinLoader/CustomSkinLoader.log", new String[0]));
        URL versionJson = ClassLoader.getSystemClassLoader().getResource("version.json");
        if (versionJson != null) {
            logger.info("\"version.json\": " + versionJson);
            try (InputStream is = versionJson.openStream();
                 InputStreamReader isr = new InputStreamReader(is);){
                JsonObject object = new JsonParser().parse((Reader)isr).getAsJsonObject();
                String name = object.get("name").getAsString();
                this.world_version = object.get("world_version").getAsLong();
                this.protocol_version = object.get("protocol_version").getAsLong();
                logger.info("MinecraftVersion: {name='" + name + "', world_version='" + this.world_version + "', protocol_version='" + this.protocol_version + "'}");
            }
            catch (Throwable t) {
                logger.warning("An exception occurred when reading \"version.json\"!");
                logger.warning(t);
            }
        } else {
            logger.warning("Can't read \"version.json\"! Ignore this message if the version you start is earlier than 18w47b.");
        }
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        boolean result = true;
        if (mixinClassName.endsWith(".MixinIImageBuffer")) {
            result = this.world_version >= 0L && this.world_version <= 2204L && this.protocol_version >= 0L && this.protocol_version <= 553L;
        } else if (mixinClassName.endsWith(".MixinLayerCape$V1")) {
            result = this.world_version >= 2210L && this.world_version <= 4654L && (this.protocol_version >= 558L && this.protocol_version <= 773L || this.protocol_version >= 801L && this.protocol_version <= 803L || this.protocol_version >= 0x40000001L && this.protocol_version <= 1073742098L);
        } else if (mixinClassName.endsWith(".MixinLayerCape$V2")) {
            result = this.world_version >= 4655L && (this.protocol_version >= 774L && this.protocol_version < 801L || this.protocol_version > 803L && this.protocol_version < 0x40000001L || this.protocol_version >= 1073742099L);
        } else if (mixinClassName.endsWith(".MixinRenderPlayer")) {
            result = this.world_version >= 2210L && this.world_version <= 3955L && (this.protocol_version >= 558L && this.protocol_version <= 767L || this.protocol_version >= 801L && this.protocol_version <= 803L || this.protocol_version >= 0x40000001L && this.protocol_version <= 0x400000CCL);
        } else if (mixinClassName.endsWith(".MixinSkinManager$V1")) {
            result = this.world_version >= 0L && this.protocol_version >= 0L;
        } else if (mixinClassName.endsWith(".MixinSkinManager$V2")) {
            result = this.world_version >= 0L && this.world_version <= 3465L && (this.protocol_version >= 0L && this.protocol_version <= 763L || this.protocol_version >= 801L && this.protocol_version <= 803L || this.protocol_version >= 0x40000001L && this.protocol_version <= 1073741966L);
        } else if (mixinClassName.endsWith(".MixinSkinManager$V3")) {
            result = this.world_version >= 3684L && (this.protocol_version >= 765L && this.protocol_version < 801L || this.protocol_version > 803L && this.protocol_version < 0x40000001L || this.protocol_version >= 1073741981L);
        } else if (mixinClassName.endsWith(".MixinSkinManager$1") || mixinClassName.endsWith(".MixinSkinManager$TextureCache")) {
            result = this.world_version >= 3567L && (this.protocol_version >= 764L && this.protocol_version < 801L || this.protocol_version > 803L && this.protocol_version < 0x40000001L || this.protocol_version >= 0x40000090L);
        } else if (mixinClassName.endsWith(".MixinSkinTextureDownloader$V1") || mixinClassName.endsWith(".MixinResourceLocation$V1")) {
            result = this.world_version >= 4178L && this.world_version <= 4659L && (this.protocol_version >= 769L && this.protocol_version <= 773L || this.protocol_version >= 1073742046L && this.protocol_version <= 0x40000114L);
        } else if (mixinClassName.endsWith(".MixinSkinTextureDownloader$V2")) {
            result = this.world_version >= 4178L && (this.protocol_version >= 769L && this.protocol_version < 801L || this.protocol_version > 803L && this.protocol_version < 0x40000001L || this.protocol_version >= 1073742046L);
        } else if (mixinClassName.endsWith(".MixinSkinTextureDownloader$V3") || mixinClassName.endsWith(".MixinIResourceManager$V2") || mixinClassName.endsWith(".MixinResourceLocation$V2")) {
            result = this.world_version >= 4660L && (this.protocol_version >= 774L && this.protocol_version < 801L || this.protocol_version > 803L && this.protocol_version < 0x40000001L || this.protocol_version >= 1073742101L);
        } else if (mixinClassName.endsWith(".MixinThreadDownloadImageData$V1")) {
            result = this.world_version >= 2205L && this.world_version <= 2722L && (this.protocol_version >= 554L && this.protocol_version <= 754L || this.protocol_version >= 801L && this.protocol_version <= 803L || this.protocol_version >= 0x40000001L && this.protocol_version <= 0x40000022L);
        } else if (mixinClassName.endsWith(".MixinThreadDownloadImageData$V2")) {
            result = this.world_version >= 2723L && this.world_version <= 4177L && (this.protocol_version >= 755L && this.protocol_version <= 768L || this.protocol_version >= 1073741859L && this.protocol_version <= 0x400000DDL);
        }
        logger.info("target: " + targetClassName + ", mixin: " + mixinClassName + ", result: " + result);
        return result;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void preApply(String targetClassName, org.spongepowered.asm.lib.tree.ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, org.spongepowered.asm.lib.tree.ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

