/*
 * Decompiled with CFR 0.152.
 */
package customskinloader.log;

import customskinloader.log.Logger;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class LogManager {
    private static Path logFile;
    private static Writer logWriter;
    private static final Map<String, Logger> loggers;

    public static void setLogFile(Path logFile) {
        if (logFile == null || logFile.equals(LogManager.logFile)) {
            return;
        }
        LogManager.logFile = logFile;
        try {
            if (logWriter != null) {
                logWriter.close();
            }
            Files.createDirectories(logFile.getParent(), new FileAttribute[0]);
            logWriter = Files.newBufferedWriter(logFile, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            loggers.forEach((k, v) -> v.setWriter(logWriter));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Logger getLogger(String loggerName) {
        return loggers.computeIfAbsent(loggerName, it -> new Logger(logWriter, "CustomSkinLoader " + loggerName));
    }

    static {
        loggers = new ConcurrentHashMap<String, Logger>();
    }
}

