/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.relocated.jankson;

import at.petrak.relocated.jankson.JsonElement;
import at.petrak.relocated.jankson.JsonGrammar;
import at.petrak.relocated.jankson.JsonPrimitive;
import at.petrak.relocated.jankson.api.Marshaller;
import at.petrak.relocated.jankson.impl.MarshallerImpl;
import at.petrak.relocated.jankson.impl.serializer.CommentSerializer;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class JsonArray
extends JsonElement
implements List<JsonElement>,
Iterable<JsonElement> {
    private List<Entry> entries = new ArrayList<Entry>();
    protected Marshaller marshaller = MarshallerImpl.getFallback();

    public JsonArray() {
    }

    public <T> JsonArray(T[] ts, Marshaller marshaller) {
        this.marshaller = marshaller;
        for (T t : ts) {
            this.add(marshaller.serialize(t));
        }
    }

    public JsonArray(Collection<?> ts, Marshaller marshaller) {
        this.marshaller = marshaller;
        for (Object t : ts) {
            this.add(marshaller.serialize(t));
        }
    }

    @Override
    public JsonElement get(int i) {
        return this.entries.get((int)i).value;
    }

    public String getString(int index, String defaultValue) {
        JsonElement elem = this.get(index);
        if (elem != null && elem instanceof JsonPrimitive) {
            return ((JsonPrimitive)elem).asString();
        }
        return defaultValue;
    }

    public boolean getBoolean(int index, boolean defaultValue) {
        JsonElement elem = this.get(index);
        if (elem != null && elem instanceof JsonPrimitive) {
            return ((JsonPrimitive)elem).asBoolean(defaultValue);
        }
        return defaultValue;
    }

    public byte getByte(int index, byte defaultValue) {
        JsonElement elem = this.get(index);
        if (elem != null && elem instanceof JsonPrimitive) {
            return ((JsonPrimitive)elem).asByte(defaultValue);
        }
        return defaultValue;
    }

    public char getChar(int index, char defaultValue) {
        JsonElement elem = this.get(index);
        if (elem != null && elem instanceof JsonPrimitive) {
            return ((JsonPrimitive)elem).asChar(defaultValue);
        }
        return defaultValue;
    }

    public short getShort(int index, short defaultValue) {
        JsonElement elem = this.get(index);
        if (elem != null && elem instanceof JsonPrimitive) {
            return ((JsonPrimitive)elem).asShort(defaultValue);
        }
        return defaultValue;
    }

    public int getInt(int index, int defaultValue) {
        JsonElement elem = this.get(index);
        if (elem != null && elem instanceof JsonPrimitive) {
            return ((JsonPrimitive)elem).asInt(defaultValue);
        }
        return defaultValue;
    }

    public long getLong(int index, long defaultValue) {
        JsonElement elem = this.get(index);
        if (elem != null && elem instanceof JsonPrimitive) {
            return ((JsonPrimitive)elem).asLong(defaultValue);
        }
        return defaultValue;
    }

    public float getFloat(int index, float defaultValue) {
        JsonElement elem = this.get(index);
        if (elem != null && elem instanceof JsonPrimitive) {
            return ((JsonPrimitive)elem).asFloat(defaultValue);
        }
        return defaultValue;
    }

    public double getDouble(int index, double defaultValue) {
        JsonElement elem = this.get(index);
        if (elem != null && elem instanceof JsonPrimitive) {
            return ((JsonPrimitive)elem).asDouble(defaultValue);
        }
        return defaultValue;
    }

    public String getComment(int i) {
        return this.entries.get(i).getComment();
    }

    public void setComment(int i, String comment) {
        this.entries.get(i).setComment(comment);
    }

    @Override
    public String toJson(boolean comments, boolean newlines, int depth) {
        JsonGrammar grammar = JsonGrammar.builder().withComments(comments).printWhitespace(newlines).build();
        return this.toJson(grammar, depth);
    }

    @Override
    public void toJson(Writer writer, JsonGrammar grammar, int depth) throws IOException {
        int effectiveDepth = grammar.bareRootObject ? depth - 1 : depth;
        writer.append("[");
        if (this.entries.size() > 0) {
            if (grammar.printWhitespace) {
                writer.append('\n');
            } else {
                writer.append(' ');
            }
        }
        for (int i = 0; i < this.entries.size(); ++i) {
            Entry entry = this.entries.get(i);
            if (grammar.printWhitespace) {
                for (int j = 0; j < effectiveDepth + 1; ++j) {
                    writer.append("\t");
                }
            }
            CommentSerializer.print(writer, entry.getComment(), effectiveDepth, grammar);
            writer.append(entry.value.toJson(grammar, depth + 1));
            if (grammar.printCommas) {
                if (i < this.entries.size() - 1 || grammar.printTrailingCommas) {
                    writer.append(",");
                    if (i < this.entries.size() - 1 && !grammar.printWhitespace) {
                        writer.append(' ');
                    }
                }
            } else {
                writer.append(" ");
            }
            if (!grammar.printWhitespace) continue;
            writer.append('\n');
        }
        if (this.entries.size() > 0 && grammar.printWhitespace && depth > 0) {
            for (int j = 0; j < effectiveDepth; ++j) {
                writer.append("\t");
            }
        }
        if (this.entries.size() > 0 && !grammar.printWhitespace) {
            writer.append(' ');
        }
        writer.append(']');
    }

    public String toString() {
        return this.toJson(true, false, 0);
    }

    public boolean add(@Nonnull JsonElement e, String comment) {
        Entry entry = new Entry();
        entry.value = e;
        entry.setComment(comment);
        this.entries.add(entry);
        return true;
    }

    @Override
    public boolean equals(Object other) {
        if (other == null || !(other instanceof JsonArray)) {
            return false;
        }
        List<Entry> a = this.entries;
        List<Entry> b = ((JsonArray)other).entries;
        if (a.size() != b.size()) {
            return false;
        }
        for (int i = 0; i < a.size(); ++i) {
            Entry ae = a.get(i);
            Entry be = b.get(i);
            if (!ae.value.equals(be.value)) {
                return false;
            }
            if (Objects.equals(ae.getComment(), be.getComment())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return this.entries.hashCode();
    }

    @Nullable
    public <E> E get(@Nonnull Class<E> clazz, int index) {
        JsonElement elem = this.get(index);
        return this.marshaller.marshall(clazz, elem);
    }

    public void setMarshaller(Marshaller marshaller) {
        this.marshaller = marshaller;
    }

    public Marshaller getMarshaller() {
        return this.marshaller;
    }

    @Override
    public JsonArray clone() {
        JsonArray result = new JsonArray();
        result.marshaller = this.marshaller;
        for (Entry entry : this.entries) {
            result.add(entry.value.clone(), entry.getComment());
        }
        return result;
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public boolean add(@Nonnull JsonElement e) {
        Entry entry = new Entry();
        entry.value = e;
        this.entries.add(entry);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends JsonElement> c) {
        boolean result = false;
        for (JsonElement jsonElement : c) {
            result |= this.add(jsonElement);
        }
        return result;
    }

    @Override
    public void clear() {
        this.entries.clear();
    }

    @Override
    public boolean contains(Object o) {
        if (o == null || !(o instanceof JsonElement)) {
            return false;
        }
        for (Entry entry : this.entries) {
            if (!entry.value.equals(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    @Override
    public boolean remove(Object o) {
        for (int i = 0; i < this.entries.size(); ++i) {
            Entry cur = this.entries.get(i);
            if (!cur.value.equals(o)) continue;
            this.entries.remove(i);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("removeAll not supported");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("retainAll not supported");
    }

    public JsonElement[] toArray() {
        JsonElement[] result = new JsonElement[this.entries.size()];
        for (int i = 0; i < this.entries.size(); ++i) {
            result[i] = this.entries.get((int)i).value;
        }
        return result;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a.length < this.entries.size()) {
            a = new Object[this.entries.size()];
        }
        for (int i = 0; i < this.entries.size(); ++i) {
            a[i] = this.entries.get((int)i).value;
        }
        if (a.length > this.entries.size()) {
            a[this.entries.size()] = null;
        }
        return a;
    }

    @Override
    public Iterator<JsonElement> iterator() {
        return new EntryIterator(this.entries);
    }

    @Override
    public void add(int index, JsonElement element) {
        this.entries.add(index, new Entry(element));
    }

    @Override
    public boolean addAll(int index, Collection<? extends JsonElement> elements) {
        if (elements.isEmpty()) {
            return false;
        }
        int i = index;
        for (JsonElement jsonElement : elements) {
            this.entries.add(i, new Entry(jsonElement));
            ++i;
        }
        return true;
    }

    @Override
    public int indexOf(Object obj) {
        if (obj == null) {
            return -1;
        }
        for (int i = 0; i < this.entries.size(); ++i) {
            JsonElement val = this.entries.get((int)i).value;
            if (val == null || !val.equals(obj)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object obj) {
        if (obj == null) {
            return -1;
        }
        for (int i = this.entries.size() - 1; i >= 0; --i) {
            JsonElement val = this.entries.get((int)i).value;
            if (val == null || !val.equals(obj)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public ListIterator<JsonElement> listIterator() {
        return new EntryIterator(this.entries);
    }

    @Override
    public ListIterator<JsonElement> listIterator(int index) {
        return new EntryIterator(this.entries, index);
    }

    @Override
    public JsonElement remove(int index) {
        return this.entries.remove((int)index).value;
    }

    @Override
    public JsonElement set(int index, JsonElement element) {
        Entry cur = new Entry(element);
        Entry old = this.entries.get(index);
        if (old != null) {
            cur.setComment(old.getComment());
        }
        this.entries.set(index, cur);
        return old == null ? null : old.value;
    }

    @Override
    public List<JsonElement> subList(int arg0, int arg1) {
        throw new UnsupportedOperationException();
    }

    private static class Entry {
        String comment;
        JsonElement value;

        public Entry() {
        }

        public Entry(JsonElement value) {
            this.value = value;
        }

        public boolean equals(Object other) {
            if (!(other instanceof Entry)) {
                return false;
            }
            Entry o = (Entry)other;
            return Objects.equals(this.comment, o.comment) && Objects.equals(this.value, o.value);
        }

        public String getComment() {
            return this.comment;
        }

        public void setComment(String comment) {
            this.comment = comment != null && !comment.trim().isEmpty() ? comment : null;
        }

        public int hashCode() {
            return Objects.hash(this.comment, this.value);
        }
    }

    private static class EntryIterator
    implements ListIterator<JsonElement> {
        private final ListIterator<Entry> delegate;

        public EntryIterator(List<Entry> list) {
            this.delegate = list.listIterator();
        }

        public EntryIterator(List<Entry> list, int index) {
            this.delegate = list.listIterator(index);
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public JsonElement next() {
            return this.delegate.next().value;
        }

        @Override
        public void remove() {
            this.delegate.remove();
        }

        @Override
        public void add(JsonElement elem) {
            this.delegate.add(new Entry(elem));
        }

        @Override
        public boolean hasPrevious() {
            return this.delegate.hasPrevious();
        }

        @Override
        public int nextIndex() {
            return this.delegate.nextIndex();
        }

        @Override
        public JsonElement previous() {
            return this.delegate.previous().value;
        }

        @Override
        public int previousIndex() {
            return this.delegate.previousIndex();
        }

        @Override
        public void set(JsonElement obj) {
            this.delegate.set(new Entry(obj));
        }
    }
}

