/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.paucal.api;

import at.petrak.paucal.api.contrib.Contributor;
import at.petrak.paucal.api.msg.PaucalMessage;
import at.petrak.paucal.common.ContributorsManifest;
import com.google.common.base.Suppliers;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface PaucalAPI {
    public static final String MOD_ID = "paucal";
    public static final String CONTRIBUTOR_URL = "https://raw.githubusercontent.com/gamma-delta/contributors/main/paucal/contributors-v01.json5";
    public static final String HEADPAT_AUDIO_URL_STUB = "https://raw.githubusercontent.com/gamma-delta/contributors/main/paucal/headpat-sounds/";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"paucal");
    public static final Supplier<PaucalAPI> INSTANCE = Suppliers.memoize(() -> {
        try {
            return (PaucalAPI)Class.forName("at.petrak.paucal.common.impl.PaucalAPIImpl").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            LOGGER.warn("Unable to find a PaucalAPIImpl, using a dummy");
            return new PaucalAPI(){};
        }
    });

    @Nullable
    default public Contributor getContributor(UUID uuid) {
        return ContributorsManifest.getContributor(uuid);
    }

    default public void sendPacketToPlayerC2S(ServerPlayer target, PaucalMessage packet) {
    }

    default public void sendPacketNearC2S(Vec3 pos, double radius, ServerLevel dimension, PaucalMessage packet) {
    }

    public static PaucalAPI instance() {
        return INSTANCE.get();
    }

    public static ResourceLocation modLoc(String s) {
        return new ResourceLocation(MOD_ID, s);
    }
}

