/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.recipes;

import com.mojang.serialization.DataResult;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.computer.items.IComputerItem;
import dan200.computercraft.shared.computer.recipe.ComputerConvertRecipe;
import dan200.computercraft.shared.recipe.ShapedRecipeSpec;
import dan200.computercraft.shared.turtle.items.TurtleItem;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;

public final class TurtleRecipe
extends ComputerConvertRecipe {
    private final TurtleItem turtle;

    private TurtleRecipe(ResourceLocation id, ShapedRecipeSpec recipe, TurtleItem turtle) {
        super(id, recipe);
        this.turtle = turtle;
    }

    public static DataResult<TurtleRecipe> of(ResourceLocation id, ShapedRecipeSpec recipe) {
        Item item = recipe.result().m_41720_();
        if (!(item instanceof TurtleItem)) {
            return DataResult.error(() -> String.valueOf(recipe.result().m_41720_()) + " is not a turtle item");
        }
        TurtleItem turtle = (TurtleItem)item;
        return DataResult.success((Object)((Object)new TurtleRecipe(id, recipe, turtle)));
    }

    @Override
    protected ItemStack convert(IComputerItem item, ItemStack stack) {
        int computerID = item.getComputerID(stack);
        String label = item.getLabel(stack);
        return this.turtle.create(computerID, label, -1, null, null, 0, null);
    }

    public RecipeSerializer<TurtleRecipe> m_7707_() {
        return (RecipeSerializer)ModRegistry.RecipeSerializers.TURTLE.get();
    }
}

