/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.recipe;

import com.google.gson.JsonObject;
import dan200.computercraft.shared.recipe.RecipeProperties;
import dan200.computercraft.shared.recipe.RecipeUtil;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public record ShapelessRecipeSpec(RecipeProperties properties, NonNullList<Ingredient> ingredients, ItemStack result) {
    public static ShapelessRecipeSpec fromJson(JsonObject json) {
        RecipeProperties properties = RecipeProperties.fromJson(json);
        NonNullList<Ingredient> ingredients = RecipeUtil.readShapelessIngredients(json);
        ItemStack result = RecipeUtil.itemStackFromJson(GsonHelper.m_13930_((JsonObject)json, (String)"result"));
        return new ShapelessRecipeSpec(properties, ingredients, result);
    }

    public static ShapelessRecipeSpec fromNetwork(FriendlyByteBuf buffer) {
        RecipeProperties properties = RecipeProperties.fromNetwork(buffer);
        NonNullList<Ingredient> ingredients = RecipeUtil.readIngredients(buffer);
        ItemStack result = buffer.m_130267_();
        return new ShapelessRecipeSpec(properties, ingredients, result);
    }

    public void toNetwork(FriendlyByteBuf buffer) {
        this.properties().toNetwork(buffer);
        RecipeUtil.writeIngredients(buffer, this.ingredients());
        buffer.m_130055_(this.result());
    }
}

