/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.redstone;

import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.core.redstone.RedstoneState;
import dan200.computercraft.impl.BundledRedstone;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.peripheral.redstone.RedstoneRelayPeripheral;
import dan200.computercraft.shared.util.DirectionUtil;
import dan200.computercraft.shared.util.RedstoneUtil;
import dan200.computercraft.shared.util.TickScheduler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public final class RedstoneRelayBlockEntity
extends BlockEntity {
    private final TickScheduler.Token tickToken = new TickScheduler.Token(this);
    private final RedstoneState redstoneState = new RedstoneState(() -> TickScheduler.schedule(this.tickToken));
    private final RedstoneRelayPeripheral peripheral = new RedstoneRelayPeripheral(this.redstoneState);
    private boolean updateAll = false;

    public RedstoneRelayBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)ModRegistry.BlockEntities.REDSTONE_RELAY.get(), pos, blockState);
    }

    public void m_6339_() {
        super.m_6339_();
        this.updateAll = true;
        TickScheduler.schedule(this.tickToken);
    }

    void update() {
        int changes = this.redstoneState.updateOutput();
        for (Direction direction : DirectionUtil.FACINGS) {
            if (!this.updateAll && (changes & 1 << this.mapSide(direction).ordinal()) == 0) continue;
            this.updateRedstoneTo(direction);
        }
        this.updateAll = false;
        if (this.redstoneState.pollInputChanged()) {
            this.peripheral.queueRedstoneEvent();
        }
    }

    void neighborChanged(BlockPos neighbour) {
        for (Direction dir : DirectionUtil.FACINGS) {
            BlockPos offset = this.m_58899_().m_121945_(dir);
            if (!offset.equals((Object)neighbour)) continue;
            this.updateRedstoneInput(dir, offset, false);
            return;
        }
        for (Direction dir : DirectionUtil.FACINGS) {
            this.updateRedstoneInput(dir, this.m_58899_().m_121945_(dir), false);
        }
    }

    private void updateRedstoneTo(Direction direction) {
        RedstoneUtil.propagateRedstoneOutput(this.m_58904_(), this.m_58899_(), direction);
        this.updateRedstoneInput(direction, this.m_58899_().m_121945_(direction), true);
    }

    private void updateRedstoneInput(Direction dir, BlockPos targetPos, boolean ticking) {
        boolean changed = this.redstoneState.setInput(this.mapSide(dir), RedstoneUtil.getRedstoneInput(this.m_58904_(), targetPos, dir), BundledRedstone.getOutput(this.m_58904_(), targetPos, dir.m_122424_()));
        if (changed && !ticking) {
            this.m_58904_().m_186460_(this.m_58899_(), this.m_58900_().m_60734_(), 0);
        }
    }

    private ComputerSide mapSide(Direction globalSide) {
        return DirectionUtil.toLocal((Direction)this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_), globalSide);
    }

    int getRedstoneOutput(Direction side) {
        return this.redstoneState.getExternalOutput(this.mapSide(side));
    }

    int getBundledRedstoneOutput(Direction side) {
        return this.redstoneState.getExternalBundledOutput(this.mapSide(side));
    }

    public IPeripheral peripheral() {
        return this.peripheral;
    }
}

