/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.util;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ThreadUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ThreadUtils.class);
    private static final ThreadGroup baseGroup = new ThreadGroup("ComputerCraft");
    public static final int LOWER_PRIORITY = 3;

    private ThreadUtils() {
    }

    public static ThreadGroup group() {
        return baseGroup;
    }

    public static ThreadFactoryBuilder builder(String name) {
        ThreadGroup group = new ThreadGroup(baseGroup, baseGroup.getName() + "-" + name);
        return new ThreadFactoryBuilder().setDaemon(true).setNameFormat(group.getName().replace("%", "%%") + "-%d").setUncaughtExceptionHandler((t, e) -> LOG.error("Exception in thread " + t.getName(), e)).setThreadFactory(x -> new Thread(group, x));
    }

    public static ThreadFactory factory(String name) {
        return ThreadUtils.builder(name).build();
    }

    public static ThreadFactory lowPriorityFactory(String name) {
        return ThreadUtils.builder(name).setPriority(3).build();
    }
}

