/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import dan200.computercraft.client.gui.NoTermComputerScreen;
import dan200.computercraft.client.render.CustomLecternRenderer;
import dan200.computercraft.core.terminal.Terminal;
import dan200.computercraft.shared.lectern.PocketComputerLecternMenu;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Vector2i;
import org.joml.Vector2ic;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.jspecify.annotations.Nullable;

public final class PocketComputerLecternScreen
extends NoTermComputerScreen<PocketComputerLecternMenu> {
    public PocketComputerLecternScreen(PocketComputerLecternMenu menu, Inventory player, Component title) {
        super(menu, player, title);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        Vector2ic position = this.getMousePosition();
        if (position != null) {
            this.computerInput.mouseClick(button + 1, position.x() + 1, position.y() + 1);
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        Vector2ic position = this.getMousePosition();
        if (position != null) {
            this.computerInput.mouseDrag(button + 1, position.x() + 1, position.y() + 1);
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        Vector2ic position = this.getMousePosition();
        if (position != null) {
            this.computerInput.mouseUp(button + 1, position.x() + 1, position.y() + 1);
            return true;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    @Override
    public boolean m_6050_(double moueX, double mouseY, double delta) {
        Vector2ic position = this.getMousePosition();
        if (position != null && delta != 0.0) {
            this.computerInput.mouseScroll(delta < 0.0 ? 1 : -1, position.x(), position.y());
            return true;
        }
        return super.m_6050_(moueX, mouseY, delta);
    }

    private @Nullable Vector2ic getMousePosition() {
        Minecraft minecraft = Objects.requireNonNull(this.f_96541_);
        if (minecraft.f_91073_ == null || minecraft.f_91074_ == null || minecraft.f_91077_ == null) {
            return null;
        }
        BlockPos lecternPos = ((PocketComputerLecternMenu)this.getMenu()).lectern();
        Terminal terminal = ((PocketComputerLecternMenu)this.getMenu()).getTerminal();
        if (minecraft.f_91077_.m_6662_() != HitResult.Type.BLOCK || !((BlockHitResult)minecraft.f_91077_).m_82425_().equals((Object)lecternPos)) {
            return null;
        }
        PoseStack poseStack = new PoseStack();
        CustomLecternRenderer.applyLecternTransform(poseStack, minecraft.f_91073_.m_8055_(lecternPos));
        CustomLecternRenderer.applyPocketComputerTerminalTransform(poseStack);
        CustomLecternRenderer.applyScaledPocketComputerTerminalTransform(poseStack, terminal);
        Matrix4f inverseTransform = poseStack.m_85850_().m_252922_().invert(new Matrix4f());
        Vec3 startPosition = minecraft.f_91074_.m_146892_();
        Vector3f transformedStartPosition = inverseTransform.transformPosition((float)(startPosition.m_7096_() - (double)lecternPos.m_123341_()), (float)(startPosition.m_7098_() - (double)lecternPos.m_123342_()), (float)(startPosition.m_7094_() - (double)lecternPos.m_123343_()), new Vector3f());
        Vector3f transformedLookVector = inverseTransform.transformDirection(minecraft.f_91074_.m_20154_().m_252839_());
        if (transformedLookVector.z() == 0.0f) {
            return null;
        }
        Vector3f intersection = transformedStartPosition.add((Vector3fc)transformedLookVector.mul(-transformedStartPosition.z() / transformedLookVector.z()));
        int positionX = (int)(intersection.x() / 6.0f);
        int positionY = (int)(intersection.y() / 9.0f);
        return positionX >= 0 && positionX < terminal.getWidth() && positionY >= 0 && positionY < terminal.getHeight() ? new Vector2i(positionX, positionY) : null;
    }
}

