/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.widgets;

import com.simibubi.create.foundation.gui.AllIcons;
import de.mrjulsen.crn.client.gui.CreateDynamicWidgets;
import de.mrjulsen.crn.client.gui.screen.TrainJourneyScreen;
import de.mrjulsen.crn.client.gui.widgets.StationDeparturesViewer;
import de.mrjulsen.crn.client.lang.CustomLanguage;
import de.mrjulsen.crn.data.navigation.ClientRoute;
import de.mrjulsen.crn.data.train.TrainStop;
import de.mrjulsen.crn.util.ModUtils;
import de.mrjulsen.mcdragonlib.client.gui.DLScreen;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLContextMenu;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLContextMenuItem;
import de.mrjulsen.mcdragonlib.client.render.DynamicGuiRenderer;
import de.mrjulsen.mcdragonlib.client.render.Sprite;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiAreaDefinition;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public class StationDeparturesWidget
extends DLButton
implements AutoCloseable {
    public static final int HEADER_HEIGHT = 20;
    public static final int DEFAULT_LINE_HEIGHT = 12;
    public static final float DEFAULT_SCALE = 0.75f;
    private final MutableComponent connectionInPast = CustomLanguage.translate("gui.createrailwaysnavigator.navigator.route_entry.connection_in_past");
    private final MutableComponent trainCanceled = CustomLanguage.translate("gui.createrailwaysnavigator.route_overview.stop_cancelled");
    private final ClientRoute route;
    private final boolean arrival;

    public StationDeparturesWidget(Screen parent, StationDeparturesViewer viewer, int x, int y, int width, ClientRoute route, boolean arrival) {
        super(x, y, width, 32, (Component)TextUtils.empty(), b -> DLScreen.setScreen((DLScreen)new TrainJourneyScreen(parent, route, route.getStart().getTrainId())));
        this.route = route;
        this.arrival = arrival;
        this.setRenderStyle(DynamicGuiRenderer.AreaStyle.FLAT);
        this.setMenu(new DLContextMenu(() -> GuiAreaDefinition.of((AbstractWidget)this), () -> new DLContextMenuItem.Builder().add(new DLContextMenuItem.ContextMenuItemData((Component)TextUtils.translate((String)"gui.createrailwaysnavigator.schedule_board.view_details"), Sprite.empty(), true, b -> this.f_93717_.m_93750_((Button)b), null))));
    }

    public void renderMainLayer(Graphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        MutableComponent stationText;
        CreateDynamicWidgets.renderSingleShadeWidget(graphics, this.x(), this.y(), this.width(), this.height(), CreateDynamicWidgets.ColorShade.DARK.getColor());
        if (this.isMouseSelected()) {
            GuiUtils.fill((Graphics)graphics, (int)this.x(), (int)this.y(), (int)this.width(), (int)this.height(), (int)0x22FFFFFF);
        }
        TrainStop currentStop = this.arrival ? this.route.getEnd() : this.route.getStart();
        float scale = 0.75f;
        MutableComponent trainName = TextUtils.text((String)currentStop.getTrainDisplayName()).m_130940_(ChatFormatting.BOLD);
        graphics.poseStack().m_85836_();
        graphics.poseStack().m_252880_((float)this.x(), (float)this.y(), 0.0f);
        graphics.poseStack().m_85841_(0.75f, 0.75f, 0.75f);
        if (this.arrival) {
            AllIcons.I_CONFIG_OPEN.render(graphics.graphics(), 8, 5);
        } else {
            AllIcons.I_CONFIG_BACK.render(graphics.graphics(), 8, 5);
        }
        if (this.route.isAnyCancelled()) {
            GuiUtils.drawString((Graphics)graphics, (Font)this.font, (int)((int)((float)(this.x() + this.width() - 5) / 0.75f)), (int)((int)((float)(this.y() + 15) / 0.75f)), (FormattedText)this.trainCanceled, (int)-48574, (EAlignment)EAlignment.RIGHT, (boolean)false);
        } else if (this.route.getStart().isDeparted()) {
            GuiUtils.drawString((Graphics)graphics, (Font)this.font, (int)((int)((float)(this.x() + this.width() - 5) / 0.75f)), (int)((int)((float)(this.y() + 15) / 0.75f)), (FormattedText)this.connectionInPast, (int)-48574, (EAlignment)EAlignment.RIGHT, (boolean)false);
        }
        CreateDynamicWidgets.renderTextHighlighted(graphics, 30, 6, this.font, (Component)trainName, currentStop.getTrainDisplayColor());
        graphics.poseStack().m_85849_();
        MutableComponent platformText = TextUtils.text((String)this.route.getStart().getRealTimeStationTag().info().platform());
        int maxStationNameWidth = this.width() - 6 - (int)((float)(45 + this.font.m_92852_((FormattedText)trainName)) * 0.75f);
        MutableComponent mutableComponent = stationText = this.arrival ? TextUtils.translate((String)"gui.createrailwaysnavigator.schedule_board.train_from", (Object[])new Object[]{this.route.getEnd().getRealTimeStationTag().tagName()}) : TextUtils.text((String)this.route.getStart().getDisplayTitle());
        if (this.font.m_92852_((FormattedText)stationText) > maxStationNameWidth) {
            stationText = TextUtils.text((String)this.font.m_92854_((FormattedText)stationText, maxStationNameWidth).getString()).m_7220_((Component)TextUtils.text((String)"...")).m_130948_(stationText.m_7383_());
        }
        GuiUtils.drawString((Graphics)graphics, (Font)this.font, (int)(this.x() + (int)((float)(45 + this.font.m_92852_((FormattedText)trainName)) * 0.75f)), (int)(this.y() + 6), (FormattedText)stationText, (int)0xFFFFFF, (EAlignment)EAlignment.LEFT, (boolean)false);
        GuiUtils.drawString((Graphics)graphics, (Font)this.font, (int)(this.x() + this.width() - 6), (int)(this.y() + 20), (FormattedText)platformText, (int)-1, (EAlignment)EAlignment.RIGHT, (boolean)false);
        GuiUtils.drawString((Graphics)graphics, (Font)this.font, (int)(this.x() + 22), (int)(this.y() + 20), (String)ModUtils.formatTime(this.arrival ? this.route.getStart().getScheduledArrivalTime() : this.route.getStart().getScheduledDepartureTime(), false), (int)0xFFFFFF, (EAlignment)EAlignment.LEFT, (boolean)false);
        GuiUtils.drawString((Graphics)graphics, (Font)this.font, (int)(this.x() + 22 + 40), (int)(this.y() + 20), (String)ModUtils.formatTime(this.arrival ? this.route.getStart().getRealTimeArrivalTime() : this.route.getStart().getRealTimeDepartureTime(), false), (int)((this.arrival ? this.route.getStart().isArrivalDelayed() : this.route.getStart().isDepartureDelayed()) ? -48574 : -15013281), (EAlignment)EAlignment.LEFT, (boolean)false);
    }

    @Override
    public void close() {
        this.route.closeAll();
    }
}

