/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.inline.utils;

import com.samsthenerd.inline.utils.SpriteUVRegion;
import java.util.Arrays;

@FunctionalInterface
public interface SpriteUVLens {
    public SpriteUVRegion focusUVs(SpriteUVRegion var1, long var2);

    default public SpriteUVRegion genUVs(long time) {
        return this.focusUVs(SpriteUVRegion.FULL, time);
    }

    public static SpriteUVRegion identity(SpriteUVRegion uvs, long time) {
        return uvs;
    }

    default public SpriteUVLens andThen(SpriteUVLens lens) {
        if (lens == null) {
            return this;
        }
        return (uvs, time) -> lens.focusUVs(this.focusUVs(uvs, time), time);
    }

    public static long getSysTime() {
        return System.nanoTime() / 1000000L;
    }

    public record AnimUVLens(double frameSize, boolean isVertical, int[] delays, int totalLength) implements SpriteUVLens
    {
        public AnimUVLens(double frameSize, boolean isVertical, int[] delays) {
            this(frameSize, isVertical, delays, Arrays.stream(delays).sum());
        }

        @Override
        public SpriteUVRegion focusUVs(SpriteUVRegion uvs, long time) {
            int i;
            if (this.totalLength == 0) {
                return uvs;
            }
            long currentMS = time % (long)this.totalLength;
            int delayAcc = 0;
            for (i = 0; i < this.delays.length && (long)(delayAcc += this.delays[i]) < currentMS; ++i) {
            }
            double minFP = Math.max(this.frameSize() * (double)i, 0.0);
            double maxFP = Math.min(this.frameSize() * (double)(i + 1), 1.0);
            SpriteUVRegion frameUVs = this.isVertical() ? new SpriteUVRegion(0.0, minFP, 1.0, maxFP) : new SpriteUVRegion(minFP, 0.0, maxFP, 1.0);
            return uvs.focusWith(frameUVs);
        }
    }
}

