/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.inline.utils;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public abstract class EntityCradle {
    private static final Map<ResourceLocation, CradleType<? extends EntityCradle>> CRADLES = new HashMap<ResourceLocation, CradleType<? extends EntityCradle>>();
    private static final Codec<CradleType<?>> TYPE_CODEC = ResourceLocation.f_135803_.comapFlatMap(id -> {
        if (CRADLES.containsKey(id)) {
            return DataResult.success(CRADLES.get(id));
        }
        return DataResult.error(() -> "No entity cradle type: " + id.toString());
    }, type -> type.getId());
    public static final Codec<EntityCradle> CRADLE_CODEC = TYPE_CODEC.dispatch("type", EntityCradle::getType, CradleType::getCodec);

    public abstract CradleType<?> getType();

    @Nullable
    public abstract Entity getEntity(Level var1);

    public String getId() {
        return null;
    }

    public static <T extends CradleType> T addCradleType(T cradleType) {
        CRADLES.put(cradleType.getId(), cradleType);
        return cradleType;
    }

    public static interface CradleType<C extends EntityCradle> {
        public ResourceLocation getId();

        public Codec<C> getCodec();
    }
}

