/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.inline.tooltips;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.samsthenerd.inline.Inline;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class CustomTooltipManager {
    public static final Item HIJACKED_ITEM = Items.f_42402_;
    private static final Map<ResourceLocation, CustomTooltipProvider> PROVIDERS = new HashMap<ResourceLocation, CustomTooltipProvider>();

    public static <T> ItemStack getForTooltip(CustomTooltipProvider<T> provider, T content) {
        ItemStack stack = new ItemStack((ItemLike)HIJACKED_ITEM);
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("id", provider.getId().toString());
        tag.m_128365_("data", (Tag)provider.getCodec().encodeStart((DynamicOps)NbtOps.f_128958_, content).getOrThrow(false, arg_0 -> ((Logger)Inline.LOGGER).error(arg_0)));
        stack.m_41700_("inlinecustomtooltip", (Tag)tag);
        return stack;
    }

    @Nullable
    public static CustomTooltipProvider<?> getProvider(ItemStack stack) {
        CompoundTag tag = stack.m_41737_("inlinecustomtooltip");
        try {
            return PROVIDERS.get(new ResourceLocation(tag.m_128461_("id")));
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public static <T> List<Component> getTooltipText(ItemStack stack) {
        try {
            CompoundTag tag = stack.m_41737_("inlinecustomtooltip");
            CustomTooltipProvider<?> provider = CustomTooltipManager.getProvider(stack);
            DataResult contentRes = provider.getCodec().parse((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128423_("data"));
            Object content = contentRes.resultOrPartial(arg_0 -> ((Logger)Inline.LOGGER).error(arg_0)).orElseThrow();
            return provider.getTooltipText(content);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public static <T> Optional<TooltipComponent> getTooltipData(ItemStack stack) {
        try {
            CompoundTag tag = stack.m_41737_("inlinecustomtooltip");
            CustomTooltipProvider<?> provider = CustomTooltipManager.getProvider(stack);
            DataResult contentRes = provider.getCodec().parse((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128423_("data"));
            Object content = contentRes.resultOrPartial(arg_0 -> ((Logger)Inline.LOGGER).error(arg_0)).orElseThrow();
            return provider.getTooltipData(content);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T> CustomTooltipProvider<T> registerProvider(CustomTooltipProvider<T> provider) {
        PROVIDERS.put(provider.getId(), provider);
        return provider;
    }

    public static interface CustomTooltipProvider<T> {
        public ResourceLocation getId();

        @NotNull
        public List<Component> getTooltipText(T var1);

        @NotNull
        public Optional<TooltipComponent> getTooltipData(T var1);

        @NotNull
        public Codec<T> getCodec();
    }
}

