/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.inline.forge.xplat;

import com.samsthenerd.inline.xplat.IModMeta;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.moddiscovery.ModFileInfo;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.forgespi.language.IModInfo;
import org.jetbrains.annotations.NotNull;

public class ForgeModMeta
implements IModMeta {
    private final ModContainer container;
    private final IModInfo info;

    public ForgeModMeta(String id) {
        this.container = (ModContainer)ModList.get().getModContainerById(id).orElseThrow();
        this.info = ModList.get().getMods().stream().filter(modInfo -> Objects.equals(modInfo.getModId(), id)).findAny().orElseThrow();
    }

    public static Optional<IModMeta> getMod(String modid) {
        try {
            return Optional.of(new ForgeModMeta(modid));
        }
        catch (NoSuchElementException e) {
            return Optional.empty();
        }
    }

    @Override
    @NotNull
    public String getModId() {
        return this.info.getModId();
    }

    @Override
    @NotNull
    public String getVersion() {
        return this.info.getVersion().toString();
    }

    @Override
    @NotNull
    public String getName() {
        return this.info.getDisplayName();
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.info.getDescription();
    }

    @Override
    public Optional<String> getLogoFile(int i) {
        return this.info.getLogoFile();
    }

    @Override
    public List<Path> getFilePaths() {
        return List.of(this.getFilePath());
    }

    @Override
    public Path getFilePath() {
        return this.info.getOwningFile().getFile().getSecureJar().getRootPath();
    }

    @Override
    public Optional<Path> findResource(String ... path) {
        return Optional.of(this.info.getOwningFile().getFile().findResource(path)).filter(x$0 -> Files.exists(x$0, new LinkOption[0]));
    }

    @Override
    public Collection<String> getAuthors() {
        Optional<String> optional = this.info.getConfig().getConfigElement(new String[]{"authors"}).map(String::valueOf);
        return optional.isPresent() ? Collections.singleton(optional.get()) : Collections.emptyList();
    }

    @Override
    @Nullable
    public Collection<String> getLicense() {
        return Collections.singleton(this.info.getOwningFile().getLicense());
    }

    @Override
    public Optional<String> getHomepage() {
        return this.info.getConfig().getConfigElement(new String[]{"displayURL"}).map(String::valueOf);
    }

    @Override
    public Optional<String> getSources() {
        return Optional.empty();
    }

    @Override
    public Optional<String> getIssueTracker() {
        IModFileInfo owningFile = this.info.getOwningFile();
        if (owningFile instanceof ModFileInfo) {
            ModFileInfo info = (ModFileInfo)owningFile;
            return Optional.ofNullable(info.getIssueURL()).map(URL::toString);
        }
        return Optional.empty();
    }
}

