/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.inline.api.client.renderers;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.vertex.PoseStack;
import com.samsthenerd.inline.api.client.GlowHandling;
import com.samsthenerd.inline.api.client.InlineRenderer;
import com.samsthenerd.inline.api.client.renderers.InlineSpriteRenderer;
import com.samsthenerd.inline.api.data.PlayerHeadData;
import com.samsthenerd.inline.api.data.SpriteInlineData;
import com.samsthenerd.inline.utils.FakeClientPlayerMaker;
import com.samsthenerd.inline.utils.TextureSprite;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;

public class PlayerHeadRenderer
implements InlineRenderer<PlayerHeadData> {
    public static final PlayerHeadRenderer INSTANCE = new PlayerHeadRenderer();

    @Override
    public ResourceLocation getId() {
        return new ResourceLocation("inline", "playerhead");
    }

    public ResourceLocation textureFromHeadData(PlayerHeadData data) {
        GameProfile prof = FakeClientPlayerMaker.getBetterProfile(data.profile);
        ResourceLocation skinTextId = prof == null ? DefaultPlayerSkin.m_118627_((UUID)UUIDUtil.m_235875_((GameProfile)data.profile)) : Minecraft.m_91087_().m_91109_().m_240306_(prof);
        return skinTextId;
    }

    public SpriteInlineData getFace(PlayerHeadData data) {
        TextureSprite faceSprite = TextureSprite.fromPixels(this.textureFromHeadData(data), 8, 8, 8, 8, 64, 64);
        return new SpriteInlineData(faceSprite);
    }

    public SpriteInlineData getOuter(PlayerHeadData data) {
        TextureSprite faceSprite = TextureSprite.fromPixels(this.textureFromHeadData(data), 40, 8, 8, 8, 64, 64);
        return new SpriteInlineData(faceSprite);
    }

    @Override
    public int render(PlayerHeadData data, GuiGraphics context, int index, Style style, int codepoint, InlineRenderer.TextRenderingContext trContext) {
        SpriteInlineData faceSpriteData = this.getFace(data);
        PoseStack matrices = context.m_280168_();
        matrices.m_85836_();
        matrices.m_85837_(0.25, 0.25, 0.0);
        matrices.m_85841_(0.9411765f, 0.9411765f, 1.0f);
        InlineSpriteRenderer.INSTANCE.render(faceSpriteData, context, index, style, codepoint, trContext);
        matrices.m_85849_();
        SpriteInlineData outerSpriteData = this.getOuter(data);
        matrices.m_85836_();
        matrices.m_252880_(0.0f, 0.0f, 10.0f);
        int res = InlineSpriteRenderer.INSTANCE.render(outerSpriteData, context, index, style, codepoint, trContext);
        matrices.m_85849_();
        return res;
    }

    @Override
    public int charWidth(PlayerHeadData data, Style style, int codepoint) {
        return 8;
    }

    @Override
    public GlowHandling getGlowPreference(PlayerHeadData forData) {
        if (forData.profile.getName() != null) {
            return new GlowHandling.Full(forData.profile.getName().toLowerCase());
        }
        if (forData.profile.getId() != null) {
            return new GlowHandling.Full(forData.profile.getId().toString().toLowerCase());
        }
        return new GlowHandling.Full();
    }
}

